/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ui.internal.rest.v1;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ui.internal.RequestNLS;
import com.ibm.ws.ui.internal.rest.AdminCenterRestHandler;
import com.ibm.ws.ui.internal.rest.CommonRESTHandler;
import com.ibm.ws.ui.internal.rest.exceptions.NoSuchResourceException;
import com.ibm.ws.ui.internal.rest.exceptions.RESTException;
import com.ibm.ws.ui.internal.rest.exceptions.ResourceNoContentException;
import com.ibm.ws.ui.internal.rest.exceptions.UserNotAuthorizedException;
import com.ibm.ws.ui.internal.rest.v1.V1Constants;
import com.ibm.ws.ui.internal.v1.IToolDataService;
import com.ibm.ws.ui.internal.v1.IToolbox;
import com.ibm.ws.ui.internal.v1.IToolboxService;
import com.ibm.ws.ui.internal.v1.pojo.ToolEntry;
import com.ibm.ws.ui.internal.v1.utils.Utils;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ToolDataAPI
extends CommonRESTHandler
implements V1Constants {
    private final IToolDataService toolDataService;
    private final IToolboxService toolboxService;
    private static final TraceComponent tc = Tr.register(ToolDataAPI.class);

    public ToolDataAPI(IToolDataService toolDataService, IToolboxService toolboxService) {
        super("/adminCenter/v1/tooldata", true, false);
        this.toolDataService = toolDataService;
        this.toolboxService = toolboxService;
    }

    @Override
    public boolean isKnownChildResource(String child, RESTRequest request) {
        IToolbox tb = this.toolboxService.getToolbox(request.getUserPrincipal().getName());
        List<ToolEntry> ts = tb.getToolEntries();
        boolean found = false;
        if (ts == null || ts.size() == 0) {
            return false;
        }
        for (int i = 0; i < ts.size() && !found; ++i) {
            String toolname;
            ToolEntry te = ts.get(i);
            if (!te.getType().equals("featureTool") || (toolname = this.getToolNameFromToolID(te.getId())) == null) continue;
            found = toolname.equals(child);
        }
        return found;
    }

    @Override
    public Object getChild(RESTRequest request, RESTResponse response, String child) throws RESTException {
        if (!this.isAuthorizedAdminOrReader(request, response)) {
            throw new UserNotAuthorizedException();
        }
        if (this.isKnownChildResource(child, request)) {
            this.toolDataService.promoteIfPossible(request.getUserPrincipal().getName(), child);
            String object = this.toolDataService.getToolData(request.getUserPrincipal().getName(), child);
            if (object != null) {
                if (!Utils.isValidJsonString(object.toString())) {
                    throw new RESTException(500);
                }
                String md5 = Utils.getMD5String(object.toString());
                response.setResponseHeader("ETag", md5);
                return object;
            }
            throw new ResourceNoContentException();
        }
        throw new NoSuchResourceException();
    }

    @Override
    public AdminCenterRestHandler.POSTResponse postChild(RESTRequest request, RESTResponse response, String child) throws RESTException {
        if (!this.isAuthorizedAdminOrReader(request, response)) {
            throw new UserNotAuthorizedException();
        }
        if (this.isKnownChildResource(child, request)) {
            try {
                this.toolDataService.promoteIfPossible(request.getUserPrincipal().getName(), child);
                boolean exists = this.toolDataService.exists(request.getUserPrincipal().getName(), child);
                if (exists) {
                    throw new RESTException(409);
                }
                String tooldata = this.getReaderContents(request.getInputStream(), 8192);
                if (!Utils.isValidJsonString(tooldata)) {
                    throw new RESTException(500);
                }
                String td = this.toolDataService.addToolData(request.getUserPrincipal().getName(), child, tooldata);
                if (td == null) {
                    throw new RESTException(500);
                }
                AdminCenterRestHandler.POSTResponse postResponse = new AdminCenterRestHandler.POSTResponse();
                postResponse.createdURL = request.getURL() + "/" + child;
                postResponse.jsonPayload = td;
                String md5 = Utils.getMD5String(td);
                response.setResponseHeader("ETag", md5);
                return postResponse;
            }
            catch (IOException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unexpected IOException while reading RESTRequest payload", (Object[])new Object[]{e});
                }
                throw new RESTException(500);
            }
        }
        throw new NoSuchResourceException();
    }

    @Override
    public Object deleteChild(RESTRequest request, RESTResponse response, String child) throws RESTException {
        if (!this.isAuthorizedAdminOrReader(request, response)) {
            throw new UserNotAuthorizedException();
        }
        if (this.isKnownChildResource(child, request)) {
            String uid = request.getUserPrincipal().getName();
            boolean exists = this.toolDataService.exists(uid, child);
            if (!exists) {
                throw new NoSuchResourceException();
            }
            if (this.toolDataService.deleteToolData(uid, child)) {
                return "";
            }
            throw new RESTException(500, "text/plain", RequestNLS.formatMessage(tc, "TOOLDATA_DELETE_UNSUCCESSFUL", uid, child));
        }
        throw new NoSuchResourceException();
    }

    @Override
    public Object putChild(RESTRequest request, RESTResponse response, String child) throws RESTException {
        if (!this.isAuthorizedAdminOrReader(request, response)) {
            throw new UserNotAuthorizedException();
        }
        if (this.isKnownChildResource(child, request)) {
            try {
                String md5In = request.getHeader("If-Match");
                if (md5In == null) {
                    throw new RESTException(412);
                }
                boolean exists = this.toolDataService.exists(request.getUserPrincipal().getName(), child);
                if (!exists) {
                    throw new NoSuchResourceException();
                }
                String originalData = this.toolDataService.getToolData(request.getUserPrincipal().getName(), child);
                if (!Utils.isValidJsonString(originalData.toString())) {
                    throw new RESTException(500);
                }
                String md5 = Utils.getMD5String(originalData.toString());
                if (!md5In.equals(md5)) {
                    throw new RESTException(412, "text/plain", RequestNLS.formatMessage(tc, "TOOLDATA_UPDATE_CHECKSUM_NOT_MATCH", request.getUserPrincipal().getName(), child));
                }
                String tooldata = this.getReaderContents(request.getInputStream(), 8192);
                if (!Utils.isValidJsonString(tooldata)) {
                    throw new RESTException(500);
                }
                String td = this.toolDataService.addToolData(request.getUserPrincipal().getName(), child, tooldata);
                if (td == null) {
                    throw new RESTException(500);
                }
                md5 = Utils.getMD5String(td);
                response.setResponseHeader("ETag", md5);
                return td;
            }
            catch (IOException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unexpected IOException while reading RESTRequest payload", (Object[])new Object[]{e});
                }
                throw new RESTException(500);
            }
        }
        throw new NoSuchResourceException();
    }

    private String getToolNameFromToolID(String toolID) {
        Pattern pattern = Pattern.compile("(.*)-\\d+\\.\\d+-\\d+\\.\\d+\\.\\d+");
        Matcher matcher = pattern.matcher(toolID);
        if (matcher.matches() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        Tr.error((TraceComponent)tc, (String)"UNABLE_TO_PARSE_TOOL_ID", (Object[])new Object[]{toolID});
        return null;
    }
}

