/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.client.jose4j.util;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.crypto.HashUtils;
import com.ibm.ws.security.common.jwk.impl.JwKRetriever;
import com.ibm.ws.security.common.web.WebSSOUtils;
import com.ibm.ws.security.jwt.config.JwtConsumerConfig;
import com.ibm.ws.security.jwt.utils.JweHelper;
import com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase;
import com.ibm.ws.security.openidconnect.clients.common.AttributeToSubject;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.JtiNonceCache;
import com.ibm.ws.security.openidconnect.clients.common.OIDCClientAuthenticatorUtil;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientRequest;
import com.ibm.ws.security.openidconnect.clients.common.OidcSessionCache;
import com.ibm.ws.security.openidconnect.clients.common.OidcSessionInfo;
import com.ibm.ws.security.openidconnect.clients.common.OidcUtil;
import com.ibm.ws.security.openidconnect.clients.common.UserInfoHelper;
import com.ibm.ws.security.openidconnect.jose4j.Jose4jValidator;
import com.ibm.ws.security.openidconnect.token.JWTTokenValidationFailedException;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import com.ibm.wsspi.ssl.SSLSupport;
import io.openliberty.security.common.jwt.JwtParsingUtils;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.Subject;
import javax.servlet.http.Cookie;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.HmacKey;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Jose4jUtil {
    private static final TraceComponent tc = Tr.register(Jose4jUtil.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
    private static final String SIGNATURE_ALG_HS = "HS";
    private static final String SIGNATURE_ALG_RS = "RS";
    private static final String SIGNATURE_ALG_ES = "ES";
    private static final String SIGNATURE_ALG_NONE = "none";
    private final SSLSupport sslSupport;
    private static final JtiNonceCache jtiCache = new JtiNonceCache();
    WebSSOUtils webSsoUtils = new WebSSOUtils();
    static final long serialVersionUID = 6600997357160926049L;

    public Jose4jUtil(SSLSupport sslSupport) {
        this.sslSupport = sslSupport;
    }

    private JwtClaims getClaimsFromAccessToken(String accessTokenStr) throws Exception {
        JwtClaims jwtClaims = null;
        String[] parts = accessTokenStr.split(Pattern.quote("."));
        if (parts.length > 1) {
            String claimsAsJsonString = new String(Base64.getDecoder().decode(parts[1]), "UTF-8");
            jwtClaims = JwtClaims.parse((String)claimsAsJsonString);
        }
        return jwtClaims;
    }

    private JwtClaims getClaimsFromIdToken(String tokenStr, ConvergedClientConfig clientConfig, OidcClientRequest oidcClientRequest) throws Exception {
        String clientId = clientConfig.getClientId();
        JwtContext jwtContext = this.validateJwtStructureAndGetContext(tokenStr, clientConfig);
        JwtClaims jwtClaims = this.parseJwtWithValidation(clientConfig, jwtContext.getJwt(), jwtContext, oidcClientRequest);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("post jwtClaims: " + jwtClaims + " firstPass jwtClaims=" + jwtContext.getJwtClaims()), (Object[])new Object[0]);
        }
        return jwtClaims;
    }

    private JwtClaims getClaimsFromUserInfo(String userInfoStr) throws Exception {
        return JwtClaims.parse((String)userInfoStr);
    }

    private OidcTokenImplBase getOidcToken(JwtClaims jwtClaims, String accessToken, String refreshToken, String clientId, String tokenTypeNoSpace) {
        return new OidcTokenImplBase(jwtClaims, accessToken, refreshToken, clientId, tokenTypeNoSpace);
    }

    @FFDCIgnore(value={Exception.class})
    public ProviderAuthenticationResult createResultWithJose4J(String responseState, Map<String, String> tokens, ConvergedClientConfig clientConfig, OidcClientRequest oidcClientRequest, SSLSocketFactory sslSocketFactory) {
        String idTokenStr;
        ProviderAuthenticationResult oidcResult = null;
        String originalIdTokenString = idTokenStr = this.getIdToken(tokens, clientConfig);
        String accessTokenStr = tokens.get("access_token");
        String refreshTokenStr = tokens.get("refresh_token");
        String clientId = clientConfig.getClientId();
        Hashtable<String, Object> customProperties = new Hashtable<String, Object>();
        List<String> tokensOrderToFetchCallerClaims = clientConfig.getTokenOrderToFetchCallerClaims();
        try {
            String nonceInIDToken;
            boolean bNonceVerified;
            String userName;
            JwtClaims userInfoClaims;
            String userInfoStr;
            OidcTokenImplBase idToken;
            HashMap<String, JwtClaims> tokenClaimsMap;
            block28: {
                if ((idTokenStr == null || idTokenStr.isEmpty()) && tokensOrderToFetchCallerClaims.size() == 1) {
                    Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_IDTOKEN_REQUEST_FAILURE", (Object[])new Object[]{clientId, clientConfig.getTokenEndpointUrl()});
                    return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
                }
                tokenClaimsMap = new HashMap<String, JwtClaims>();
                JwtClaims idTokenClaims = this.getClaimsFromIdToken(idTokenStr, clientConfig, oidcClientRequest);
                idToken = this.getOidcToken(idTokenClaims, accessTokenStr, refreshTokenStr, clientId, "IDToken");
                String sub = idToken.getSubject();
                if (sub == null) {
                    return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
                }
                tokenClaimsMap.put("IDToken", idTokenClaims);
                UserInfoHelper userInfoHelper = new UserInfoHelper(clientConfig, this.sslSupport);
                userInfoStr = userInfoHelper.getUserInfoIfPossible(sub, accessTokenStr, sslSocketFactory, oidcClientRequest);
                userInfoClaims = null;
                if (userInfoStr != null) {
                    try {
                        userInfoClaims = this.getClaimsFromUserInfo(userInfoStr);
                    }
                    catch (Exception e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block28;
                        Tr.debug((TraceComponent)tc, (String)("Invalid user info: " + userInfoStr), (Object[])new Object[0]);
                    }
                }
            }
            if (tokensOrderToFetchCallerClaims.size() > 1 && tokensOrderToFetchCallerClaims.contains("AccessToken")) {
                JwtClaims accessTokenClaims = this.getClaimsFromAccessToken(accessTokenStr);
                tokenClaimsMap.put("AccessToken", accessTokenClaims);
                if (userInfoStr != null) {
                    tokenClaimsMap.put("UserInfo", userInfoClaims);
                }
            }
            if ((userName = this.getUserName(clientConfig, tokensOrderToFetchCallerClaims, tokenClaimsMap)) == null || userName.isEmpty()) {
                return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
            }
            boolean isImplicit = "implicit".equals(clientConfig.getGrantType());
            if ((clientConfig.isNonceEnabled() || isImplicit) && !(bNonceVerified = OidcUtil.verifyNonce(oidcClientRequest, nonceInIDToken = idToken.getNonce(), clientConfig, responseState))) {
                Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_REQUEST_NONCE_FAILED", (Object[])new Object[]{clientId, nonceInIDToken});
                return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
            }
            if (clientConfig.isSocial()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"social login flow, storing id token in result", (Object[])new Object[0]);
                }
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                props.put("id_token", originalIdTokenString);
                props.put("access_token", accessTokenStr);
                if (refreshTokenStr != null) {
                    props.put("refresh_token", refreshTokenStr);
                }
                if (idToken != null) {
                    props.put("id_token_object", idToken);
                }
                if (userInfoStr != null) {
                    props.put("userinfo_string", userInfoStr);
                }
                oidcResult = new ProviderAuthenticationResult(AuthResult.SUCCESS, 200, null, null, props, null);
                this.createWASOidcSession(oidcClientRequest, idToken.getJwtClaims(), clientConfig);
                return oidcResult;
            }
            if (!clientConfig.isMapIdentityToRegistryUser()) {
                String realm = this.getRealmName(clientConfig, tokensOrderToFetchCallerClaims, tokenClaimsMap);
                if (realm != null && !realm.isEmpty()) {
                    customProperties.put("com.ibm.wsspi.security.cred.realm", realm);
                }
                String uniqueSecurityName = this.getUniqueSecurityName(clientConfig, tokensOrderToFetchCallerClaims, tokenClaimsMap, userName);
                List<String> groups = this.getGroups(clientConfig, tokensOrderToFetchCallerClaims, tokenClaimsMap, realm);
                if (groups != null && !groups.isEmpty()) {
                    customProperties.put("com.ibm.wsspi.security.cred.groups", groups);
                }
                String uniqueID = new StringBuffer("user:").append(realm).append("/").append(uniqueSecurityName).toString();
                customProperties.put("com.ibm.wsspi.security.cred.uniqueId", uniqueID);
            }
            if (clientConfig.isIncludeCustomCacheKeyInSubject() || clientConfig.isDisableLtpaCookie()) {
                String customCacheKey = oidcClientRequest.getAndSetCustomCacheKeyValue();
                if (clientConfig.isIncludeCustomCacheKeyInSubject()) {
                    customProperties.put("com.ibm.wsspi.security.cred.cacheKey", customCacheKey);
                }
                customProperties.put("com.ibm.ws.authentication.internal.assertion", Boolean.TRUE);
            }
            Subject subject = null;
            if (clientConfig.isIncludeIdTokenInSubject()) {
                subject = new Subject();
                subject.getPrivateCredentials().add(idToken);
                customProperties.putAll(tokens);
            } else {
                if (refreshTokenStr != null) {
                    customProperties.put("refresh_token", refreshTokenStr);
                }
                if (accessTokenStr != null) {
                    customProperties.put("access_token", accessTokenStr);
                }
            }
            if (idToken != null) {
                customProperties.put("id_token_object", idToken);
            }
            if (userInfoStr != null) {
                customProperties.put("userinfo_string", userInfoStr);
            }
            customProperties.put("com.ibm.wssi.security.oidc.client.credential.storing.utc.time.milliseconds", new Date().getTime());
            oidcResult = new ProviderAuthenticationResult(AuthResult.SUCCESS, 200, userName, subject, customProperties, null);
            if (oidcResult.getStatus() == AuthResult.SUCCESS) {
                this.createWASOidcSession(oidcClientRequest, idToken.getJwtClaims(), clientConfig);
            }
        }
        catch (Exception e) {
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_IDTOKEN_VERIFY_ERR", (Object[])new Object[]{e.getLocalizedMessage(), clientId});
            oidcResult = new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
        return oidcResult;
    }

    private void createWASOidcSession(OidcClientRequest oidcClientRequest, @Sensitive JwtClaims jwtClaims, ConvergedClientConfig clientConfig) throws MalformedClaimException {
        String configId = HashUtils.digest((String)clientConfig.getId());
        String iss = HashUtils.digest((String)jwtClaims.getIssuer());
        String sub = HashUtils.digest((String)jwtClaims.getSubject());
        String sid = HashUtils.digest((String)((String)jwtClaims.getClaimValue("sid", String.class)));
        String exp = String.valueOf(jwtClaims.getExpirationTime().getValueInMillis());
        OidcSessionInfo sessionInfo = new OidcSessionInfo(configId, iss, sub, sid, exp, clientConfig);
        OidcSessionCache oidcSessionCache = clientConfig.getOidcSessionCache();
        oidcSessionCache.insertSession(sessionInfo);
        String wasOidcSessionId = sessionInfo.getSessionId();
        Cookie cookie = this.webSsoUtils.createCookie("WASOidcSession", wasOidcSessionId, oidcClientRequest.getRequest());
        cookie.setSecure(true);
        oidcClientRequest.getResponse().addCookie(cookie);
    }

    String getIdToken(Map<String, String> tokens, ConvergedClientConfig clientConfig) {
        if (tokens == null) {
            return null;
        }
        String idToken = tokens.get("id_token");
        if (idToken == null && this.useAccessTokenAsIdToken(clientConfig)) {
            idToken = tokens.get("access_token");
        }
        return idToken;
    }

    boolean useAccessTokenAsIdToken(ConvergedClientConfig clientConfig) {
        return clientConfig.getUseAccessTokenAsIdToken();
    }

    public void checkJwtFormatAgainstConfigRequirements(String jwtString, ConvergedClientConfig clientConfig) throws JWTTokenValidationFailedException {
        if (JweHelper.isJwsRequired((JwtConsumerConfig)clientConfig) && !JweHelper.isJws((String)jwtString)) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"OIDC_CLIENT_JWS_REQUIRED_BUT_TOKEN_NOT_JWS", (Object[])new Object[]{clientConfig.getId()});
            throw new JWTTokenValidationFailedException(errorMsg);
        }
        if (JweHelper.isJweRequired((JwtConsumerConfig)clientConfig) && !JweHelper.isJwe((String)jwtString)) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"OIDC_CLIENT_JWE_REQUIRED_BUT_TOKEN_NOT_JWE", (Object[])new Object[]{clientConfig.getId()});
            throw new JWTTokenValidationFailedException(errorMsg);
        }
    }

    @FFDCIgnore(value={Exception.class})
    public JwtClaims parseJwtWithValidation(ConvergedClientConfig clientConfig, String jwtString, JwtContext jwtContext, OidcClientRequest oidcClientRequest) throws JWTTokenValidationFailedException, IllegalStateException, Exception {
        try {
            JsonWebStructure jsonStruct = JwtParsingUtils.getJsonWebStructureFromJwtContext((JwtContext)jwtContext);
            Key key = this.getSignatureVerificationKeyFromJsonWebStructure(jsonStruct, clientConfig, oidcClientRequest);
            Jose4jValidator validator = new Jose4jValidator(key, clientConfig.getClockSkewInSeconds(), OIDCClientAuthenticatorUtil.getIssuerIdentifier(clientConfig), clientConfig.getClientId(), clientConfig.getSignatureAlgorithm(), oidcClientRequest);
            return validator.parseJwtWithValidation(jwtString, jwtContext, (JsonWebSignature)jsonStruct);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught an unexpected exception.", (Object[])new Object[]{e});
            }
            throw e;
        }
    }

    @FFDCIgnore(value={Exception.class})
    public Key getSignatureVerificationKeyFromJsonWebStructure(JsonWebStructure jsonStruct, ConvergedClientConfig clientConfig, OidcClientRequest oidcClientRequest) throws JWTTokenValidationFailedException {
        String kid = jsonStruct.getKeyIdHeaderValue();
        String x5t = jsonStruct.getX509CertSha1ThumbprintHeaderValue();
        Key key = null;
        Exception caughtException = null;
        try {
            key = this.getVerifyKey(clientConfig, kid, x5t);
        }
        catch (Exception e) {
            caughtException = e;
        }
        if (key == null && !SIGNATURE_ALG_NONE.equals(clientConfig.getSignatureAlgorithm())) {
            Object[] objs = new Object[]{clientConfig.getSignatureAlgorithm(), ""};
            if (caughtException != null) {
                objs = new Object[]{clientConfig.getSignatureAlgorithm(), caughtException.getLocalizedMessage()};
            }
            if (oidcClientRequest != null) {
                oidcClientRequest.setRsFailMsg("No Key", Tr.formatMessage((TraceComponent)tc, (String)"OIDC_CLIENT_NO_VERIFYING_KEY", (Object[])objs));
                throw oidcClientRequest.error(true, tc, "OIDC_CLIENT_NO_VERIFYING_KEY", objs);
            }
            throw JWTTokenValidationFailedException.format(tc, "OIDC_CLIENT_NO_VERIFYING_KEY", objs);
        }
        return key;
    }

    public Key getVerifyKey(ConvergedClientConfig clientConfig, String kid, String x5t) throws Exception {
        Object keyValue = null;
        String signatureAlgorithm = clientConfig.getSignatureAlgorithm();
        if (signatureAlgorithm == null) {
            return keyValue;
        }
        if (signatureAlgorithm.startsWith(SIGNATURE_ALG_HS)) {
            keyValue = new HmacKey(clientConfig.getSharedKey().getBytes("UTF-8"));
        } else if (signatureAlgorithm.startsWith(SIGNATURE_ALG_RS) || signatureAlgorithm.startsWith(SIGNATURE_ALG_ES)) {
            if (clientConfig.getJwkEndpointUrl() != null || clientConfig.getJsonWebKey() != null) {
                JwKRetriever retriever = this.createJwkRetriever(clientConfig);
                keyValue = retriever.getPublicKeyFromJwk(kid, x5t, "sig", clientConfig.getUseSystemPropertiesForHttpClientConnections());
            } else {
                keyValue = clientConfig.getPublicKey();
            }
        } else if (SIGNATURE_ALG_NONE.equals(signatureAlgorithm)) {
            keyValue = null;
        }
        return keyValue;
    }

    public JwKRetriever createJwkRetriever(ConvergedClientConfig oidcClientConfig) {
        JwKRetriever retriever = null;
        if (oidcClientConfig != null) {
            retriever = new JwKRetriever(oidcClientConfig.getId(), oidcClientConfig.getSslRef(), oidcClientConfig.getJwkEndpointUrl(), oidcClientConfig.getJwkSet(), this.sslSupport, oidcClientConfig.isHostNameVerificationEnabled(), oidcClientConfig.getJwkClientId(), oidcClientConfig.getJwkClientSecret(), oidcClientConfig.getSignatureAlgorithm());
        }
        return retriever;
    }

    protected ProviderAuthenticationResult createProviderAuthenticationResult(JSONObject jobj, ConvergedClientConfig clientConfig, String accessToken) {
        AttributeToSubject attributeToSubject = new AttributeToSubject(clientConfig, jobj, accessToken);
        if (attributeToSubject.checkUserNameForNull()) {
            return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
        Hashtable<String, Object> customProperties = attributeToSubject.handleCustomProperties();
        if (accessToken != null) {
            customProperties.put("access_token", accessToken);
        }
        ProviderAuthenticationResult oidcResult = null;
        oidcResult = attributeToSubject.doMapping(customProperties, new Subject());
        return oidcResult;
    }

    @FFDCIgnore(value={Exception.class})
    public ProviderAuthenticationResult createResultWithJose4JForJwt(String jwtString, ConvergedClientConfig clientConfig, OidcClientRequest oidcClientRequest) {
        ProviderAuthenticationResult oidcResult = null;
        String accessToken = jwtString;
        String refreshToken = null;
        String clientId = clientConfig.getClientId();
        try {
            if (JweHelper.isJwe((String)jwtString)) {
                jwtString = JweHelper.extractJwsFromJweToken((String)jwtString, (JwtConsumerConfig)clientConfig, null);
            }
            JwtContext jwtContext = JwtParsingUtils.parseJwtWithoutValidation((String)jwtString);
            JwtClaims jwtClaims = this.parseJwtWithValidation(clientConfig, jwtString, jwtContext, oidcClientRequest);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("jwtClaims: " + jwtClaims), (Object[])new Object[0]);
            }
            OidcTokenImplBase idToken = new OidcTokenImplBase(jwtClaims, accessToken, refreshToken, clientId, oidcClientRequest.getTokenTypeNoSpace());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("jwt token(idToken):" + idToken.toString()), (Object[])new Object[0]);
            }
            if ((oidcResult = this.checkForReusedJwt(clientConfig, idToken)) != null) {
                return oidcResult;
            }
            AttributeToSubject attributeToSubject = new AttributeToSubject(clientConfig, idToken);
            if (attributeToSubject.checkUserNameForNull()) {
                return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
            }
            Hashtable<String, Object> customProperties = new Hashtable<String, Object>();
            Subject subject = null;
            if (clientConfig.isIncludeIdTokenInSubject()) {
                subject = new Subject();
                subject.getPrivateCredentials().add(idToken);
            }
            if (accessToken != null) {
                customProperties.put("access_token", accessToken);
                if (clientConfig.isIncludeCustomCacheKeyInSubject()) {
                    customProperties.put("com.ibm.wsspi.security.cred.cacheKey", String.valueOf(accessToken.hashCode()));
                }
                customProperties.put("com.ibm.ws.authentication.internal.assertion", Boolean.TRUE);
            }
            customProperties.put("access_token_info", jwtClaims.getClaimsMap());
            oidcResult = attributeToSubject.doMapping(customProperties, subject);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Get exception", (Object[])new Object[]{e});
            }
            Object[] objs = new Object[]{e.getLocalizedMessage(), clientId};
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_JWT_VERIFY_ERR", (Object[])objs);
            oidcClientRequest.setRsFailMsg(null, Tr.formatMessage((TraceComponent)tc, (String)"OIDC_CLIENT_JWT_VERIFY_ERR", (Object[])objs));
            oidcResult = new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
        return oidcResult;
    }

    ProviderAuthenticationResult checkForReusedJwt(ConvergedClientConfig clientConfig, OidcTokenImplBase idToken) {
        if (clientConfig.getTokenReuse()) {
            return null;
        }
        if (jtiCache.contain(idToken)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Jwt token can only be submitted once. The issuer is " + idToken.getIssuer() + ", and JTI is " + idToken.getJwtId()), (Object[])new Object[0]);
            }
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_DUP_JTI_ERR", (Object[])new Object[]{idToken.getIssuer(), idToken.getJwtId()});
            Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
        return null;
    }

    public JwtContext validateJwtStructureAndGetContext(String jwtString, ConvergedClientConfig clientConfig) throws Exception {
        this.checkJwtFormatAgainstConfigRequirements(jwtString, clientConfig);
        if (JweHelper.isJwe((String)jwtString)) {
            jwtString = JweHelper.extractJwsFromJweToken((String)jwtString, (JwtConsumerConfig)clientConfig, null);
        }
        return JwtParsingUtils.parseJwtWithoutValidation((String)jwtString);
    }

    public JwtClaims validateJwsSignature(JwtContext jwtContext, ConvergedClientConfig clientConfig) throws Exception {
        return this.validateJwsSignature(jwtContext, clientConfig, null);
    }

    public JwtClaims validateJwsSignature(JwtContext jwtContext, ConvergedClientConfig clientConfig, OidcClientRequest oidcClientRequest) throws Exception {
        JsonWebStructure jwStructure = JwtParsingUtils.getJsonWebStructureFromJwtContext((JwtContext)jwtContext);
        Key key = this.getSignatureVerificationKeyFromJsonWebStructure(jwStructure, clientConfig, oidcClientRequest);
        Jose4jValidator validator = new Jose4jValidator(key, 0L, null, clientConfig.getClientId(), clientConfig.getSignatureAlgorithm(), oidcClientRequest);
        return validator.validateJwsSignature((JsonWebSignature)jwStructure, jwtContext.getJwt());
    }

    String getUserName(ConvergedClientConfig clientConfig, List<String> tokensOrderToFetchCallerClaims, Map<String, JwtClaims> tokenClaimsMap) throws MalformedClaimException {
        String userNameClaim = this.getUserNameClaim(clientConfig);
        String userName = this.getClaimValueFromTokens(userNameClaim, String.class, tokensOrderToFetchCallerClaims, tokenClaimsMap);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("user name = '" + userName + "' and the user identifier = " + userNameClaim), (Object[])new Object[0]);
        }
        if (userName == null) {
            String attrUsedToCreateSubject = this.getUserNameAttribute(clientConfig);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The " + attrUsedToCreateSubject + " config attribute is used"), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)"There is no principal", (Object[])new Object[0]);
            }
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_JWT_MISSING_CLAIM", (Object[])new Object[]{clientConfig.getClientId(), userNameClaim, attrUsedToCreateSubject});
        }
        return userName;
    }

    String getUserNameAttribute(ConvergedClientConfig clientConfig) {
        String attrUsedToCreateSubject;
        String string = attrUsedToCreateSubject = clientConfig.isSocial() ? "userNameAttribute" : "userIdentifier";
        if (clientConfig.getUserIdentifier() == null) {
            attrUsedToCreateSubject = clientConfig.isSocial() ? "userNameAttribute" : "userIdentityToCreateSubject";
        }
        return attrUsedToCreateSubject;
    }

    String getUserNameClaim(ConvergedClientConfig clientConfig) {
        String uid = clientConfig.getUserIdentifier();
        if (uid == null || uid.isEmpty()) {
            uid = clientConfig.getUserIdentityToCreateSubject();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("the user identifier = " + uid), (Object[])new Object[0]);
        }
        return uid;
    }

    String getRealmName(ConvergedClientConfig clientConfig, List<String> tokensOrderToFetchCallerClaims, Map<String, JwtClaims> tokenClaimsMap) throws MalformedClaimException {
        String realm = clientConfig.getRealmName();
        if (realm == null) {
            String claim;
            Iterator<String> iterator = this.getRealmNameClaim(clientConfig).iterator();
            while (iterator.hasNext() && ((realm = this.getClaimValueFromTokens(claim = iterator.next(), String.class, tokensOrderToFetchCallerClaims, tokenClaimsMap)) == null || realm.isEmpty())) {
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"realm name = ", (Object[])new Object[]{realm});
        }
        return realm;
    }

    List<String> getRealmNameClaim(ConvergedClientConfig clientConfig) {
        ArrayList<String> claims = new ArrayList<String>();
        String claim = clientConfig.getRealmIdentifier();
        if (claim != null && !claim.isEmpty()) {
            claims.add(claim);
        }
        claims.add("iss");
        return claims;
    }

    String getUniqueSecurityName(ConvergedClientConfig clientConfig, List<String> tokensOrderToFetchCallerClaims, Map<String, JwtClaims> tokenClaimsMap, String userName) throws MalformedClaimException {
        String uniqueSecurityNameClaim = this.getUniqueSecurityNameClaim(clientConfig);
        String uniqueSecurityName = this.getClaimValueFromTokens(uniqueSecurityNameClaim, String.class, tokensOrderToFetchCallerClaims, tokenClaimsMap);
        if (uniqueSecurityName == null || uniqueSecurityName.isEmpty()) {
            uniqueSecurityName = userName;
        }
        return uniqueSecurityName;
    }

    String getUniqueSecurityNameClaim(ConvergedClientConfig clientConfig) {
        return clientConfig.getUniqueUserIdentifier();
    }

    List<String> getGroups(ConvergedClientConfig clientConfig, List<String> tokensOrderToFetchCallerClaims, Map<String, JwtClaims> tokenClaimsMap, String realm) throws MalformedClaimException {
        ArrayList<String> groups = new ArrayList<String>();
        List<String> groupIds = this.getGroupIds(clientConfig, tokensOrderToFetchCallerClaims, tokenClaimsMap);
        for (String gid : groupIds) {
            String group = new StringBuffer("group:").append(realm).append("/").append(gid).toString();
            groups.add(group);
        }
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @FFDCIgnore(value={MalformedClaimException.class})
    List<String> getGroupIds(ConvergedClientConfig clientConfig, List<String> tokensOrderToFetchCallerClaims, Map<String, JwtClaims> tokenClaimsMap) throws MalformedClaimException {
        ArrayList<String> groupIds;
        block10: {
            String groupIdsClaim = this.getGroupIdsClaim(clientConfig);
            groupIds = null;
            try {
                groupIds = this.getClaimValueFromTokens(groupIdsClaim, List.class, tokensOrderToFetchCallerClaims, tokenClaimsMap);
                if (groupIds != null) break block10;
                groupIds = new ArrayList();
            }
            catch (MalformedClaimException groupIdsStr) {
                if (groupIds == null) {
                    groupIds = new ArrayList();
                    String groupIdsStr2 = this.getClaimValueFromTokens(groupIdsClaim, String.class, tokensOrderToFetchCallerClaims, tokenClaimsMap);
                    if (groupIdsStr2 != null) {
                        groupIds.add(groupIdsStr2);
                    }
                }
                catch (Throwable throwable) {
                    if (groupIds == null) {
                        groupIds = new ArrayList<String>();
                        String groupIdsStr3 = this.getClaimValueFromTokens(groupIdsClaim, String.class, tokensOrderToFetchCallerClaims, tokenClaimsMap);
                        if (groupIdsStr3 != null) {
                            groupIds.add(groupIdsStr3);
                        }
                    }
                    throw throwable;
                }
            }
            String groupIdsStr = this.getClaimValueFromTokens(groupIdsClaim, String.class, tokensOrderToFetchCallerClaims, tokenClaimsMap);
            if (groupIdsStr != null) {
                groupIds.add(groupIdsStr);
            }
        }
        if (groupIds.size() > 0 && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("groupIds=" + ((Object)groupIds).toString() + " groups size = "), (Object[])new Object[]{groupIds.size()});
        }
        return groupIds;
    }

    String getGroupIdsClaim(ConvergedClientConfig clientConfig) {
        return clientConfig.getGroupIdentifier();
    }

    <T> T getClaimValueFromTokens(String claim, Class<T> claimType, List<String> tokensOrderToFetchCallerClaims, Map<String, JwtClaims> tokenClaimsMap) throws MalformedClaimException {
        String token;
        JwtClaims tokenClaims;
        if (claim == null || claim.isEmpty()) {
            return null;
        }
        Object claimValue = null;
        Iterator<String> iterator = tokensOrderToFetchCallerClaims.iterator();
        while (iterator.hasNext() && ((tokenClaims = tokenClaimsMap.get(token = iterator.next())) == null || !this.valueExistsAndIsNotEmpty(claimValue = tokenClaims.getClaimValue(claim, claimType), claimType))) {
        }
        return (T)claimValue;
    }

    <T> boolean valueExistsAndIsNotEmpty(T claimValue, Class<T> claimType) {
        if (claimValue == null) {
            return false;
        }
        if (claimType.equals(String.class) && ((String)claimValue).isEmpty()) {
            return false;
        }
        if (claimType.equals(Set.class) && ((Set)claimValue).isEmpty()) {
            return false;
        }
        return !claimType.equals(List.class) || !((List)claimValue).isEmpty();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = 939135952528860596L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.setProperty("org.jose4j.jws.default-allow-none", "true");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.openidconnect.client.jose4j.util.Jose4jUtil$1", 1.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
            }
        });
    }
}

