/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer31.srt;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.servlet.request.IRequest;
import com.ibm.websphere.servlet31.request.IRequest31;
import com.ibm.ws.transport.access.TransportConnectionUpgrade;
import com.ibm.ws.webcontainer.servlet.RequestUtils;
import com.ibm.ws.webcontainer.srt.SRTConnectionContext;
import com.ibm.ws.webcontainer.srt.SRTInputStream;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer31.async.ThreadContextManager;
import com.ibm.ws.webcontainer31.osgi.srt.SRTConnectionContext31;
import com.ibm.ws.webcontainer31.osgi.webapp.WebApp31;
import com.ibm.ws.webcontainer31.srt.SRTInputStream31;
import com.ibm.ws.webcontainer31.srt.SRTRequestContext31;
import com.ibm.ws.webcontainer31.srt.SRTServletRequestPart31;
import com.ibm.wsspi.http.ee7.HttpInputStreamEE7Extended;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.WebContainerRequestState;
import com.ibm.wsspi.webcontainer.util.FFDCWrapper;
import com.ibm.wsspi.webcontainer.util.WSServletInputStream;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import org.apache.commons.fileupload.disk.DiskFileItem;

public class SRTServletRequest31
extends SRTServletRequest
implements HttpServletRequest {
    private static final TraceComponent tc = Tr.register(SRTServletRequest31.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer31.resources.Messages");
    protected static final TraceNLS nls = TraceNLS.getTraceNLS(SRTServletRequest31.class, (String)"com.ibm.ws.webcontainer31.resources.Messages");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer31.srt.SRTServletRequest31";
    private boolean upgradeCalledAndSuccessful = false;
    private HttpUpgradeHandler httpUpgradeHandlerObject;

    public SRTServletRequest31(SRTConnectionContext31 context) {
        super((SRTConnectionContext)context);
    }

    protected SRTRequestContext31 createRequestContext() {
        return new SRTRequestContext31(this);
    }

    public Object clone() throws CloneNotSupportedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"clone", (Object[])new Object[0]);
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        SRTServletRequest31 clonedSRTServletRequest = (SRTServletRequest31)((Object)super.clone());
        clonedSRTServletRequest.upgradeCalledAndSuccessful = this.upgradeCalledAndSuccessful;
        clonedSRTServletRequest.httpUpgradeHandlerObject = this.httpUpgradeHandlerObject;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"clone", (Object)("original -->" + (Object)((Object)this) + " cloned -->" + (Object)((Object)clonedSRTServletRequest)));
        }
        return clonedSRTServletRequest;
    }

    public void initForNextRequest(IRequest req) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "initForNextRequest", "this->" + (Object)((Object)this) + " :  req->" + req);
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        try {
            if (req == null) {
                if (this.multiReadPropertyEnabled) {
                    if (this._in instanceof SRTInputStream) {
                        ((SRTInputStream)this._in).cleanupforMultiRead();
                    }
                    this.multiReadPropertyEnabled = false;
                    this.httpUpdatedwMultiReadValues = false;
                }
                this._in.init(null);
                return;
            }
            this._setInputStreamContentType = null;
            this._setInputStreamContentLength = -1L;
            this._setInputDataStreamCalled = false;
            this._request = req;
            this._srtRequestHelper = this.getRequestHelper();
            this.initRequestThreadData();
            this._in.init(this._request.getInputStream());
            if (this.getContentLengthLong() > 0L) {
                this._in.setContentLength(this.getContentLengthLong());
            }
        }
        catch (IOException e) {
            FFDCWrapper.processException((Throwable)e, (String)"com.ibm.ws.webcontainer.srt.SRTServletRequest.initForNextRequest", (String)"828", (Object)((Object)this));
        }
        this.upgradeCalledAndSuccessful = false;
    }

    protected void cleanupFromFinish() {
        super.cleanupFromFinish();
        this.upgradeCalledAndSuccessful = false;
        if (this.httpUpgradeHandlerObject != null) {
            Map contexts;
            WebApp31 webapp = (WebApp31)this.getDispatchContext().getWebApp();
            if (webapp != null && webapp.isCDIEnabled() && (contexts = webapp.getCdiContexts()) != null) {
                contexts.remove(this.httpUpgradeHandlerObject);
            }
            this.httpUpgradeHandlerObject = null;
        }
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        WebApp31 webapp = (WebApp31)this.getDispatchContext().getWebApp();
        T classInstance = null;
        if (handlerClass == null) {
            throw new ServletException(nls.getString("handlerClass.is.null", webapp.getWebAppName()));
        }
        classInstance = webapp.createHttpUpgradeHandler(handlerClass);
        this.upgradeCalledAndSuccessful = true;
        this.httpUpgradeHandlerObject = classInstance;
        if (!(this.httpUpgradeHandlerObject instanceof TransportConnectionUpgrade)) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "upgrade", "Saving of thread context data for later use");
            }
            WebContainerRequestState threadContextRequestState = WebContainerRequestState.getInstance((boolean)true);
            ThreadContextManager tcm = new ThreadContextManager();
            threadContextRequestState.setAttribute("ApplicationsOriginalTCM", (Object)tcm);
        }
        return classInstance;
    }

    public boolean isUpgradeInProgress() {
        return this.upgradeCalledAndSuccessful;
    }

    public HttpUpgradeHandler getHttpUpgradeHandler() {
        return this.httpUpgradeHandlerObject;
    }

    public long getContentLengthLong() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        long contentLength = !this._setInputDataStreamCalled ? ((IRequest31)this._request).getContentLengthLong() : this._setInputStreamContentLength;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getContentLengthLong", "this->" + (Object)((Object)this) + ":  length --> " + String.valueOf(contentLength));
        }
        return contentLength;
    }

    public String changeSessionId() {
        WebApp webapp = this._dispatchContext.getWebApp();
        HttpSession thisSession = ((SRTRequestContext31)this._requestContext).generateNewId(webapp);
        return thisSession.getId();
    }

    protected WSServletInputStream createInputStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"createInputStream entry", (Object[])new Object[0]);
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        return new SRTInputStream31(this);
    }

    public void finishKeepConnection() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"finishKeepConnection", (Object[])new Object[]{"entry [" + (Object)((Object)this) + "]"});
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        this.cleanupFromFinish();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"finishKeepConnection", (Object)(" exit [" + (Object)((Object)this) + "]"));
        }
    }

    protected Part morphIntoPart(DiskFileItem commonsFile) {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        SRTServletRequestPart31 p = new SRTServletRequestPart31(commonsFile);
        return p;
    }

    protected void prepareMultipart() throws ServletException, IOException {
        if (((SRTInputStream31)this._in).getReadListener() != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "prepareMultipart", "Non-Blocking read already started on this InputStream , cannot parse again->" + this._in);
            }
            throw new IllegalStateException("An attempt to read or parse the post body failed because a non-blocking read event has already started");
        }
        super.prepareMultipart();
    }

    protected Hashtable parsePostData() throws IOException {
        if (((SRTInputStream31)this._in).getReadListener() != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "prepareMultipart", "Non-Blocking read already started on this InputStream , cannot parse again->" + this._in);
            }
            return null;
        }
        if (this.getContentLengthLong() > 0L) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "parseParameters", "parsing post data based upon content length long");
            }
            return RequestUtils.parsePostDataLong((long)this.getContentLengthLong(), (ServletInputStream)this.getInputStream(), (String)this.getReaderEncoding(), (boolean)this.multiReadPropertyEnabled);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "parseParameters", "parsing post data based upon input stream (possibly chunked)");
        }
        return RequestUtils.parsePostData((ServletInputStream)this.getInputStream(), (String)this.getReaderEncoding(), (boolean)this.multiReadPropertyEnabled);
    }

    public void setInputStreamData(HashMap inStreamInfo) throws IOException {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (this.getHelperGotReader()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setInputStreamData", "attempt to setInputStreamData after it has been read");
            }
            throw new IllegalStateException(liberty_nls.getString("Reader.already.obtained", "Reader already obtained"));
        }
        this._setInputDataStreamCalled = true;
        if (inStreamInfo != null) {
            Long contentLength = (Long)inStreamInfo.get("ContentDataLength");
            if (contentLength == null) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "setInputStreamData", "No content length in passed map. Throw IOException");
                }
                throw new IllegalStateException();
            }
            this._setInputStreamContentLength = contentLength;
            this._setInputStreamContentType = (String)inStreamInfo.get("ContentType");
            byte[][] inStreamContentData = (byte[][])inStreamInfo.get("ContentData");
            if (inStreamContentData != null) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "setInputStreamData", "SetInputStreamData Content Type = " + this._setInputStreamContentType + ", contentLength = " + this._setInputStreamContentLength + ", data array length = " + inStreamContentData.length + " : this = " + (Object)((Object)this));
                }
                HttpInputStreamEE7Extended inStream = new HttpInputStreamEE7Extended(inStreamContentData);
                this._in.init((InputStream)inStream);
                this._in.setContentLength(this._setInputStreamContentLength);
                this.setHelperParameters(null);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setInputStreamData", "No map passed as input");
            }
            throw new IllegalArgumentException();
        }
    }

    public HashMap getInputStreamData() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "getInputStreamData");
            logger.logp(Level.FINE, CLASS_NAME, "getInputStreamData", "[" + (Object)((Object)this) + "]");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        ServletInputStream in = this.getInputStream();
        HashMap<String, Object> inStreamInfo = new HashMap<String, Object>();
        if (this.getContentType() != null) {
            inStreamInfo.put("ContentType", this.getContentType());
        } else {
            inStreamInfo.put("ContentType", null);
        }
        int offset = 0;
        int inputLen = 0;
        long len = this.getContentLengthLong();
        long lenRead = 0L;
        inStreamInfo.put("ContentDataLength", len);
        if (len > 0L) {
            int bufferLen = 0;
            int MaxBufferSize = WCCustomProperties.SERVLET31_PRIVATE_BUFFERSIZE_FOR_LARGE_POST_DATA;
            long arraySize = len / (long)MaxBufferSize;
            if (len % (long)MaxBufferSize > 0L) {
                ++arraySize;
            }
            if (arraySize > Integer.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            byte[][] bytes = new byte[(int)arraySize][];
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getInputStreamData", "data length = " + Long.toString(len) + ", MaxBufferSize = " + MaxBufferSize + ", Array size = " + arraySize);
            }
            int i = 0;
            while (len > lenRead) {
                bufferLen = len - lenRead >= (long)MaxBufferSize ? MaxBufferSize : (int)(len - lenRead);
                bytes[i] = new byte[bufferLen];
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getInputStreamData", "buffer " + i + " of length " + bufferLen + ", left to read = " + Long.toString(len - lenRead));
                }
                offset = 0;
                do {
                    if ((inputLen = in.read(bytes[i], offset, bufferLen - offset)) <= 0) {
                        String msg = nls.getString("post.body.contains.less.bytes.than.specified", "post body contains less bytes than specified by content-length");
                        throw new IOException(msg);
                    }
                    logger.logp(Level.FINE, CLASS_NAME, "getInputStreamData", "read of " + inputLen + " bytes.");
                } while (bufferLen - (offset += inputLen) > 0);
                lenRead += (long)bufferLen;
                ++i;
            }
            inStreamInfo.put("ContentData", bytes);
        } else {
            inStreamInfo.put("ContentData", null);
        }
        if (in != null) {
            this.releaseInputStream();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getInputStreamData", "ContentType = " + this.getContentType() + ", data length = " + len);
            logger.exiting(CLASS_NAME, "getInputStreamData");
        }
        return inStreamInfo;
    }

    public byte[][] serializeInputStreamData(Map isd) throws IOException, UnsupportedEncodingException, IllegalStateException {
        this.validateInputStreamData(isd);
        String type = (String)isd.get("ContentType");
        Long length = (Long)isd.get("ContentDataLength");
        byte[][] data = (byte[][])isd.get("ContentData");
        int arraySize = 3;
        if (data != null) {
            arraySize += data.length;
        }
        byte[][] output = new byte[arraySize][];
        output[0] = this.longToBytes(length.intValue());
        if (type != null) {
            output[1] = this.intToBytes(type.length());
            output[2] = type.getBytes("UTF-8");
        } else {
            output[1] = this.intToBytes(0);
            output[2] = new byte[1];
        }
        if (data != null) {
            for (int i = 0; i < data.length; ++i) {
                output[3 + i] = data[i];
            }
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            String message = "total : " + this.sizeInputStreamData(isd) + " number of items : " + output.length;
            logger.logp(Level.FINE, CLASS_NAME, "serializeInputStreamData", message);
        }
        return output;
    }

    public HashMap deserializeInputStreamData(byte[][] input) throws UnsupportedEncodingException, IllegalStateException {
        if (input == null || input.length < 2) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "deseriallizeInputStreamData", "The input data is null or fewer items than the expected. ");
            }
            throw new IllegalStateException("Invalid data.");
        }
        HashMap<String, Object> output = new HashMap<String, Object>();
        long length = this.bytesToLong(input[0]);
        output.put("ContentDataLength", length);
        int typeLen = this.bytesToInt(input[1]);
        if (typeLen > 0) {
            output.put("ContentType", new String(input[2], "UTF-8"));
        } else {
            output.put("ContentType", null);
        }
        int items = input.length;
        if (length > 0L && items > 3) {
            byte[][] data = new byte[items - 3][];
            for (int i = 0; i < items - 3; ++i) {
                data[i] = input[3 + i];
            }
            output.put("ContentData", data);
        } else {
            output.put("ContentData", null);
        }
        return output;
    }

    public long sizeInputStreamData(Map isd) throws UnsupportedEncodingException, IllegalStateException {
        this.validateInputStreamData(isd);
        long size = 12L;
        String type = (String)isd.get("ContentType");
        size = type != null ? (size += (long)type.getBytes("UTF-8").length) : ++size;
        byte[][] data = (byte[][])isd.get("ContentData");
        if (data != null) {
            for (int i = 0; i < data.length; ++i) {
                size += (long)data[i].length;
            }
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "sizeInputStreamData", Long.toString(size));
        }
        return size;
    }
}

