/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry.internal.common.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.kernel.service.util.ServiceCaller;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import io.openliberty.microprofile.telemetry.internal.common.cdi.BaggageProxy;
import io.openliberty.microprofile.telemetry.internal.common.cdi.SpanProxy;
import io.openliberty.microprofile.telemetry.internal.common.info.ErrorOpenTelemetryInfo;
import io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryInfo;
import io.openliberty.microprofile.telemetry.internal.interfaces.OpenTelemetryInfoFactory;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;

@ApplicationScoped
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenTelemetryProducer {
    private static final TraceComponent tc = Tr.register(OpenTelemetryProducer.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
    private static final ServiceCaller<OpenTelemetryInfoFactory> openTelemetryInfoFactoryService = new ServiceCaller(OpenTelemetryProducer.class, OpenTelemetryInfoFactory.class);
    private final ApplicationMetaData metaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData().getModuleMetaData().getApplicationMetaData();
    static final long serialVersionUID = -7256340826780919636L;

    private OpenTelemetryProducer() {
    }

    private OpenTelemetryInfo getOpenTelemetryInfo() {
        Optional openTelemetryInfo = openTelemetryInfoFactoryService.call(factory -> factory.getOpenTelemetryInfo(this.metaData));
        return openTelemetryInfo.orElseGet(ErrorOpenTelemetryInfo::new);
    }

    @Produces
    public Tracer getTracer() {
        return this.getOpenTelemetryInfo().getTracer();
    }

    @Produces
    @ApplicationScoped
    public Span getSpan() {
        return new SpanProxy();
    }

    @Produces
    @ApplicationScoped
    public Baggage getBaggage() {
        return new BaggageProxy();
    }

    @ApplicationScoped
    @Produces
    public OpenTelemetry getOpenTelemetry() {
        return this.getOpenTelemetryInfo().getOpenTelemetry();
    }
}

