/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry.internal.common.info;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedApplicationInfo;
import com.ibm.ws.container.service.metadata.MetaDataSlotService;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import io.openliberty.microprofile.telemetry.internal.common.AgentDetection;
import io.openliberty.microprofile.telemetry.internal.common.info.DisabledOpenTelemetryInfo;
import io.openliberty.microprofile.telemetry.internal.common.info.DisposedOpenTelemetryInfo;
import io.openliberty.microprofile.telemetry.internal.common.info.EnabledOpenTelemetryInfo;
import io.openliberty.microprofile.telemetry.internal.common.info.ErrorOpenTelemetryInfo;
import io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryInfo;
import io.openliberty.microprofile.telemetry.internal.interfaces.OpenTelemetryInfoFactory;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.resources.ResourceBuilder;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ApplicationStateListener.class, OpenTelemetryInfoFactory.class}, property={"service.vendor=IBM", "service.ranking:Integer=150"})
public class OpenTelemetryInfoFactoryImpl
implements ApplicationStateListener,
OpenTelemetryInfoFactory {
    private static final TraceComponent tc = Tr.register(OpenTelemetryInfoFactoryImpl.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
    private final MetaDataSlot slotForOpenTelemetryInfoHolder;
    @Reference
    private OpenTelemetryVersionedConfiguration openTelemetryVersionedConfiguration;
    static final long serialVersionUID = 8251586693892285082L;

    @Activate
    public OpenTelemetryInfoFactoryImpl(@Reference MetaDataSlotService slotService) {
        this.slotForOpenTelemetryInfoHolder = slotService.reserveMetaDataSlot(ApplicationMetaData.class);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OpenTelemetryInfo getOpenTelemetryInfo() {
        try {
            ApplicationMetaData metaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData().getModuleMetaData().getApplicationMetaData();
            return this.getOpenTelemetryInfo(metaData);
        }
        catch (Exception metaData) {
            void e;
            FFDCFilter.processException((Throwable)metaData, (String)"io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryInfoFactoryImpl", (String)"96", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)Tr.formatMessage((TraceComponent)tc, (String)"CWMOT5002.telemetry.error", (Object[])new Object[]{e}), (Object[])new Object[0]);
            return new ErrorOpenTelemetryInfo();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OpenTelemetryInfo getOpenTelemetryInfo(ApplicationMetaData metaData) {
        try {
            OpenTelemetryInfoReference atomicRef = (OpenTelemetryInfoReference)metaData.getMetaData(this.slotForOpenTelemetryInfoHolder);
            if (atomicRef == null) {
                String j2EEName = metaData.getJ2EEName().toString();
                if (j2EEName.startsWith("io.openliberty") || j2EEName.startsWith("com.ibm.ws")) {
                    Tr.info((TraceComponent)tc, (String)"CWMOT5100.tracing.is.disabled", (Object[])new Object[]{j2EEName});
                    return new DisabledOpenTelemetryInfo();
                }
                throw new IllegalStateException("Attempted to create openTelemetaryInfo for application " + j2EEName + " which has not gone through ApplicationStarting");
            }
            OpenTelemetryInfoWrappedSupplier supplier = (OpenTelemetryInfoWrappedSupplier)atomicRef.get();
            return supplier.get();
        }
        catch (Exception atomicRef) {
            void e;
            FFDCFilter.processException((Throwable)atomicRef, (String)"io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryInfoFactoryImpl", (String)"119", (Object)this, (Object[])new Object[]{metaData});
            Tr.error((TraceComponent)tc, (String)Tr.formatMessage((TraceComponent)tc, (String)"CWMOT5002.telemetry.error", (Object[])new Object[]{e}), (Object[])new Object[0]);
            return new ErrorOpenTelemetryInfo();
        }
    }

    /*
     * WARNING - void declaration
     */
    private OpenTelemetryInfo createOpenTelemetryInfo() {
        try {
            OpenTelemetry openTelemetry;
            String appName = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData().getJ2EEName().getApplication();
            if (AgentDetection.isAgentActive()) {
                return new EnabledOpenTelemetryInfo(true, GlobalOpenTelemetry.get(), appName);
            }
            HashMap<String, String> telemetryProperties = this.getTelemetryProperties();
            if (!OpenTelemetryInfoFactoryImpl.checkDisabled(telemetryProperties) && (openTelemetry = AccessController.doPrivileged(() -> this.openTelemetryVersionedConfiguration.getPartiallyConfiguredOpenTelemetrySDKBuilder().addPropertiesCustomizer(x -> telemetryProperties).addResourceCustomizer(OpenTelemetryInfoFactoryImpl::customizeResource).setServiceClassLoader(Thread.currentThread().getContextClassLoader()).build().getOpenTelemetrySdk())) != null) {
                return new EnabledOpenTelemetryInfo(true, openTelemetry, appName);
            }
            Tr.info((TraceComponent)tc, (String)"CWMOT5100.tracing.is.disabled", (Object[])new Object[]{appName});
            return new DisabledOpenTelemetryInfo();
        }
        catch (Exception appName) {
            void e;
            FFDCFilter.processException((Throwable)appName, (String)"io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryInfoFactoryImpl", (String)"156", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)Tr.formatMessage((TraceComponent)tc, (String)"CWMOT5002.telemetry.error", (Object[])new Object[]{e}), (Object[])new Object[0]);
            return new ErrorOpenTelemetryInfo();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static OpenTelemetryInfo createDisposedOpenTelemetryInfo() {
        try {
            String appName = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData().getJ2EEName().getApplication();
            return new DisposedOpenTelemetryInfo(appName);
        }
        catch (Exception appName) {
            void e;
            FFDCFilter.processException((Throwable)appName, (String)"io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryInfoFactoryImpl", (String)"168", null, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)Tr.formatMessage((TraceComponent)tc, (String)"CWMOT5002.telemetry.error", (Object[])new Object[]{e}), (Object[])new Object[0]);
            return new ErrorOpenTelemetryInfo();
        }
    }

    private static boolean checkDisabled(Map<String, String> oTelConfigs) {
        if (oTelConfigs.get("OTEL_SDK_DISABLED") != null) {
            return Boolean.valueOf(oTelConfigs.get("OTEL_SDK_DISABLED"));
        }
        if (oTelConfigs.get("otel.sdk.disabled") != null) {
            return Boolean.valueOf(oTelConfigs.get("otel.sdk.disabled"));
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<String, String> getTelemetryProperties() {
        try {
            Config config = ConfigProvider.getConfig();
            HashMap<String, String> telemetryProperties = new HashMap<String, String>();
            for (String propertyName : config.getPropertyNames()) {
                if (!propertyName.startsWith("otel") && !propertyName.startsWith("OTEL")) continue;
                String normalizedName = propertyName.toLowerCase().replace('_', '.');
                config.getOptionalValue(normalizedName, String.class).ifPresent(value -> telemetryProperties.put(normalizedName, (String)value));
            }
            telemetryProperties.putAll(this.openTelemetryVersionedConfiguration.getTelemetryPropertyDefaults());
            return telemetryProperties;
        }
        catch (Exception config) {
            void e;
            FFDCFilter.processException((Throwable)config, (String)"io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryInfoFactoryImpl", (String)"198", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)Tr.formatMessage((TraceComponent)tc, (String)"CWMOT5002.telemetry.error", (Object[])new Object[]{e}), (Object[])new Object[0]);
            return new HashMap<String, String>();
        }
    }

    public void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
        ExtendedApplicationInfo extAppInfo = (ExtendedApplicationInfo)appInfo;
        OpenTelemetryInfoReference oTelRef = (OpenTelemetryInfoReference)extAppInfo.getMetaData().getMetaData(this.slotForOpenTelemetryInfoHolder);
        OpenTelemetryInfoWrappedSupplier newSupplier = new OpenTelemetryInfoWrappedSupplier(this::createOpenTelemetryInfo, openTelemetryInfo -> openTelemetryInfo.dispose());
        if (oTelRef == null) {
            oTelRef = new OpenTelemetryInfoReference();
        }
        oTelRef.set(newSupplier);
        extAppInfo.getMetaData().setMetaData(this.slotForOpenTelemetryInfoHolder, (Object)oTelRef);
    }

    public void applicationStarted(ApplicationInfo appInfo) throws StateChangeException {
    }

    public void applicationStopping(ApplicationInfo appInfo) {
    }

    public void applicationStopped(ApplicationInfo appInfo) {
        ExtendedApplicationInfo extAppInfo = (ExtendedApplicationInfo)appInfo;
        OpenTelemetryInfoReference oTelRef = (OpenTelemetryInfoReference)extAppInfo.getMetaData().getMetaData(this.slotForOpenTelemetryInfoHolder);
        OpenTelemetryInfoWrappedSupplier newSupplier = new OpenTelemetryInfoWrappedSupplier(OpenTelemetryInfoFactoryImpl::createDisposedOpenTelemetryInfo, openTelemetryInfo -> {});
        OpenTelemetryInfoWrappedSupplier oldSupplier = oTelRef.getAndSet(newSupplier);
        try {
            oldSupplier.closeAndDisposeIfCreated();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryInfoFactoryImpl", (String)"239", (Object)this, (Object[])new Object[]{appInfo});
            Tr.warning((TraceComponent)tc, (String)"applicationStopped", (Object[])new Object[]{"failed to dispose of OpenTelemetry"});
        }
    }

    private static Resource customizeResource(Resource resource, ConfigProperties c) {
        ResourceBuilder builder = resource.toBuilder();
        builder.put(AttributeKey.stringKey((String)"service.name"), (Object)OpenTelemetryInfoFactoryImpl.getServiceName(c));
        return builder.build();
    }

    private static String getServiceName(ConfigProperties c) {
        String appName = c.getString("otel.service.name");
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (appName == null && cmd != null) {
            appName = cmd.getModuleMetaData().getApplicationMetaData().getName();
        }
        return appName;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class OpenTelemetryInfoReference
    extends AtomicReference<OpenTelemetryInfoWrappedSupplier> {
        private static final long serialVersionUID = -4884222080590544495L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private OpenTelemetryInfoReference() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryInfoFactoryImpl$OpenTelemetryInfoReference", OpenTelemetryInfoReference.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class OpenTelemetryInfoWrappedSupplier {
        private final Consumer<OpenTelemetryInfo> disposer;
        private Supplier<OpenTelemetryInfo> supplier;
        private volatile OpenTelemetryInfo openTelemetryInfo = null;
        static final long serialVersionUID = 6545158355106375091L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public OpenTelemetryInfoWrappedSupplier(Supplier<OpenTelemetryInfo> supplier, Consumer<OpenTelemetryInfo> disposer) {
            this.disposer = disposer;
            this.supplier = supplier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OpenTelemetryInfo get() throws InterruptedException, ExecutionException {
            if (this.openTelemetryInfo != null) {
                return this.openTelemetryInfo;
            }
            OpenTelemetryInfoWrappedSupplier openTelemetryInfoWrappedSupplier = this;
            synchronized (openTelemetryInfoWrappedSupplier) {
                if (this.openTelemetryInfo != null) {
                    return this.openTelemetryInfo;
                }
                this.openTelemetryInfo = this.supplier.get();
                return this.openTelemetryInfo;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean closeAndDisposeIfCreated() {
            OpenTelemetryInfoWrappedSupplier openTelemetryInfoWrappedSupplier = this;
            synchronized (openTelemetryInfoWrappedSupplier) {
                this.supplier = () -> OpenTelemetryInfoFactoryImpl.createDisposedOpenTelemetryInfo();
                if (this.openTelemetryInfo != null) {
                    this.disposer.accept(this.openTelemetryInfo);
                    return true;
                }
                return false;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryInfoFactoryImpl$OpenTelemetryInfoWrappedSupplier", OpenTelemetryInfoWrappedSupplier.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
        }
    }

    public static interface OpenTelemetryVersionedConfiguration {
        public AutoConfiguredOpenTelemetrySdkBuilder getPartiallyConfiguredOpenTelemetrySDKBuilder();

        public Map<String, String> getTelemetryPropertyDefaults();
    }
}

