/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry10.internal.rest;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import io.openliberty.microprofile.telemetry.internal.common.AgentDetection;
import io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryInfo;
import io.openliberty.microprofile.telemetry.internal.common.rest.AbstractTelemetryServletFilter;
import io.openliberty.microprofile.telemetry.internal.interfaces.OpenTelemetryAccessor;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import jakarta.annotation.Nullable;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

@Provider
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TelemetryServletFilter
extends AbstractTelemetryServletFilter
implements Filter {
    private static final TraceComponent tc = Tr.register(TelemetryServletFilter.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
    private static final String INSTRUMENTATION_NAME = "io.openliberty.microprofile.telemetry";
    private static final HttpServerAttributesGetterImpl HTTP_SERVER_ATTRIBUTES_GETTER = new HttpServerAttributesGetterImpl();
    private static final NetServerAttributesGetterImpl NET_SERVER_ATTRIBUTES_GETTER = new NetServerAttributesGetterImpl();
    private Instrumenter<ServletRequest, ServletResponse> instrumenter;
    private volatile boolean lazyCreate = false;
    private final AtomicReference<Instrumenter<ServletRequest, ServletResponse>> lazyInstrumenter = new AtomicReference();
    private final Config config = ConfigProvider.getConfig();
    static final long serialVersionUID = 675085540982974967L;

    public void init(FilterConfig config) {
        if (!CheckpointPhase.getPhase().restored()) {
            this.lazyCreate = true;
        } else {
            this.instrumenter = this.createInstrumenter();
        }
    }

    private Instrumenter<ServletRequest, ServletResponse> getInstrumenter() {
        if (this.instrumenter != null) {
            return this.instrumenter;
        }
        if (this.lazyCreate) {
            this.instrumenter = this.lazyInstrumenter.updateAndGet(i -> {
                if (i == null) {
                    return this.createInstrumenter();
                }
                return i;
            });
            this.lazyCreate = false;
        }
        return this.instrumenter;
    }

    private Instrumenter<ServletRequest, ServletResponse> createInstrumenter() {
        boolean httpTracingDisabled = this.config.getOptionalValue("otel.trace.http.disabled", Boolean.class).orElse(false);
        OpenTelemetryInfo otelInfo = OpenTelemetryAccessor.getOpenTelemetryInfo();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("otel.trace.http.disabled=" + httpTracingDisabled), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("otelInfo.getEnabled()=" + otelInfo.getEnabled()), (Object[])new Object[0]);
        }
        if (otelInfo != null && otelInfo.getEnabled() && !AgentDetection.isAgentActive() && !httpTracingDisabled) {
            InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)otelInfo.getOpenTelemetry(), (String)INSTRUMENTATION_NAME, (SpanNameExtractor)HttpSpanNameExtractor.create((HttpCommonAttributesGetter)HTTP_SERVER_ATTRIBUTES_GETTER));
            Instrumenter result = builder.setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpServerAttributesGetter)HTTP_SERVER_ATTRIBUTES_GETTER)).addAttributesExtractor((AttributesExtractor)HttpServerAttributesExtractor.create((HttpServerAttributesGetter)HTTP_SERVER_ATTRIBUTES_GETTER)).addAttributesExtractor((AttributesExtractor)NetServerAttributesExtractor.create((NetServerAttributesGetter)NET_SERVER_ATTRIBUTES_GETTER)).buildServerInstrumenter((TextMapGetter)new ServletRequestContextTextMapGetter());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"instrumenter is initialized", (Object[])new Object[0]);
            }
            return result;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"instrumenter is set to null", (Object[])new Object[0]);
        }
        return null;
    }

    public void doFilter(final ServletRequest request, final ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Context parentContext;
        Scope scope = null;
        final Instrumenter<ServletRequest, ServletResponse> current = this.getInstrumenter();
        if (current != null && current.shouldStart(parentContext = Context.current(), (Object)request)) {
            Context spanContext = current.start(parentContext, (Object)request);
            scope = spanContext.makeCurrent();
            request.setAttribute("otel.span.http.context", (Object)spanContext);
            request.setAttribute("otel.span.http.parentContext", (Object)parentContext);
            request.setAttribute("otel.span.http.scope", (Object)scope);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Span traceId=" + Span.current().getSpanContext().getTraceId() + ", spanId=" + Span.current().getSpanContext().getSpanId()), (Object[])new Object[0]);
            }
        }
        chain.doFilter(request, response);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isAsyncStarted=" + request.isAsyncStarted()), (Object[])new Object[0]);
        }
        if (request.isAsyncStarted()) {
            AsyncContext asyncContext = request.getAsyncContext();
            asyncContext.addListener(new AsyncListener(){
                static final long serialVersionUID = -8705807827666487160L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public void onComplete(AsyncEvent event) throws IOException {
                    TelemetryServletFilter.this.endSpan(request, response, null, (Instrumenter<ServletRequest, ServletResponse>)current);
                }

                public void onTimeout(AsyncEvent event) throws IOException {
                    TelemetryServletFilter.this.endSpan(request, response, event.getThrowable(), (Instrumenter<ServletRequest, ServletResponse>)current);
                }

                public void onError(AsyncEvent event) throws IOException {
                    TelemetryServletFilter.this.endSpan(request, response, event.getThrowable(), (Instrumenter<ServletRequest, ServletResponse>)current);
                }

                public void onStartAsync(AsyncEvent event) throws IOException {
                    event.getAsyncContext().addListener((AsyncListener)this);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry10.internal.rest.TelemetryServletFilter$1", 1.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
                }
            });
        } else {
            this.endSpan(request, response, null, current);
        }
        if (scope != null) {
            scope.close();
            request.removeAttribute("otel.span.http.scope");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endSpan(ServletRequest request, ServletResponse response, Throwable throwable, Instrumenter<ServletRequest, ServletResponse> current) {
        Context spanContext = (Context)request.getAttribute("otel.span.http.context");
        if (spanContext == null) {
            return;
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("End span traceId=" + Span.fromContext((Context)spanContext).getSpanContext().getTraceId() + " spanId=" + Span.fromContext((Context)spanContext).getSpanContext().getSpanId()), (Object[])new Object[0]);
            }
            current.end(spanContext, (Object)request, (Object)response, throwable);
        }
        finally {
            request.removeAttribute("otel.span.http.context");
            request.removeAttribute("otel.span.http.parentContext");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class HttpServerAttributesGetterImpl
    implements HttpServerAttributesGetter<ServletRequest, ServletResponse> {
        static final long serialVersionUID = 1724517579210709752L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private HttpServerAttributesGetterImpl() {
        }

        public String flavor(ServletRequest request) {
            return null;
        }

        public String route(ServletRequest request) {
            if (request instanceof HttpServletRequest) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)request;
                return httpServletRequest.getContextPath() + httpServletRequest.getServletPath();
            }
            return null;
        }

        public String method(ServletRequest request) {
            if (request instanceof HttpServletRequest) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)request;
                return httpServletRequest.getMethod();
            }
            return null;
        }

        public String target(ServletRequest request) {
            if (request instanceof HttpServletRequest) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)request;
                String path = httpServletRequest.getRequestURI();
                String query = httpServletRequest.getQueryString();
                if (path != null && query != null && !query.isEmpty()) {
                    return path + "?" + query;
                }
                return path;
            }
            return null;
        }

        public String scheme(ServletRequest request) {
            if (request instanceof HttpServletRequest) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)request;
                return httpServletRequest.getScheme();
            }
            return null;
        }

        public Integer statusCode(ServletRequest request, ServletResponse response, @Nullable Throwable error) {
            if (response instanceof HttpServletResponse) {
                HttpServletResponse httpServletResponse = (HttpServletResponse)response;
                return httpServletResponse.getStatus();
            }
            return null;
        }

        public List<String> requestHeader(ServletRequest request, String name) {
            if (request instanceof HttpServletRequest) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)request;
                return Collections.list(httpServletRequest.getHeaders(name));
            }
            return Collections.emptyList();
        }

        public List<String> responseHeader(ServletRequest request, ServletResponse response, String name) {
            if (response instanceof HttpServletResponse) {
                HttpServletResponse httpServletResponse = (HttpServletResponse)response;
                return new ArrayList<String>(httpServletResponse.getHeaders(name));
            }
            return Collections.emptyList();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry10.internal.rest.TelemetryServletFilter$HttpServerAttributesGetterImpl", HttpServerAttributesGetterImpl.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class NetServerAttributesGetterImpl
    implements NetServerAttributesGetter<ServletRequest> {
        static final long serialVersionUID = 6272164216924574614L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private NetServerAttributesGetterImpl() {
        }

        public String transport(ServletRequest request) {
            return "ip_tcp";
        }

        public String hostName(ServletRequest request) {
            return request.getServerName();
        }

        public Integer hostPort(ServletRequest request) {
            return request.getServerPort();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry10.internal.rest.TelemetryServletFilter$NetServerAttributesGetterImpl", NetServerAttributesGetterImpl.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ServletRequestContextTextMapGetter
    implements TextMapGetter<ServletRequest> {
        static final long serialVersionUID = 6753415358317425238L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ServletRequestContextTextMapGetter() {
        }

        public Iterable<String> keys(ServletRequest request) {
            if (request instanceof HttpServletRequest) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)request;
                return new HashSet<String>(Collections.list(httpServletRequest.getHeaderNames()));
            }
            return Collections.emptyList();
        }

        public String get(ServletRequest request, String key) {
            if (request == null) {
                return null;
            }
            if (request instanceof HttpServletRequest) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)request;
                return httpServletRequest.getHeader(key);
            }
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry10.internal.rest.TelemetryServletFilter$ServletRequestContextTextMapGetter", ServletRequestContextTextMapGetter.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
        }
    }
}

