/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.ws.impl;

import com.ibm.jbatch.container.exception.BatchIllegalJobStatusTransitionException;
import com.ibm.jbatch.container.exception.ExecutionAssignedToServerException;
import com.ibm.jbatch.container.persistence.jpa.JobExecutionEntity;
import com.ibm.jbatch.container.persistence.jpa.JobInstanceEntity;
import com.ibm.jbatch.container.persistence.jpa.RemotablePartitionKey;
import com.ibm.jbatch.container.services.IJPAQueryHelper;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.ws.InstanceState;
import com.ibm.jbatch.container.ws.JobInstanceNotQueuedException;
import com.ibm.jbatch.container.ws.WSBatchAuthService;
import com.ibm.jbatch.container.ws.WSJobExecution;
import com.ibm.jbatch.container.ws.WSJobInstance;
import com.ibm.jbatch.container.ws.WSJobRepository;
import com.ibm.jbatch.container.ws.WSRemotablePartitionExecution;
import com.ibm.jbatch.container.ws.WSRemotablePartitionState;
import com.ibm.jbatch.container.ws.WSStepThreadExecutionAggregate;
import com.ibm.jbatch.spi.BatchSecurityHelper;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.batch.operations.JobSecurityException;
import jakarta.batch.operations.NoSuchJobExecutionException;
import jakarta.batch.operations.NoSuchJobInstanceException;
import jakarta.batch.runtime.BatchStatus;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class WSJobRepositoryImpl
implements WSJobRepository {
    private static final String CLASSNAME = WSJobRepositoryImpl.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME, "com.ibm.jbatch.container.internal.resources.JBatchMessages");
    private IPersistenceManagerService persistenceManagerService;
    private WSBatchAuthService authService;
    private BatchSecurityHelper batchSecurityHelper;
    static final long serialVersionUID = 5455142189757182133L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSJobRepositoryImpl() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "<init>", new Object[0]);
        }
        this.batchSecurityHelper = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected void setIPersistenceManagerService(IPersistenceManagerService pms) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "setIPersistenceManagerService", new Object[]{pms});
        }
        this.persistenceManagerService = pms;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "setIPersistenceManagerService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setWSBatchAuthService(WSBatchAuthService bas) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "setWSBatchAuthService", new Object[]{bas});
        }
        this.authService = bas;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "setWSBatchAuthService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unsetWSBatchAuthService(WSBatchAuthService bas) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "unsetWSBatchAuthService", new Object[]{bas});
        }
        if (this.authService == bas) {
            this.authService = null;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "unsetWSBatchAuthService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unsetIPersistenceManagerService(IPersistenceManagerService ref) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "unsetIPersistenceManagerService", new Object[]{ref});
        }
        if (this.persistenceManagerService == ref) {
            this.persistenceManagerService = null;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "unsetIPersistenceManagerService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    protected void setBatchSecurityHelper(BatchSecurityHelper batchSecurityHelper) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "setBatchSecurityHelper", new Object[]{batchSecurityHelper});
        }
        this.batchSecurityHelper = batchSecurityHelper;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "setBatchSecurityHelper");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unsetBatchSecurityHelper(BatchSecurityHelper batchSecurityHelper) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "unsetBatchSecurityHelper", new Object[]{batchSecurityHelper});
        }
        if (this.batchSecurityHelper == batchSecurityHelper) {
            this.batchSecurityHelper = null;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "unsetBatchSecurityHelper");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSJobInstance getJobInstanceFromExecution(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getJobInstanceFromExecution", new Object[]{executionId});
        }
        long instanceId = this.persistenceManagerService.getJobInstanceIdFromExecutionId(this.authorizedExecutionRead(executionId));
        JobInstanceEntity jobInstanceEntity = this.persistenceManagerService.getJobInstance(instanceId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobInstanceEntity = jobInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getJobInstanceFromExecution", jobInstanceEntity);
        }
        return jobInstanceEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSJobExecution getJobExecution(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getJobExecution", new Object[]{executionId});
        }
        JobExecutionEntity jobExecutionEntity = this.persistenceManagerService.getJobExecution(this.authorizedExecutionRead(executionId));
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobExecutionEntity = jobExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getJobExecution", jobExecutionEntity);
        }
        return jobExecutionEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSJobExecution createJobExecution(long jobInstanceId, Properties jobParameters) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "createJobExecution", new Object[]{jobInstanceId, jobParameters});
        }
        JobExecutionEntity jobExecutionEntity = this.persistenceManagerService.createJobExecution(jobInstanceId, jobParameters, new Date());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobExecutionEntity = jobExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "createJobExecution", jobExecutionEntity);
        }
        return jobExecutionEntity;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<WSStepThreadExecutionAggregate> getStepExecutionsFromJobExecution(long jobExecutionId) throws NoSuchJobExecutionException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getStepExecutionsFromJobExecution", new Object[]{jobExecutionId});
        }
        List<WSStepThreadExecutionAggregate> list = this.persistenceManagerService.getStepExecutionAggregatesFromJobExecutionId(this.authorizedExecutionRead(jobExecutionId));
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getStepExecutionsFromJobExecution", list);
        }
        return list;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<WSJobInstance> getJobInstances(IJPAQueryHelper queryHelper, int page, int pageSize) throws NoSuchJobExecutionException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getJobInstances", new Object[]{queryHelper, page, pageSize});
        }
        if (this.authService == null || this.authService.isAdmin() || this.authService.isMonitor()) {
            ArrayList<WSJobInstance> arrayList = new ArrayList<WSJobInstance>(this.persistenceManagerService.getJobInstances(queryHelper, page, pageSize));
            if (logger != null && logger.isLoggable(Level.FINER)) {
                arrayList = arrayList;
                logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getJobInstances", arrayList);
            }
            return arrayList;
        }
        if (this.authService.isGroupAdmin() || this.authService.isGroupMonitor()) {
            queryHelper.setGroups(this.authService.getGroupsForSubject());
            queryHelper.setQueryIssuer(this.authService.getRunAsUser());
            ArrayList<WSJobInstance> arrayList = new ArrayList<WSJobInstance>(this.persistenceManagerService.getJobInstances(queryHelper, page, pageSize));
            if (logger != null && logger.isLoggable(Level.FINER)) {
                arrayList = arrayList;
                logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getJobInstances", arrayList);
            }
            return arrayList;
        }
        if (this.authService.isSubmitter()) {
            queryHelper.setQueryIssuer(this.authService.getRunAsUser());
            ArrayList<WSJobInstance> arrayList = new ArrayList<WSJobInstance>(this.persistenceManagerService.getJobInstances(queryHelper, page, pageSize));
            if (logger != null && logger.isLoggable(Level.FINER)) {
                arrayList = arrayList;
                logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getJobInstances", arrayList);
            }
            return arrayList;
        }
        throw new JobSecurityException("The current user " + this.batchSecurityHelper.getRunAsUser() + " is not authorized to perform any batch operations.");
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSJobInstance getJobInstance(long instanceId) throws NoSuchJobExecutionException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getJobInstance", new Object[]{instanceId});
        }
        JobInstanceEntity jobInstanceEntity = this.persistenceManagerService.getJobInstance(this.authorizedInstanceRead(instanceId));
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobInstanceEntity = jobInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getJobInstance", jobInstanceEntity);
        }
        return jobInstanceEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<WSJobExecution> getJobExecutionsFromInstance(long instanceId) throws NoSuchJobInstanceException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getJobExecutionsFromInstance", new Object[]{instanceId});
        }
        ArrayList<WSJobExecution> arrayList = new ArrayList<WSJobExecution>(this.persistenceManagerService.getJobExecutionsFromJobInstanceId(this.authorizedInstanceRead(instanceId)));
        if (logger != null && logger.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getJobExecutionsFromInstance", arrayList);
        }
        return arrayList;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getBatchAppNameFromExecution(long executionId) throws NoSuchJobInstanceException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getBatchAppNameFromExecution", new Object[]{executionId});
        }
        String string = this.persistenceManagerService.getJobInstanceAppNameFromExecutionId(this.authorizedExecutionRead(executionId));
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getBatchAppNameFromExecution", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getBatchAppNameFromInstance(long instanceId) throws NoSuchJobInstanceException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getBatchAppNameFromInstance", new Object[]{instanceId});
        }
        String string = this.persistenceManagerService.getJobInstanceAppName(this.authorizedInstanceRead(instanceId));
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getBatchAppNameFromInstance", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSJobExecution getMostRecentJobExecutionFromInstance(long instanceId) throws NoSuchJobInstanceException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getMostRecentJobExecutionFromInstance", new Object[]{instanceId});
        }
        JobExecutionEntity jobExecutionEntity = this.persistenceManagerService.getJobExecutionMostRecent(this.authorizedInstanceRead(instanceId));
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobExecutionEntity = jobExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getMostRecentJobExecutionFromInstance", jobExecutionEntity);
        }
        return jobExecutionEntity;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private long authorizedInstanceRead(long instanceId) throws NoSuchJobInstanceException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "authorizedInstanceRead", new Object[]{instanceId});
        }
        if (this.authService != null) {
            this.authService.authorizedInstanceRead(instanceId);
        }
        long l = instanceId;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "authorizedInstanceRead", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private long authorizedExecutionRead(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "authorizedExecutionRead", new Object[]{executionId});
        }
        if (this.authService != null) {
            this.authService.authorizedExecutionRead(executionId);
        }
        long l = executionId;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "authorizedExecutionRead", l);
        }
        return l;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getJobNames() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getJobNames", new Object[0]);
        }
        if (this.authService == null || this.authService.isAdmin() || this.authService.isMonitor()) {
            Set<String> set = this.persistenceManagerService.getJobNamesSet();
            if (logger != null && logger.isLoggable(Level.FINER)) {
                set = set;
                logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getJobNames", set);
            }
            return set;
        }
        if (this.authService.isSubmitter()) {
            Set<String> set = this.persistenceManagerService.getJobNamesSet(this.authService.getRunAsUser());
            if (logger != null && logger.isLoggable(Level.FINER)) {
                set = set;
                logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getJobNames", set);
            }
            return set;
        }
        throw new JobSecurityException("The current user " + this.authService.getRunAsUser() + " is not authorized to perform any batch operations.");
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isJobInstancePurgeable(long jobInstanceId) throws NoSuchJobInstanceException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "isJobInstancePurgeable", new Object[]{jobInstanceId});
        }
        if (this.authService != null) {
            this.authService.authorizedInstanceRead(jobInstanceId);
        }
        boolean bl = this.persistenceManagerService.isJobInstancePurgeable(jobInstanceId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "isJobInstancePurgeable", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSJobInstance updateJobInstanceState(long instanceId, InstanceState state) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "updateJobInstanceState", new Object[]{instanceId, state});
        }
        JobInstanceEntity jobInstanceEntity = this.persistenceManagerService.updateJobInstanceWithInstanceState(instanceId, state, new Date());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobInstanceEntity = jobInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "updateJobInstanceState", jobInstanceEntity);
        }
        return jobInstanceEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSJobInstance updateJobInstanceStateOnRestart(long instanceId) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "updateJobInstanceStateOnRestart", new Object[]{instanceId});
        }
        WSJobInstance wSJobInstance = (WSJobInstance)this.persistenceManagerService.updateJobInstanceOnRestart(instanceId, new Date());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            wSJobInstance = wSJobInstance;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "updateJobInstanceStateOnRestart", wSJobInstance);
        }
        return wSJobInstance;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSJobInstance updateJobInstanceStateOnConsumed(long instanceId) throws BatchIllegalJobStatusTransitionException, JobInstanceNotQueuedException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "updateJobInstanceStateOnConsumed", new Object[]{instanceId});
        }
        WSJobInstance wSJobInstance = (WSJobInstance)this.persistenceManagerService.updateJobInstanceStateOnConsumed(instanceId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            wSJobInstance = wSJobInstance;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "updateJobInstanceStateOnConsumed", wSJobInstance);
        }
        return wSJobInstance;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSJobInstance updateJobInstanceStateOnQueued(long instanceId) throws BatchIllegalJobStatusTransitionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "updateJobInstanceStateOnQueued", new Object[]{instanceId});
        }
        WSJobInstance wSJobInstance = (WSJobInstance)this.persistenceManagerService.updateJobInstanceStateOnQueued(instanceId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            wSJobInstance = wSJobInstance;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "updateJobInstanceStateOnQueued", wSJobInstance);
        }
        return wSJobInstance;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSJobInstance updateJobInstanceAndExecutionWithInstanceStateAndBatchStatus(long instanceId, long executionId, InstanceState state, BatchStatus batchStatus) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "updateJobInstanceAndExecutionWithInstanceStateAndBatchStatus", new Object[]{instanceId, executionId, state, batchStatus});
        }
        JobInstanceEntity retMe = null;
        retMe = (JobInstanceEntity)this.persistenceManagerService.updateJobInstanceWithInstanceStateAndBatchStatus(instanceId, state, batchStatus, new Date());
        this.persistenceManagerService.updateJobExecutionAndInstanceOnStatusChange(executionId, batchStatus, new Date());
        JobInstanceEntity jobInstanceEntity = retMe;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobInstanceEntity = jobInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "updateJobInstanceAndExecutionWithInstanceStateAndBatchStatus", jobInstanceEntity);
        }
        return jobInstanceEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<WSStepThreadExecutionAggregate> getStepExecutionAggregatesFromJobExecution(long jobExecutionId) throws NoSuchJobExecutionException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getStepExecutionAggregatesFromJobExecution", new Object[]{jobExecutionId});
        }
        if (this.authService != null) {
            this.authService.authorizedExecutionRead(jobExecutionId);
        }
        List<WSStepThreadExecutionAggregate> list = this.persistenceManagerService.getStepExecutionAggregatesFromJobExecutionId(jobExecutionId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getStepExecutionAggregatesFromJobExecution", list);
        }
        return list;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSStepThreadExecutionAggregate getStepExecutionAggregateFromJobExecution(long jobExecutionId, String stepName) throws NoSuchJobExecutionException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getStepExecutionAggregateFromJobExecution", new Object[]{jobExecutionId, stepName});
        }
        if (this.authService != null) {
            this.authService.authorizedExecutionRead(jobExecutionId);
        }
        WSStepThreadExecutionAggregate wSStepThreadExecutionAggregate = this.persistenceManagerService.getStepExecutionAggregateFromJobExecutionId(jobExecutionId, stepName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            wSStepThreadExecutionAggregate = wSStepThreadExecutionAggregate;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getStepExecutionAggregateFromJobExecution", wSStepThreadExecutionAggregate);
        }
        return wSStepThreadExecutionAggregate;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSStepThreadExecutionAggregate getStepExecutionAggregate(long topLevelStepExecutionId) throws IllegalArgumentException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getStepExecutionAggregate", new Object[]{topLevelStepExecutionId});
        }
        if (this.authService != null) {
            this.authService.authorizedStepExecutionRead(topLevelStepExecutionId);
        }
        WSStepThreadExecutionAggregate wSStepThreadExecutionAggregate = this.persistenceManagerService.getStepExecutionAggregate(topLevelStepExecutionId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            wSStepThreadExecutionAggregate = wSStepThreadExecutionAggregate;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getStepExecutionAggregate", wSStepThreadExecutionAggregate);
        }
        return wSStepThreadExecutionAggregate;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSStepThreadExecutionAggregate getStepExecutionAggregateFromJobExecutionNumberAndStepName(long jobInstanceId, short jobExecNum, String stepName) throws NoSuchJobExecutionException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getStepExecutionAggregateFromJobExecutionNumberAndStepName", new Object[]{jobInstanceId, jobExecNum, stepName});
        }
        if (this.authService != null) {
            this.authService.authorizedInstanceRead(jobInstanceId);
        }
        WSStepThreadExecutionAggregate wSStepThreadExecutionAggregate = this.persistenceManagerService.getStepExecutionAggregateFromJobExecutionNumberAndStepName(jobInstanceId, jobExecNum, stepName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            wSStepThreadExecutionAggregate = wSStepThreadExecutionAggregate;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getStepExecutionAggregateFromJobExecutionNumberAndStepName", wSStepThreadExecutionAggregate);
        }
        return wSStepThreadExecutionAggregate;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSJobExecution getJobExecutionFromJobExecNum(long jobInstanceId, int jobExecNum) throws NoSuchJobExecutionException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getJobExecutionFromJobExecNum", new Object[]{jobInstanceId, jobExecNum});
        }
        if (this.authService != null) {
            this.authService.authorizedInstanceRead(jobInstanceId);
        }
        JobExecutionEntity jobExecutionEntity = this.persistenceManagerService.getJobExecutionFromJobExecNum(jobInstanceId, jobExecNum);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobExecutionEntity = jobExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getJobExecutionFromJobExecNum", jobExecutionEntity);
        }
        return jobExecutionEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSJobInstance updateJobInstanceWithInstanceStateAndBatchStatus(long instanceId, InstanceState state, BatchStatus batchStatus) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "updateJobInstanceWithInstanceStateAndBatchStatus", new Object[]{instanceId, state, batchStatus});
        }
        WSJobInstance wSJobInstance = (WSJobInstance)this.persistenceManagerService.updateJobInstanceWithInstanceStateAndBatchStatus(instanceId, state, batchStatus, new Date());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            wSJobInstance = wSJobInstance;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "updateJobInstanceWithInstanceStateAndBatchStatus", wSJobInstance);
        }
        return wSJobInstance;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSJobExecution updateJobExecutionAndInstanceOnStatusChange(long jobExecutionId, BatchStatus status, Date date) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "updateJobExecutionAndInstanceOnStatusChange", new Object[]{jobExecutionId, status, date});
        }
        WSJobExecution wSJobExecution = (WSJobExecution)this.persistenceManagerService.updateJobExecutionAndInstanceOnStatusChange(jobExecutionId, status, date);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            wSJobExecution = wSJobExecution;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "updateJobExecutionAndInstanceOnStatusChange", wSJobExecution);
        }
        return wSJobExecution;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSJobExecution updateJobExecutionAndInstanceNotSetToServerYet(long jobExecutionId, Date date) throws ExecutionAssignedToServerException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "updateJobExecutionAndInstanceNotSetToServerYet", new Object[]{jobExecutionId, date});
        }
        WSJobExecution wSJobExecution = this.updateJobExecutionAndInstanceOnStopBeforeServerAssigned(jobExecutionId, date);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            wSJobExecution = wSJobExecution;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "updateJobExecutionAndInstanceNotSetToServerYet", wSJobExecution);
        }
        return wSJobExecution;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSJobExecution updateJobExecutionAndInstanceOnStopBeforeServerAssigned(long jobExecutionId, Date date) throws ExecutionAssignedToServerException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "updateJobExecutionAndInstanceOnStopBeforeServerAssigned", new Object[]{jobExecutionId, date});
        }
        WSJobExecution wSJobExecution = (WSJobExecution)this.persistenceManagerService.updateJobExecutionAndInstanceOnStopBeforeServerAssigned(jobExecutionId, date);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            wSJobExecution = wSJobExecution;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "updateJobExecutionAndInstanceOnStopBeforeServerAssigned", wSJobExecution);
        }
        return wSJobExecution;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSRemotablePartitionExecution createRemotablePartition(RemotablePartitionKey remotablePartitionKey) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "createRemotablePartition", new Object[]{remotablePartitionKey});
        }
        WSRemotablePartitionExecution wSRemotablePartitionExecution = this.persistenceManagerService.createRemotablePartition(remotablePartitionKey);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            wSRemotablePartitionExecution = wSRemotablePartitionExecution;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "createRemotablePartition", wSRemotablePartitionExecution);
        }
        return wSRemotablePartitionExecution;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSRemotablePartitionState getRemotablePartitionInternalState(RemotablePartitionKey remotablePartitionKey) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getRemotablePartitionInternalState", new Object[]{remotablePartitionKey});
        }
        WSRemotablePartitionState wSRemotablePartitionState = this.persistenceManagerService.getRemotablePartitionInternalState(remotablePartitionKey);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            wSRemotablePartitionState = wSRemotablePartitionState;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getRemotablePartitionInternalState", (Object)wSRemotablePartitionState);
        }
        return wSRemotablePartitionState;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<WSRemotablePartitionExecution> getRemotablePartitionsForJobExecution(long jobExecutionId) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getRemotablePartitionsForJobExecution", new Object[]{jobExecutionId});
        }
        List<WSRemotablePartitionExecution> list = this.persistenceManagerService.getRemotablePartitionsForJobExecution(jobExecutionId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getRemotablePartitionsForJobExecution", list);
        }
        return list;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getJobExecutionEntityVersion() throws Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getJobExecutionEntityVersion", new Object[0]);
        }
        int n = this.persistenceManagerService.getJobExecutionEntityVersion();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getJobExecutionEntityVersion", n);
        }
        return n;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getJobInstanceEntityVersion() throws Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getJobInstanceEntityVersion", new Object[0]);
        }
        int n = this.persistenceManagerService.getJobInstanceEntityVersion();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "getJobInstanceEntityVersion", n);
        }
        return n;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSJobInstance updateJobInstanceWithGroupNames(long jobInstanceId, Set<String> groupNames) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "updateJobInstanceWithGroupNames", new Object[]{jobInstanceId, groupNames});
        }
        if (this.authService == null) {
            logger.log(Level.WARNING, "BATCH_SECURITY_NOT_ACTIVE", new Object[]{jobInstanceId});
            JobInstanceEntity jobInstanceEntity = this.persistenceManagerService.updateJobInstanceWithGroupNames(jobInstanceId, new HashSet<String>());
            if (logger != null && logger.isLoggable(Level.FINER)) {
                jobInstanceEntity = jobInstanceEntity;
                logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "updateJobInstanceWithGroupNames", jobInstanceEntity);
            }
            return jobInstanceEntity;
        }
        HashSet<String> normalizedNames = new HashSet();
        normalizedNames = this.authService.normalizeGroupNames(groupNames);
        JobInstanceEntity jobInstanceEntity = this.persistenceManagerService.updateJobInstanceWithGroupNames(jobInstanceId, normalizedNames);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobInstanceEntity = jobInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobRepositoryImpl", "updateJobInstanceWithGroupNames", jobInstanceEntity);
        }
        return jobInstanceEntity;
    }
}

