/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry20.logging.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.kernel.service.util.ServiceCaller;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.telemetry20.logging.internal.semconv.SemconvConstantsAccessor;
import io.opentelemetry.semconv.UserAgentAttributes;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MpTelemetryAccessEventMappingUtils {
    private static final ServiceCaller<SemconvConstantsAccessor> semconvConstantsAccessorCaller;
    private static final String[][] ACCESS_ATTRIBUTE_TABLE;
    private static final String[][] ACCESS_SPECIAL_KEY_ATTRIBUTE_TABLE;
    private static final String[][] ACCESS_COOKIE_KEY_ATTRIBUTE_TABLE;
    private static final int ACCESS_TYPE_FIELD_INDEX = 0;
    private static final int OTEL_ACCESS_TYPE_FIELD_INDEX = 1;
    static final long serialVersionUID = -3039372130513128605L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static String getOTelMappedAccessEventKeyName(String accessKey) {
        String[][] accessTable = MpTelemetryAccessEventMappingUtils.getSpecialAccessTypes(accessKey);
        String formattedKey = null;
        if (accessTable != null) {
            for (String[] field : accessTable) {
                if (accessTable == ACCESS_SPECIAL_KEY_ATTRIBUTE_TABLE) {
                    if (!accessKey.contains(field[0])) continue;
                    formattedKey = accessKey.replace(field[0].toString(), field[1].toString());
                    continue;
                }
                if (accessTable == ACCESS_COOKIE_KEY_ATTRIBUTE_TABLE) {
                    formattedKey = accessKey.replace(field[0].toString(), field[1].toString());
                    continue;
                }
                if (!field[0].equals(accessKey)) continue;
                formattedKey = field[1];
                if (formattedKey != null) break;
                break;
            }
        }
        return formattedKey;
    }

    private static String[][] getSpecialAccessTypes(String accessKey) {
        if (accessKey.startsWith("requestHeader_") || accessKey.startsWith("responseHeader_")) {
            return ACCESS_SPECIAL_KEY_ATTRIBUTE_TABLE;
        }
        if (accessKey.startsWith("cookie_")) {
            return ACCESS_COOKIE_KEY_ATTRIBUTE_TABLE;
        }
        return ACCESS_ATTRIBUTE_TABLE;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter", "com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry20.logging.internal.MpTelemetryAccessEventMappingUtils", MpTelemetryAccessEventMappingUtils.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
        semconvConstantsAccessorCaller = new ServiceCaller(MpTelemetryAccessEventMappingUtils.class, SemconvConstantsAccessor.class);
        SemconvConstantsAccessor semconvConstantsAccessor = (SemconvConstantsAccessor)semconvConstantsAccessorCaller.current().get();
        String[][] accessAttributeTableTemp = new String[][]{{"remoteHost", semconvConstantsAccessor.clientAddress().toString()}, {"requestMethod", semconvConstantsAccessor.httpRequestMethod().toString()}, {"requestPort", semconvConstantsAccessor.localNetworkPort().toString()}, {"requestFirstLine", "io.openliberty.access_log.request_first_line"}, {"responseCode", semconvConstantsAccessor.httpResponseStatusCode().toString()}, {"requestStartTime", "io.openliberty.access_log.request_start_time"}, {"remoteUserID", "io.openliberty.access_log.remote_user_id"}, {"uriPath", "io.openliberty.access_log.url.path"}, {"elapsedTime", "io.openliberty.access_log.elapsed_time"}, {"remoteIP", semconvConstantsAccessor.networkPeerAddress().toString()}, {"requestHost", semconvConstantsAccessor.accessRequestHost().toString()}, {"requestElapsedTime", "io.openliberty.access_log.request_elapsed_time"}, {"sequence", "io.openliberty.sequence"}, {"bytesSent", "io.openliberty.access_log.bytes_sent"}, {"userAgent", UserAgentAttributes.USER_AGENT_ORIGINAL.toString()}, {"bytesReceived", "io.openliberty.access_log.bytes_received"}};
        ACCESS_ATTRIBUTE_TABLE = accessAttributeTableTemp;
        ACCESS_SPECIAL_KEY_ATTRIBUTE_TABLE = new String[][]{{"responseHeader_", "http.response.header."}, {"requestHeader_", "http.request.header."}};
        ACCESS_COOKIE_KEY_ATTRIBUTE_TABLE = new String[][]{{"cookie_", "io.openliberty.access_log.cookie_"}};
    }
}

