/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.message;

import com.ibm.ws.jain.protocol.ip.sip.address.URIImpl;
import com.ibm.ws.jain.protocol.ip.sip.message.SipVersion;
import com.ibm.ws.jain.protocol.ip.sip.message.SipVersionFactory;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import com.ibm.ws.sip.parser.util.CharsBuffersPool;
import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import jain.protocol.ip.sip.address.URI;
import java.io.Serializable;
import java.util.Objects;

public class RequestLine
implements Serializable {
    protected URI m_uri;
    String m_method;
    protected SipVersion m_version;

    public RequestLine() {
        this.m_version = SipVersionFactory.createVersion();
    }

    public RequestLine(URI requestURI, String method) {
        this.m_uri = requestURI;
        this.m_method = method;
        this.m_version = SipVersionFactory.createVersion();
    }

    public URI getURI() {
        return this.m_uri;
    }

    public String getMethod() {
        return this.m_method;
    }

    public SipVersion getSipVersion() {
        return this.m_version;
    }

    public void setURI(URI uri) {
        this.m_uri = uri;
    }

    public void setMethod(String method) {
        this.m_method = method;
    }

    public void setSipVersion(SipVersion version) {
        this.m_version = version;
    }

    public String toString() {
        CharsBuffer buffer = CharsBuffersPool.getBuffer();
        this.writeToCharBuffer(buffer, false);
        String value = buffer.toString();
        CharsBuffersPool.putBufferBack(buffer);
        return value;
    }

    public void writeToCharBuffer(CharsBuffer ret, boolean network) {
        if (this.m_method != null) {
            ret.append(this.m_method);
            ret.append(' ');
        }
        if (this.m_uri != null) {
            boolean hide = network ? false : SIPTransactionStack.instance().getConfiguration().hideRequestUri();
            if (hide) {
                ret.append("<hidden request URI>");
            } else {
                ((URIImpl)this.m_uri).writeToCharBuffer(ret);
            }
            ret.append(' ');
        }
        ret.append(this.m_version.toString());
        ret.append("\r\n");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RequestLine)) {
            return false;
        }
        RequestLine other = (RequestLine)obj;
        boolean ret = true;
        if (this.m_method != null) {
            ret = this.m_method.equals(other.m_method);
        }
        if (this.m_uri != null) {
            ret = ret && this.m_uri.equals(other.m_uri);
        }
        return ret && this.m_version.equals(other.m_version);
    }

    public int hashCode() {
        return Objects.hash(this.m_method, this.m_uri, this.m_version);
    }
}

