/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.naptr;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.message.MessageImpl;
import com.ibm.ws.sip.container.naptr.ISenderListener;
import com.ibm.ws.sip.container.naptr.SendProcessor;
import com.ibm.ws.sip.container.servlets.OutgoingSipServletRequest;
import com.ibm.ws.sip.container.servlets.SipServletResponseImpl;
import com.ibm.ws.sip.stack.context.MessageContext;
import com.ibm.ws.sip.stack.context.MessageContextFactory;
import com.ibm.ws.sip.stack.naptr.INaptrSender;
import com.ibm.ws.sip.stack.naptr.NaptrHandler;
import jain.protocol.ip.sip.address.SipURL;
import jain.protocol.ip.sip.message.Request;
import java.io.IOException;

public class NaptrSenderContainer
extends SendProcessor
implements INaptrSender {
    private static final LogMgr c_logger = Log.get(NaptrSenderContainer.class);
    protected ISenderListener _client;
    private SipServletResponseImpl _503Response;
    private NaptrHandler _naptrHandler;

    public NaptrSenderContainer() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "NaptrSenderContainer", "New NaptrSenderContainer created  = " + this.toString());
        }
        this._naptrHandler = new NaptrHandler(this);
    }

    @Override
    public void cleanItself() {
        this._client = null;
        this._503Response = null;
        this._naptrHandler.cleanSelf();
        super.cleanItself();
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "cleanItself", "Clean NaptrSenderContainer = " + this.toString());
        }
    }

    @Override
    public void sendRequest(OutgoingSipServletRequest request, ISenderListener client) throws IOException {
        if (client != null && this._client == null) {
            this._client = client;
        }
        MessageContext messageContext = MessageContextFactory.instance().getMessageContext(request.getRequest());
        if (!((MessageImpl)((Object)request.getRequest())).isLoopback()) {
            this._naptrHandler.sendToNextDestination(messageContext, this._client.getTarget());
        } else {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "sendRequest", "no need to do NPTR resole, this is a loopback request");
            }
            this._naptrHandler.sendWithoutLookup(messageContext, this._client.getTarget());
        }
    }

    @Override
    public void responseReceived(SipServletResponseImpl response, ISenderListener client) {
        MessageImpl messageImpl = (MessageImpl)response.getMessage();
        if (response.getStatus() == 503 && !messageImpl.isLoopback()) {
            this._503Response = response;
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "responseReceived", "503 response received - try next destination");
            }
            Request request = client.getOutgoingRequest().getRequest();
            MessageContext messageContext = MessageContextFactory.instance().getMessageContext(request);
            this._naptrHandler.sendToNextDestination(messageContext, this._client.getTarget());
        } else {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "responseReceived", "Final response received - forward to the client Transaction");
            }
            this._client.responseReceived(response);
        }
    }

    @Override
    public void processTimeout(ISenderListener client) {
        Request request = client.getOutgoingRequest().getRequest();
        MessageContext messageContext = MessageContextFactory.instance().getMessageContext(request);
        this._naptrHandler.sendToNextDestination(messageContext, this._client.getTarget());
    }

    @Override
    public void error(MessageContext messageContext) {
        MessageContext.doneWithContext(messageContext);
        if (this._503Response != null) {
            this._client.responseReceived(this._503Response);
        } else {
            this._client.failedToSendRequest(true);
        }
    }

    @Override
    public void sendMessage(MessageContext messageContext, String transport) {
        MessageContext.doneWithContext(messageContext);
        OutgoingSipServletRequest request = this._client.getOutgoingRequest();
        try {
            request.updateParamAccordingToDestination();
            if (c_logger.isTraceDebugEnabled()) {
                StringBuffer buff = new StringBuffer();
                buff.append("Sending request to the next destination = ");
                buff.append(this._naptrHandler.getLastUsedDestination());
                c_logger.traceDebug(this, "sendRequestDownstream", buff.toString());
            }
            this.send(request, this._client);
        }
        catch (IOException e2) {
            if (c_logger.isTraceDebugEnabled()) {
                StringBuffer buff = new StringBuffer();
                buff.append("IOException when sending request. try next destination for request: ");
                buff.append(request);
                c_logger.traceDebug(this, "sendToNextDestination", buff.toString());
            }
            MessageContext newMessageContext = MessageContextFactory.instance().getMessageContext(request.getRequest());
            this._naptrHandler.sendToNextDestination(newMessageContext, this._client.getTarget());
        }
    }

    @Override
    public SipURL getLastUsedDestination(ISenderListener client) {
        return this._naptrHandler.getLastUsedDestination();
    }
}

