/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.rules;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.rules.Operator;
import com.ibm.ws.sip.container.rules.PhoneComparison;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SubDomainOf
extends Operator {
    private static final LogMgr c_logger = Log.get(SubDomainOf.class);
    private String m_value;
    private boolean m_ignoreCase;

    public SubDomainOf(String var, String value, boolean ignoreCase) {
        super(var);
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{var, value, new Boolean(ignoreCase)};
            c_logger.traceEntry((Object)this, "SubDomainOf", params);
        }
        this.m_value = value;
        this.m_ignoreCase = ignoreCase;
    }

    @Override
    protected boolean evaluate(String value) {
        boolean rc;
        if (this.m_value == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "evaluate", "Subdomain evaluated to false compared value is null");
            }
            return false;
        }
        if (this.isSubDomainName(this.m_value)) {
            rc = this.isMatchingSubDomainName(value, this.m_value);
        } else if (this.isIp(this.m_value)) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "evaluate", "SubDomain Of, Checking IP match");
            }
            rc = this.m_value.equals(value);
        } else {
            rc = false;
        }
        if (!rc && this.isSubDomainPhone(this.m_value)) {
            rc = this.checkTelephonyPrefixMatching(value, this.m_value);
        }
        if (c_logger.isTraceDebugEnabled()) {
            String tmp = "Is " + value + " SubDomain Of ";
            tmp = tmp + this.m_value + ", Result: " + rc;
            c_logger.traceDebug(this, "evaluate", tmp);
        }
        return rc;
    }

    @Override
    protected boolean evaluate(PhoneComparison value) {
        return value.equals(this.m_value, this.m_ignoreCase);
    }

    private boolean isMatchingSubDomainName(String subDomainParam, String domainParam) {
        String subDomain = subDomainParam;
        String domain = domainParam;
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{subDomain, domain};
            c_logger.traceEntry((Object)this, "isMatchingSubDomainName", params);
        }
        boolean rc = false;
        if (this.m_ignoreCase) {
            subDomain = subDomain.toLowerCase();
            domain = domain.toLowerCase();
        }
        if (subDomain.endsWith(domain)) {
            rc = true;
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "isMatchingSubDomainName", new Boolean(rc));
        }
        return rc;
    }

    private boolean isSubDomainName(String value) {
        boolean rc = true;
        boolean letter = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isLetter(c)) {
                letter = true;
                continue;
            }
            if (Character.isDigit(c) || c == '.' || c == '-') continue;
            rc = false;
            break;
        }
        return rc && letter;
    }

    private boolean isSubDomainPhone(String value) {
        String validPhoneNumberChars = "0123456789abcd+-().*#pw";
        boolean rc = true;
        for (int i = 0; i < value.length(); ++i) {
            char c = Character.toLowerCase(value.charAt(i));
            if ("0123456789abcd+-().*#pw".indexOf(c) >= 0) continue;
            rc = false;
            break;
        }
        return rc;
    }

    private boolean checkTelephonyPrefixMatching(String telParam, String prefixParam) {
        String tel = telParam;
        String prefix = prefixParam;
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{tel, prefix};
            c_logger.traceEntry((Object)this, "checkTelephonyPrefixMatching", params);
        }
        boolean rc = false;
        tel = this.removeSeparatorsFromTel(tel);
        prefix = this.removeSeparatorsFromTel(prefix);
        rc = tel.startsWith(prefix);
        return rc;
    }

    private String removeSeparatorsFromTel(String tel) {
        StringBuffer buffer = new StringBuffer(16);
        for (int i = 0; i < tel.length(); ++i) {
            char c = Character.toLowerCase(tel.charAt(i));
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'd' || c == '*') && c != '#') continue;
            buffer.append(c);
        }
        return buffer.toString();
    }

    private boolean isIp(String value) {
        boolean rc;
        block2: {
            rc = false;
            try {
                InetAddress.getByName(value);
                rc = true;
            }
            catch (UnknownHostException e2) {
                if (!c_logger.isTraceDebugEnabled()) break block2;
                c_logger.traceDebug(this, "isIp", "SubDomain Of, Not an IP: " + this.m_value);
            }
        }
        return rc;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(16);
        buffer.append(this.getVariable());
        buffer.append(" SUBDOMAIN-OF '");
        buffer.append(this.m_value);
        buffer.append("'");
        return buffer.toString();
    }
}

