/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.security.auth;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.common.crypto.CryptoUtils;
import com.ibm.ws.sip.container.servlets.SipServletMessageImpl;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.servlets.SipServletResponseImpl;
import com.ibm.ws.sip.security.auth.DigestUtils;
import jain.protocol.ip.sip.header.SecurityHeader;
import java.io.IOException;
import java.util.Random;
import java.util.StringTokenizer;

class AuthHeader {
    private static final LogMgr c_logger = Log.get(AuthHeader.class);
    private static final String NONCE_COUNT_VALUE = "00000001";
    private static Random s_rndGenerator = new Random();
    private int _statusCode;
    private String _realm;
    private String _username;
    private String _password;

    public AuthHeader(int statusCode, String realm, String username, String password) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "<init>", statusCode, realm, username, "*****");
        }
        this._statusCode = statusCode;
        this._realm = realm;
        this._username = username;
        this._password = password;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "<init>");
        }
    }

    public String getPassword() {
        return this._password;
    }

    public String getRealm() {
        return this._realm;
    }

    public int getStatusCode() {
        return this._statusCode;
    }

    public String getUsername() {
        return this._username;
    }

    public void writeToRequest(SipServletRequestImpl request, SipServletResponseImpl response) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "writeToRequest", request, response);
        }
        SecurityHeader challange = response.getAuthHeader(this._realm);
        String nonce = challange.getParameter("nonce");
        String qopParam = challange.getParameter("qop");
        String qop = this.chooseBestQop(qopParam);
        String algorithm = challange.getParameter("algorithm");
        String opaque = challange.getParameter("opaque");
        String sipMethod = request.getMethod();
        String uri = request.getRequestURI().toString();
        byte[] body = null;
        if (qop != null && qop.equals("auth-int")) {
            body = this.getBody(request);
        }
        String nc = NONCE_COUNT_VALUE;
        long cnonceVal = System.currentTimeMillis() | s_rndGenerator.nextLong();
        String cnonce = String.valueOf(cnonceVal);
        boolean isServerAuthentication = response.getStatus() == 401;
        String headerName = isServerAuthentication ? "Authorization" : "Proxy-Authorization";
        String headerValue = this.createHeaderString(sipMethod, nonce, qop, nc, cnonce, uri, algorithm, opaque, body);
        request.addHeader(headerName, headerValue);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "writeToRequest");
        }
    }

    private String chooseBestQop(String qopList) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "chooseBestQop", (Object)qopList);
        }
        if (qopList == null) {
            return null;
        }
        String retVal = null;
        StringTokenizer tokenizer = new StringTokenizer(qopList, ",");
        while (tokenizer.hasMoreTokens()) {
            String currValue = tokenizer.nextToken();
            if (currValue.equals("auth-int")) {
                retVal = currValue;
                break;
            }
            if (!currValue.equals("auth")) continue;
            retVal = currValue;
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "chooseBestQop", retVal);
        }
        return retVal;
    }

    private byte[] getBody(SipServletMessageImpl message) {
        byte[] body;
        block4: {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry((Object)this, "getBody", (Object)message);
            }
            body = null;
            try {
                body = message.getRawContent();
            }
            catch (IOException e2) {
                if (!c_logger.isErrorEnabled()) break block4;
                c_logger.error("error.exception.ioeinbody", "Other", null, (Throwable)e2);
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "getBody", (Object)body);
        }
        return body;
    }

    private String createHeaderString(String sipMethod, String nonce, String qop, String nc, String cnonce, String uri, String algorithm, String opaque, byte[] body) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "createHeaderString", sipMethod, nonce, qop, nc, cnonce, uri, algorithm, opaque, body);
        }
        StringBuffer header = new StringBuffer("Digest");
        header.append(' ');
        String params = this.getAuthParamString(sipMethod, nonce, qop, nc, cnonce, uri, algorithm, opaque, body);
        header.append(params);
        String headerString = header.toString();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "createHeaderString", headerString);
        }
        return headerString;
    }

    private String getAuthParamString(String sipMethod, String nonce, String qop, String nc, String cnonce, String uri, String algorithm, String opaque, byte[] body) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "getAuthParamString", sipMethod, nonce, qop, nc, cnonce, uri, algorithm, opaque, body);
        }
        String digest = this.getDigestAsString(sipMethod, nonce, qop, nc, cnonce, uri, algorithm, body);
        StringBuffer header = new StringBuffer();
        this.addParam(header, "realm", this._realm, true);
        this.addParam(header, "username", this._username, true);
        this.addParam(header, "uri", uri, true);
        this.addParam(header, "nonce", nonce, true);
        algorithm = CryptoUtils.isFips140_3Enabled() ? (algorithm == null ? "SHA-256" : algorithm) : (algorithm == null ? "MD5" : algorithm);
        this.addParam(header, "algorithm", algorithm, true);
        if (qop != null) {
            this.addParam(header, "qop", qop, true);
            this.addParam(header, "cnonce", cnonce, true);
            this.addParam(header, "nc", nc, false);
        }
        if (opaque != null) {
            this.addParam(header, "opaque", opaque, true);
        }
        this.addParam(header, "response", digest, true);
        String headerString = header.toString();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "getAuthParamString", headerString);
        }
        return headerString;
    }

    private String getDigestAsString(String sipMethod, String nonce, String qop, String nc, String cnonce, String uri, String algorithm, byte[] body) {
        String digest = DigestUtils.createDigestFromAuthParams(this._username, this._realm, this._password, nonce, qop, nc, cnonce, uri, algorithm, sipMethod, body);
        return digest;
    }

    private void addParam(StringBuffer buffer, String paramName, String value, boolean quoted) {
        if (buffer.length() > 0) {
            buffer.append(',');
        }
        buffer.append(paramName);
        buffer.append('=');
        if (quoted) {
            buffer.append('\"');
        }
        buffer.append(value);
        if (quoted) {
            buffer.append('\"');
        }
    }
}

