/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction.transactions.st;

import com.ibm.ws.jain.protocol.ip.sip.message.RequestImpl;
import com.ibm.ws.jain.protocol.ip.sip.message.ResponseImpl;
import com.ibm.ws.sip.stack.context.MessageContext;
import com.ibm.ws.sip.stack.context.MessageContextFactory;
import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import com.ibm.ws.sip.stack.transaction.transactions.BranchMethodKey;
import com.ibm.ws.sip.stack.transaction.transactions.MergedRequestKey;
import com.ibm.ws.sip.stack.transaction.transactions.SIPTransaction;
import com.ibm.ws.sip.stack.transaction.transactions.SIPTransactionImpl;
import com.ibm.ws.sip.stack.transaction.transactions.SIPTransactionsModel;
import com.ibm.ws.sip.stack.transaction.transactions.st.SIPServerTransaction;
import com.ibm.ws.sip.stack.transaction.transport.SIPTransportException;
import jain.protocol.ip.sip.SipEvent;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.header.HeaderParseException;
import jain.protocol.ip.sip.header.ViaHeader;
import jain.protocol.ip.sip.message.Request;
import jain.protocol.ip.sip.message.Response;

public abstract class SIPServerTransactionImpl
extends SIPTransactionImpl
implements SIPServerTransaction {
    private MergedRequestKey m_mergedRequestKey;

    public SIPServerTransactionImpl(SIPTransactionStack transactionStack, SipProvider provider, Request req, BranchMethodKey key, MergedRequestKey mergedRequestKey) {
        super(transactionStack, provider, req, key, -1L);
        this.m_mergedRequestKey = mergedRequestKey;
    }

    @Override
    public MergedRequestKey getMergedRequestKey() {
        return this.m_mergedRequestKey;
    }

    @Override
    public void setMergedRequestKey(MergedRequestKey key) {
        this.m_mergedRequestKey = key;
    }

    @Override
    public boolean isRequestPartOfTransaction(Request req) {
        ViaHeader newVia;
        ViaHeader oldVia;
        block8: {
            Request initial = this.getFirstRequest();
            if (initial == null) {
                return false;
            }
            try {
                oldVia = (ViaHeader)initial.getHeader("Via", true);
                newVia = (ViaHeader)req.getHeader("Via", true);
            }
            catch (HeaderParseException e2) {
                return false;
            }
            catch (IllegalArgumentException e3) {
                return false;
            }
            try {
                String newBranch = newVia.getBranch();
                String oldBranch = oldVia.getBranch();
                if (newBranch == null || !newBranch.startsWith("z9hG4bK")) break block8;
                boolean rc = newBranch.equals(oldBranch);
                try {
                    rc = req.getMethod().equals("ACK") ? rc && initial.getMethod().equals("INVITE") : rc && initial.getMethod().equals(req.getMethod());
                    rc = rc && oldVia.getHost().equals(newVia.getHost()) && oldVia.getPort() == newVia.getPort();
                }
                catch (SipParseException e4) {
                    return false;
                }
                return rc;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this.is2543RequestPartOfTransaction(req, oldVia, newVia);
    }

    protected abstract boolean is2543RequestPartOfTransaction(Request var1, ViaHeader var2, ViaHeader var3);

    @Override
    public void sendResponseToTransport(Response sipResponse) throws SIPTransportException {
        RequestImpl request = (RequestImpl)this.getFirstRequest();
        if (request != null && request.isLoopback()) {
            ((ResponseImpl)sipResponse).setLoopback(true);
        }
        SipProvider provider = this.getProviderContext();
        MessageContext messageContext = MessageContextFactory.instance().getMessageContext(sipResponse, (SIPTransaction)this);
        try {
            this.getParentStack().getTransportCommLayerMgr().sendMessage(messageContext, provider, this.getTransportConnection(), this);
        }
        catch (Exception e2) {
            messageContext.writeError(e2);
        }
    }

    @Override
    public void sendRequestToUA(Request req) {
        this.forwardRequestToJainLayer(req, this.getId());
    }

    public void sendRequestToUA(Request req, long transactionId) {
        this.forwardRequestToJainLayer(req, transactionId);
    }

    private void forwardRequestToJainLayer(Request req, long transactionId) {
        SipEvent event = new SipEvent((Object)this.getProviderContext(), transactionId, req);
        this.getParentStack().getUACommLayer().sendEventToUA(event);
    }

    @Override
    public void notifyRespnseErrorToUA(Response sipResponse) {
        SipEvent event = new SipEvent((Object)this.getProviderContext(), this.getId(), sipResponse);
        this.getParentStack().getUACommLayer().sendEventToUA(event);
    }

    public void notifyTimeOutToUA() {
        SipEvent event = new SipEvent((Object)this.getProviderContext(), this.getId(), true);
        this.getParentStack().getUACommLayer().sendEventToUA(event);
    }

    public void remove() {
        SIPTransactionsModel.instance().remove(this);
    }
}

