/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.sip.netty;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sip.parser.util.InetAddressCache;
import com.ibm.ws.sip.stack.dispatch.Dispatcher;
import com.ibm.ws.sip.stack.transaction.transport.Hop;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPConnectionAdapter;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPListenningConnection;
import com.ibm.ws.sip.stack.transaction.transport.connections.SipMessageByteBuffer;
import com.ibm.ws.sip.stack.transaction.util.SIPStackUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.net.InetSocketAddress;

public abstract class BaseConnection
extends SIPConnectionAdapter {
    private static final TraceComponent tc = Tr.register(BaseConnection.class);
    private InetSocketAddress m_peer;
    private SIPListenningConnection m_channel;

    public BaseConnection(SIPListenningConnection channel) {
        this(null, 0, channel);
    }

    public BaseConnection(String peerHost, int peerPort, SIPListenningConnection channel) {
        super(peerHost, peerPort);
        this.m_peer = peerHost == null ? null : InetAddressCache.getInetSocketAddress(peerHost, peerPort);
        this.m_connectionStatus = SIPConnectionAdapter.ConnectionStatus.PRE_CONNECT;
        this.m_channel = channel;
    }

    @Override
    protected void connectionEstablished() {
        super.connectionEstablished();
    }

    protected static ByteBuf stackBufferToByteBuf(SipMessageByteBuffer stackBuffer) {
        byte[] bytes = stackBuffer.getBytes();
        int length = stackBuffer.getMarkedBytesNumber();
        ByteBuf buffer = Unpooled.buffer((int)length, (int)length);
        buffer.writeBytes(bytes, 0, length);
        stackBuffer.reset();
        return buffer;
    }

    protected void messageReceived(SipMessageByteBuffer buffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"messageReceived", (Object[])new Object[0]);
        }
        Dispatcher.instance().queueIncomingDataEvent(buffer, this);
    }

    protected void setRemoteAddress(InetSocketAddress address) {
        if (this.m_peer != null) {
            throw new IllegalStateException("setRemoteAddress: " + (address != null ? address : "") + " already connected");
        }
        this.m_peer = address;
        String peerHost = SIPStackUtil.getHostAddress(address.getAddress());
        int peerPort = address.getPort();
        this.setRemoteHost(peerHost);
        this.setRemotePort(peerPort);
        Hop hop = new Hop(this.getTransport(), peerHost, peerPort);
        this.setKey(hop);
    }

    @Override
    public void start() throws IOException {
    }

    @Override
    public void close() {
        this.m_connectionStatus = SIPConnectionAdapter.ConnectionStatus.CLOSED;
        super.close();
    }

    @Override
    public SIPListenningConnection getSIPListenningConnection() {
        return this.m_channel;
    }
}

