/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.sip.netty;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPConnection;
import com.ibm.ws.sip.stack.transaction.util.SIPStackUtil;
import com.ibm.ws.sip.stack.transport.sip.netty.SipInboundChannel;
import com.ibm.ws.sip.stack.transport.sip.netty.SipUdpConnLink;
import com.ibm.ws.sip.stack.transport.sip.netty.SipUdpConnection;
import com.ibm.ws.sip.stack.transport.sip.netty.UdpSender;
import io.netty.channel.Channel;
import jain.protocol.ip.sip.ListeningPoint;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;

public class SipUdpInboundChannel
extends SipInboundChannel {
    private static final TraceComponent tc = Tr.register(SipUdpInboundChannel.class);
    private static HashMap s_instances = new HashMap();
    private UdpSender m_connLink = null;
    private Channel m_channel;

    public static SipUdpInboundChannel instance(ListeningPoint lp, String outboundChainName) {
        SipUdpInboundChannel channel = (SipUdpInboundChannel)s_instances.get(lp);
        if (channel == null) {
            channel = new SipUdpInboundChannel(lp, outboundChainName);
            s_instances.put(lp, channel);
        }
        return channel;
    }

    private SipUdpInboundChannel(ListeningPoint lp, String outboundChainName) {
        super(lp, outboundChainName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UdpSender getConnectionLink() {
        if (this.m_connLink == null) {
            SipUdpInboundChannel sipUdpInboundChannel = this;
            synchronized (sipUdpInboundChannel) {
                if (this.m_connLink == null) {
                    this.m_connLink = SipUdpConnLink.instance(this);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"getConnectionLink", (Object[])new Object[]{this.m_connLink.toString()});
        }
        return this.m_connLink;
    }

    public synchronized void setChannel(Channel channel) {
        this.m_channel = channel;
    }

    synchronized Channel getChannel() {
        return this.m_channel;
    }

    void connectionClosed() {
        this.m_connLink = null;
        this.m_channel = null;
    }

    @Override
    public SIPConnection createConnection(InetAddress remoteAddress, int remotePort) throws IOException {
        String remoteHost = SIPStackUtil.getHostAddress(remoteAddress);
        UdpSender connLink = this.getConnectionLink();
        Channel channel = this.getChannel();
        return new SipUdpConnection(remoteHost, remotePort, this, connLink, channel);
    }
}

