/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.sip.converge;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.session.SessionApplicationParameters;
import com.ibm.ws.session.SessionContext;
import com.ibm.ws.session.SessionManagerConfig;
import com.ibm.ws.session.SessionStoreService;
import com.ibm.ws.sip.container.internal.SipContainerComponent;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.router.SipAppDescManager;
import com.ibm.ws.webcontainer.osgi.DynamicVirtualHost;
import com.ibm.ws.webcontainer.osgi.DynamicVirtualHostManager;
import com.ibm.ws.webcontainer.session.impl.HttpSessionContextImpl;
import com.ibm.ws.webcontainer.session.impl.HttpSessionImpl;
import com.ibm.wsspi.session.ISession;
import com.ibm.wsspi.session.IStore;
import com.ibm.wsspi.sip.converge.ConvergedHttpSessionImpl;
import com.ibm.wsspi.sip.converge.IConvergedHttpSessionContext;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;

public class ConvergedHttpSessionContextImpl
extends HttpSessionContextImpl
implements IConvergedHttpSessionContext {
    private static final transient LogMgr c_logger = Log.get(ConvergedHttpSessionImpl.class);

    public ConvergedHttpSessionContextImpl(SessionManagerConfig smc, SessionApplicationParameters sap, SessionStoreService sessionStoreService) {
        super(smc, sap, sessionStoreService, true);
    }

    @Override
    public Object createSessionObject(ISession isess, ServletContext servCtx) {
        return new ConvergedHttpSessionImpl(isess, (SessionContext)this, servCtx);
    }

    @Override
    public String getSipBaseUrlForEncoding(String contextPath, String relativePath, String scheme) {
        return ConvergedHttpSessionContextImpl.getSipBaseUrlForEncoding(this._smc, contextPath, relativePath, scheme, this);
    }

    public static String getSipBaseUrlForEncoding(SessionManagerConfig smc, String contextPath, String relativePath, String scheme, HttpSessionContextImpl session) {
        int port;
        String hostName;
        int httpsPort;
        int httpPort;
        StringBuffer returnUrl;
        block25: {
            DynamicVirtualHostManager dhostm;
            DynamicVirtualHost dhost;
            SipAppDesc app;
            String appName;
            int temp;
            returnUrl = new StringBuffer();
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry("getSipBaseUrlForEncoding", " relativePath = " + relativePath);
            }
            if ((temp = (appName = session.getAppName()).indexOf(47)) != 1) {
                appName = appName.substring(++temp);
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("getSipBaseUrlForEncoding: ApplicationName = " + appName);
            }
            if ((app = SipAppDescManager.getInstance().getSipAppDescByAppName(appName)) == null) {
                if (c_logger.isTraceEntryExitEnabled()) {
                    c_logger.traceExit("getSipBaseUrlForEncoding", " Failed to find application by name ");
                }
                return relativePath.toString();
            }
            httpPort = -1;
            httpsPort = -1;
            hostName = null;
            boolean isSecure = false;
            boolean infoFound = false;
            if ("https".equalsIgnoreCase(scheme)) {
                isSecure = true;
            }
            if ((dhost = (dhostm = SipContainerComponent.getVirtualHostMgr()).getVirtualHost(app.getVirtualHostName(), null)) == null) {
                if (c_logger.isTraceEntryExitEnabled()) {
                    c_logger.traceExit("getSipBaseUrlForEncoding", " DynamicVirtualHost was not found");
                }
                return relativePath.toString();
            }
            List aliases = dhost.getAliases();
            for (String aliase : aliases) {
                httpPort = dhost.getHostConfiguration().getHttpPort(aliase);
                httpsPort = dhost.getHostConfiguration().getSecureHttpPort(aliase);
                hostName = dhost.getName();
                if (isSecure) {
                    if (httpsPort == -1) continue;
                    infoFound = true;
                    break;
                }
                if (httpPort == -1) continue;
                infoFound = true;
                break;
            }
            if (!infoFound) {
                if (c_logger.isTraceEntryExitEnabled()) {
                    c_logger.traceExit("getSipBaseUrlForEncoding", " No appropriate port was found. Will not encode host:port to URL");
                }
                return relativePath.toString();
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("getSipBaseUrlForEncoding: Encoding httpPort = " + httpPort + " httpsPort = " + httpsPort + " hostName = " + hostName);
            }
            if (hostName.equals("*") || hostName.equals("default_host")) {
                try {
                    InetAddress addr = InetAddress.getLocalHost();
                    hostName = addr.getHostName();
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("getSipBaseUrlForEncoding: local Addrr = " + addr + " hostname of system = " + hostName);
                    }
                }
                catch (UnknownHostException e2) {
                    if (!c_logger.isTraceDebugEnabled()) break block25;
                    c_logger.traceDebug("getSipBaseUrlForEncoding: exception = " + e2);
                }
            }
        }
        if ("https".equalsIgnoreCase(scheme)) {
            port = httpsPort;
            returnUrl.append("https://");
        } else {
            port = httpPort;
            returnUrl.append("http://");
        }
        returnUrl.append(hostName).append(":").append(port);
        if (contextPath != null) {
            if (contextPath.startsWith("/")) {
                returnUrl.append(contextPath);
            } else {
                returnUrl.append("/").append(contextPath);
            }
        }
        if (relativePath != null) {
            if (relativePath.startsWith("/")) {
                returnUrl.append(relativePath);
            } else {
                returnUrl.append("/").append(relativePath);
            }
        }
        return returnUrl.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpSession getHttpSessionById(String sessId) {
        HttpSessionImpl sd = null;
        IStore iStore = this._coreHttpSessionManager.getIStore();
        if (c_logger.isTraceEntryExitEnabled()) {
            StringBuffer sb = new StringBuffer(sessId).append(" ").append(iStore.getId());
            c_logger.traceEntry((Object)this, "getHttpSessionById", (Object)sb.toString());
        }
        try {
            iStore.setThreadContext();
            sd = (HttpSessionImpl)this._coreHttpSessionManager.getSession(sessId, true);
        }
        finally {
            iStore.unsetThreadContext();
        }
        if (sd != null) {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit((Object)this, "getHttpSessionById", "got a session");
            }
            return (HttpSession)sd.getFacade();
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "getHttpSessionById", null);
        }
        return null;
    }
}

