/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer31.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.webcontainer31.async.ThreadContextManager;
import com.ibm.ws.webcontainer31.srt.SRTUpgradeInputStream31;
import com.ibm.ws.webcontainer31.upgrade.UpgradeReadCallback;
import com.ibm.ws.webcontainer31.upgrade.UpgradedWebConnectionImpl;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.ChannelFrameworkFactory;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import com.ibm.wsspi.webcontainer31.WCCustomProperties31;
import java.io.IOException;
import javax.servlet.ReadListener;
import javax.servlet.http.WebConnection;

public class UpgradeInputByteBufferUtil {
    private static final TraceComponent tc = Tr.register(UpgradeInputByteBufferUtil.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer31.resources.Messages");
    private UpgradedWebConnectionImpl _upConn;
    private TCPConnectionContext _tcpContext;
    private long _totalBytesRead = 0L;
    private ReadListener _rl;
    private UpgradeReadCallback _tcpChannelCallback;
    private boolean _isInitialRead = false;
    private WsByteBuffer _buffer = null;
    private IOException _error = null;
    private boolean _isClosing = false;
    private boolean _isReady = true;
    private boolean _isFirstRead = true;
    private boolean _closed = false;
    private boolean _isReadLine = false;
    private boolean isAlldataReadCalled = false;
    private boolean isonErrorCalled = false;

    public UpgradeInputByteBufferUtil(UpgradedWebConnectionImpl up) {
        this._upConn = up;
        this._tcpContext = this._upConn.getTCPConnectionContext();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"UpgradeInputByteBufferUtil:: constructor", (Object[])new Object[0]);
        }
    }

    private boolean doRead(int amountToRead) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("doRead, Current buffer, " + this._buffer + ", reading from the TCP Channel, readLine : " + this._isReadLine), (Object[])new Object[0]);
        }
        try {
            if (this._tcpChannelCallback != null && !this._isReadLine) {
                return this.immediateRead(amountToRead);
            }
            return this.syncRead(amountToRead);
        }
        catch (IOException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("doRead, we encountered an exception during the read : " + e), (Object[])new Object[0]);
            }
            if (this._error != null) {
                return false;
            }
            this._error = e;
            throw e;
        }
    }

    private boolean syncRead(int amountToRead) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"syncRead, Executing a synchronous read", (Object[])new Object[0]);
        }
        this.setAndAllocateBuffer(amountToRead);
        try {
            long bytesRead = this._tcpContext.getReadInterface().read(1L, WCCustomProperties31.UPGRADE_READ_TIMEOUT);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("syncRead, Completed the read, " + bytesRead), (Object[])new Object[0]);
            }
            if (bytesRead > 0L) {
                this._buffer = this._tcpContext.getReadInterface().getBuffer();
                this.configurePostReadBuffer();
                this._totalBytesRead += (long)this._buffer.remaining();
                return true;
            }
            return false;
        }
        catch (IOException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("syncRead, We encountered an exception during the read : " + e), (Object[])new Object[0]);
            }
            this._error = e;
            throw e;
        }
    }

    private boolean immediateRead(int amountToRead) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("immediateRead ENTER , buffer size [" + amountToRead + "]"), (Object[])new Object[0]);
        }
        if (amountToRead > 1) {
            if (this._upConn.getVirtualConnection().getStateMap().get("NotUpgradedUnreadData") != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("immediateRead, read from saved buffer [" + this._buffer + "] , amount [" + this._buffer.remaining() + "]"), (Object[])new Object[0]);
                }
                this._upConn.getVirtualConnection().getStateMap().remove("NotUpgradedUnreadData");
            } else {
                WsByteBuffer tempBuffer = this.allocateBuffer(amountToRead);
                tempBuffer.position(0);
                tempBuffer.limit(amountToRead);
                tempBuffer.put(this._buffer);
                tempBuffer.position(1);
                this._buffer.release();
                this._buffer = tempBuffer;
                tempBuffer = null;
                this._tcpContext.getReadInterface().setBuffer(this._buffer);
                long bytesRead = 0L;
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"immediateRead, read from interface", (Object[])new Object[0]);
                    }
                    bytesRead = this._tcpContext.getReadInterface().read(0L, WCCustomProperties31.UPGRADE_READ_TIMEOUT);
                }
                catch (IOException readException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("immediateRead, The read encountered an exception. " + readException), (Object[])new Object[0]);
                        Tr.debug((TraceComponent)tc, (String)"immediateRead, Return with our one byte", (Object[])new Object[0]);
                    }
                    this.configurePostReadBuffer();
                    return true;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("immediateRead, Complete, " + bytesRead), (Object[])new Object[0]);
                }
                this._buffer = this._tcpContext.getReadInterface().getBuffer();
                this.configurePostReadBuffer();
            }
            this._totalBytesRead += (long)this._buffer.remaining();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("immediateRead EXIT , returns to application this buffer [" + this._buffer + "], totalBytesRead [" + this._totalBytesRead + "]"), (Object[])new Object[0]);
        }
        return true;
    }

    public int read() throws IOException {
        this.validate();
        int rc = -1;
        if (this.doRead(1)) {
            rc = this._buffer.get() & 0xFF;
        }
        this._buffer.release();
        this._buffer = null;
        return rc;
    }

    public int read(byte[] output) throws IOException {
        return this.read(output, 0, output.length);
    }

    public int read(byte[] output, int offset, int length) throws IOException {
        int size = -1;
        this.validate();
        if (0 == length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"read(byte[],int,int), Target length was 0", (Object[])new Object[0]);
            }
            return length;
        }
        if (this.doRead(length)) {
            size = this._buffer.limit() - this._buffer.position();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("(byte[],int,int) Filling byte array, size --> " + size), (Object[])new Object[0]);
            }
            this._buffer.get(output, offset, size);
        }
        this._buffer.release();
        this._buffer = null;
        return size;
    }

    private void setAndAllocateBuffer(int sizeToAllocate) {
        if (this._buffer == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setAndAllocateBuffer, Buffer is null, size to allocate is : " + sizeToAllocate), (Object[])new Object[0]);
            }
            this._buffer = this.allocateBuffer(sizeToAllocate);
        }
        this.configurePreReadBuffer(sizeToAllocate);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setAndAllocateBuffer, buffer [" + this._buffer + "] , size [" + sizeToAllocate + "]"), (Object[])new Object[0]);
        }
        this._tcpContext.getReadInterface().setBuffer(this._buffer);
    }

    private void validate() throws IOException {
        if (null != this._error) {
            throw this._error;
        }
        if (!this._isReadLine && !this._isReady) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                Tr.error((TraceComponent)tc, (String)"read.failed.isReady.false", (Object[])new Object[0]);
            }
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"read.failed.isReady.false", (Object[])new Object[0]));
        }
    }

    private void configurePostReadBuffer() {
        this._buffer.flip();
    }

    private void configurePreReadBuffer(int amountToRead) {
        this._buffer.limit(amountToRead);
        this._buffer.position(0);
    }

    private WsByteBuffer allocateBuffer(int bufferSize) {
        return ChannelFrameworkFactory.getBufferManager().allocateDirect(bufferSize);
    }

    public void setupReadListener(ReadListener readListenerl, SRTUpgradeInputStream31 srtUpgradeStream) {
        if (readListenerl == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                Tr.error((TraceComponent)tc, (String)"readlistener.is.null", (Object[])new Object[0]);
            }
            throw new NullPointerException(Tr.formatMessage((TraceComponent)tc, (String)"readlistener.is.null", (Object[])new Object[0]));
        }
        if (this._rl != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                Tr.error((TraceComponent)tc, (String)"readlistener.already.started", (Object[])new Object[0]);
            }
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"readlistener.already.started", (Object[])new Object[0]));
        }
        ThreadContextManager tcm = new ThreadContextManager();
        this._tcpChannelCallback = new UpgradeReadCallback(readListenerl, this, tcm, srtUpgradeStream);
        this._rl = readListenerl;
        this._isReady = false;
        this._upConn.getVirtualConnection().getStateMap().put("UpgradedListener", "true");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setupReadListener, Starting the initial read", (Object[])new Object[0]);
        }
        this.initialRead();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setupReadListener, UpgradeReadCallback [" + this._tcpChannelCallback + "] , ReadListener [" + this._rl + "]"), (Object[])new Object[0]);
        }
    }

    public boolean isReady() {
        block7: {
            if (this._rl == null) {
                return true;
            }
            long bytesRead = 0L;
            if (this._buffer != null && this._buffer.hasRemaining()) {
                this._isReady = true;
                return this._isReady;
            }
            try {
                this.setAndAllocateBuffer(1);
                bytesRead = this._tcpContext.getReadInterface().read(0L, WCCustomProperties31.UPGRADE_READ_TIMEOUT);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("isReady, Completed the read, " + bytesRead), (Object[])new Object[0]);
                }
                if (bytesRead == 1L) {
                    this._buffer = this._tcpContext.getReadInterface().getBuffer();
                    this.configurePostReadBuffer();
                    this._isReady = true;
                    return this._isReady;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("isReady, Read some amount of data other than one byte on the read : " + bytesRead), (Object[])new Object[0]);
                }
                this._buffer.release();
                this._buffer = null;
            }
            catch (IOException ioe) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)("isReady, An exception happened during the check of isReady : " + ioe + ", returning false"), (Object[])new Object[0]);
            }
        }
        this._isReady = false;
        return this._isReady;
    }

    public void initialRead() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("initialRead ENTER , callback [" + this._tcpChannelCallback + "], readListener [" + this._rl + "]"), (Object[])new Object[0]);
        }
        this._isInitialRead = true;
        if (this._buffer != null) {
            this._buffer.release();
            this._buffer = null;
        }
        WsByteBuffer data = null;
        data = (WsByteBuffer)this._upConn.getVirtualConnection().getStateMap().get("NotUpgradedUnreadData");
        if (data != null) {
            int remaining = data.remaining();
            this.setAndAllocateBuffer(remaining);
            this._buffer.put(data);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("initialRead, saved [" + remaining + "] unread data from statemap [" + data + "] into _buffer [" + this._buffer + "]"), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("initialRead, invoke callback complete [" + this._tcpChannelCallback + "]"), (Object[])new Object[0]);
            }
            data.release();
            data = null;
            this._upConn.getVirtualConnection().getStateMap().put("NotUpgradedUnreadData", "initialRead");
            this._tcpChannelCallback.complete(this._upConn.getVirtualConnection(), this._tcpContext.getReadInterface());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"initialRead, callback complete. All initial data read.", (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"initialRead, async read data from interface", (Object[])new Object[0]);
        }
        this.setAndAllocateBuffer(1);
        this._tcpContext.getReadInterface().read(1L, (TCPReadCompletedCallback)this._tcpChannelCallback, true, WCCustomProperties31.UPGRADE_READ_TIMEOUT);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"initialRead EXIT", (Object[])new Object[0]);
        }
    }

    public void configurePostInitialReadBuffer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"configurePostInitialReadBuffer", (Object[])new Object[0]);
        }
        this._isInitialRead = false;
        this._isFirstRead = false;
        this._buffer = this._tcpContext.getReadInterface().getBuffer();
        this.configurePostReadBuffer();
    }

    public boolean isInitialRead() {
        return this._isInitialRead;
    }

    public void setIsInitialRead(boolean isInitialRead) {
        this._isInitialRead = isInitialRead;
    }

    public boolean isFirstRead() {
        return this._isFirstRead;
    }

    public Boolean close() {
        boolean closeResult;
        block14: {
            this._isClosing = true;
            closeResult = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("close, Initial read outstanding : " + this._isInitialRead), (Object[])new Object[0]);
            }
            if (this._isInitialRead) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"close, Cancelling any outstanding read", (Object[])new Object[0]);
                }
                this._tcpContext.getReadInterface().read(1L, (TCPReadCompletedCallback)this._tcpChannelCallback, false, -2);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"close, Call to cancel complete", (Object[])new Object[0]);
                }
                if (this._isInitialRead) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"close, Timeout has been called, waiting for it to complete", (Object[])new Object[0]);
                    }
                    closeResult = true;
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"close, No read outstanding, no reason to call cancel", (Object[])new Object[0]);
                    }
                    closeResult = false;
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"close, No read outstanding, no reason to call cancel", (Object[])new Object[0]);
                }
                closeResult = false;
            }
            if (this._rl != null && !this.isAlldataReadCalled()) {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"close, We are now closed, calling the ReadListener onAllDataRead", (Object[])new Object[0]);
                    }
                    this.setAlldataReadCalled(true);
                    this._rl.onAllDataRead();
                }
                catch (IOException ioe) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block14;
                    Tr.debug((TraceComponent)tc, (String)("close, Encountered an exception while calling onAllDAtaRead : " + ioe), (Object[])new Object[0]);
                }
            }
        }
        return closeResult;
    }

    public boolean isClosing() {
        return this._isClosing;
    }

    public UpgradeReadCallback get_tcpChannelCallback() {
        return this._tcpChannelCallback;
    }

    public WebConnection getWebConn() {
        return this._upConn;
    }

    public void readLineCall() throws IOException {
        boolean bl = this._isReadLine = !this._isReadLine;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"readLine", (Object[])new Object[]{"readLine flag : " + this._isReadLine});
        }
    }

    public boolean isAlldataReadCalled() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isAlldataReadCalled", (Object[])new Object[]{"value -->" + this.isAlldataReadCalled});
        }
        return this.isAlldataReadCalled;
    }

    public void setAlldataReadCalled(boolean isAlldataReadCalled) {
        this.isAlldataReadCalled = isAlldataReadCalled;
    }

    public boolean isIsonErrorCalled() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isIsonErrorCalled", (Object[])new Object[]{"value -->" + this.isonErrorCalled});
        }
        return this.isonErrorCalled;
    }

    public void setIsonErrorCalled(boolean isonErrorCalled) {
        this.isonErrorCalled = isonErrorCalled;
    }
}

