/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openid20.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.common.crypto.CryptoUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openid20.OpenidClientConfig;
import com.ibm.ws.security.openid20.internal.UserInfo;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenidClientConfigImpl
implements OpenidClientConfig {
    private static final TraceComponent tc = Tr.register(OpenidClientConfigImpl.class, (String)"OpenId", (String)"com.ibm.ws.security.openid20.internal.resources.OpenIDMessages");
    public static final String CFG_KEY_ALLOW_STATELESS = "allowStateless";
    public static final String CFG_KEY_MAP_IDENTITY_TO_REGISTRY_USER = "mapIdentityToRegistryUser";
    public static final String CFG_KEY_USE_CLIENT_IDENTITY = "useClientIdentity";
    public static final String CFG_KEY_AUTHENTICATION_MODE = "authenticationMode";
    public static final String CFG_KEY_MAX_ASSOCIATION_ATTEMPS = "maxAssociationAttempts";
    public static final String CFG_KEY_NONCE_VALID_TIME = "nonceValidTime";
    public static final String CFG_KEY_SHARED_KEY_ENCRYPTION_ENABLED = "sharedKeyEncryptionEnabled";
    public static final String CFG_KEY_HASH_ALGORITHM = "hashAlgorithm";
    public static final String CFG_KEY_SSL_REF = "sslRef";
    public static final String CFG_KEY_USER_INFO_REF = "userInfoRef";
    public static final String CFG_KEY_HTTPS_REQUIRED = "httpsRequired";
    public static final String CFG_KEY_SEARCH_NUMBER_OF_USER_INFO_TO_MAP = "searchNumberOfUserInfoToMap";
    public static final String CFG_KEY_FAILED_ASSOC_EXPIRE = "failedAssocExpire";
    public static final String CFG_KEY_CONNECT_TIMEOUT = "connectTimeout";
    public static final String CFG_KEY_SOCKET_TIMEOUT = "socketTimeout";
    public static final String CFG_KEY_HOST_NAME_VERIFICATION_ENABLED = "hostNameVerificationEnabled";
    public static final String CFG_KEY_MAX_DISCOVERY_CACHE_SIZE = "maxDiscoveryCacheSize";
    public static final String CFG_KEY_MAX_DISCOVER_RETRY = "maxDiscoverRetry";
    public static final String CFG_KEY_GROUP_IDENTIFIER = "groupIdentifier";
    public static final String CFG_KEY_REALM_IDENTIFIER = "realmIdentifier";
    public static final String CFG_KEY_CHARACTER_ENCODING = "characterEncoding";
    public static final String CFG_KEY_INCLUDE_USER_INFO_IN_SUBJECT = "includeUserInfoInSubject";
    public static final String CFG_KEY_INCLUDE_CUSTOM_CACHE_KEY_IN_SUBJECT = "includeCustomCacheKeyInSubject";
    public static final String CFG_KEY_PROVIDER_IDENTIFIER = "providerIdentifier";
    public static final String CFG_KEY_AUTH_FILTER_REF = "authFilterRef";
    public static final String CFG_KEY_ALLOW_BASIC_AUTHENTICATION = "allowBasicAuthentication";
    public static final String CFG_KEY_TRY_OPENID_IF_BASIC_AUTH_FAILS = "tryOpenIDIfBasicAuthFails";
    public static final String CFG_KEY_ALIAS = "alias";
    public static final String CFG_KEY_URI_TYPE = "uriType";
    public static final String CFG_KEY_COUNT = "count";
    public static final String CFG_KEY_REQUIRED = "required";
    public static final String ENCRYPTION_NO = "no-encryption";
    public static final String ENCRYPTION_DH_SHA1 = "DH-SHA1";
    public static final String ENCRYPTION_DH_SHA256 = "DH-SHA256";
    public static final String SIGNATURE_HMAC_SHA1 = "HMAC-SHA1";
    public static final String SIGNATURE_HMAC_SHA256 = "HMAC-SHA256";
    public static final String HASH_ALG_SHA1 = "SHA1";
    public static final String HASH_ALG_SHA256 = "SHA256";
    public static final String KEY_CONFIGURATION_ADMIN = "configurationAdmin";
    private static final Object KEY_ID = "id";
    private final AtomicServiceReference<ConfigurationAdmin> configAdminRef = new AtomicServiceReference("configurationAdmin");
    boolean allowStateless;
    private int maxAssociationAttempts;
    private long nonceValidTime;
    private boolean httpsRequired;
    private boolean mapIdentityToRegistryUser;
    private boolean useClientIdentity;
    private String sessionEncryptionType;
    private String signatureAlgorithm;
    private String sslRef;
    private long failedAssocExpire;
    private long connectTimeout;
    private long socketTimeout;
    public boolean hostNameVerificationEnabled;
    private int searchNumberOfUserInfoToMap;
    private int maxDiscoveryCacheSize;
    private int maxDiscoverRetry;
    private boolean checkImmediate;
    private String groupIdentifier;
    private String realmIdentifier;
    private String characterEncoding;
    private boolean includeUserInfoInSubject;
    private boolean includeCustomCacheKeyInSubject;
    private String providerIdentifier;
    private String authFilterRef;
    private String authFilterId;
    private boolean allowBasicAuthentication;
    private boolean tryOpenIDIfBasicAuthFails;
    private List<UserInfo> userInfo = new ArrayList<UserInfo>();
    private String bundleLocation;
    static final long serialVersionUID = -3455800657014422027L;

    @Reference(name="configurationAdmin", service=ConfigurationAdmin.class)
    protected void setConfigurationAdmin(ServiceReference<ConfigurationAdmin> ref) {
        this.configAdminRef.setReference(ref);
    }

    protected void unsetConfigurationAdmin(ServiceReference<ConfigurationAdmin> ref) {
        this.configAdminRef.unsetReference(ref);
    }

    protected synchronized void activate(ComponentContext cc, Map<String, Object> props) {
        this.configAdminRef.activate(cc);
        this.bundleLocation = cc.getBundleContext().getBundle().getLocation();
        this.processConfigProps(props);
        Tr.info((TraceComponent)tc, (String)"OPENID_RP_CONFIG_PROCESSED", (Object[])new Object[0]);
    }

    protected synchronized void modify(Map<String, Object> props) {
        this.processConfigProps(props);
        Tr.info((TraceComponent)tc, (String)"OPENID_RP_CONFIG_MODIFIED", (Object[])new Object[0]);
    }

    protected synchronized void deactivate(ComponentContext cc) {
        this.configAdminRef.deactivate(cc);
        this.bundleLocation = null;
    }

    private void processConfigProps(Map<String, Object> props) {
        if (props == null || props.isEmpty()) {
            return;
        }
        this.mapIdentityToRegistryUser = (Boolean)props.get(CFG_KEY_MAP_IDENTITY_TO_REGISTRY_USER);
        this.useClientIdentity = (Boolean)props.get(CFG_KEY_USE_CLIENT_IDENTITY);
        this.connectTimeout = (Long)props.get(CFG_KEY_CONNECT_TIMEOUT);
        this.allowStateless = (Boolean)props.get(CFG_KEY_ALLOW_STATELESS);
        this.failedAssocExpire = (Long)props.get(CFG_KEY_FAILED_ASSOC_EXPIRE);
        this.nonceValidTime = (Long)props.get(CFG_KEY_NONCE_VALID_TIME);
        this.maxDiscoveryCacheSize = (Integer)props.get(CFG_KEY_MAX_DISCOVERY_CACHE_SIZE);
        this.maxDiscoverRetry = (Integer)props.get(CFG_KEY_MAX_DISCOVER_RETRY);
        this.searchNumberOfUserInfoToMap = (Integer)props.get(CFG_KEY_SEARCH_NUMBER_OF_USER_INFO_TO_MAP);
        this.maxAssociationAttempts = (Integer)props.get(CFG_KEY_MAX_ASSOCIATION_ATTEMPS);
        this.socketTimeout = (Long)props.get(CFG_KEY_SOCKET_TIMEOUT);
        this.sslRef = (String)props.get(CFG_KEY_SSL_REF);
        this.hostNameVerificationEnabled = (Boolean)props.get(CFG_KEY_HOST_NAME_VERIFICATION_ENABLED);
        this.userInfo = this.processUserInfo(props, CFG_KEY_USER_INFO_REF);
        this.httpsRequired = (Boolean)props.get(CFG_KEY_HTTPS_REQUIRED);
        String authenticationMode = (String)props.get(CFG_KEY_AUTHENTICATION_MODE);
        this.checkImmediate = authenticationMode != null && "checkid_immediate".equalsIgnoreCase(authenticationMode);
        boolean sharedKeyEncryptionEnabled = (Boolean)props.get(CFG_KEY_SHARED_KEY_ENCRYPTION_ENABLED);
        String hashAlgorithm = (String)props.get(CFG_KEY_HASH_ALGORITHM);
        this.setSessionEncryptionType(sharedKeyEncryptionEnabled, hashAlgorithm);
        this.setSignatureAlgorithm(hashAlgorithm);
        this.groupIdentifier = (String)props.get(CFG_KEY_GROUP_IDENTIFIER);
        this.realmIdentifier = (String)props.get(CFG_KEY_REALM_IDENTIFIER);
        this.characterEncoding = (String)props.get(CFG_KEY_CHARACTER_ENCODING);
        this.includeUserInfoInSubject = (Boolean)props.get(CFG_KEY_INCLUDE_USER_INFO_IN_SUBJECT);
        this.includeCustomCacheKeyInSubject = (Boolean)props.get(CFG_KEY_INCLUDE_CUSTOM_CACHE_KEY_IN_SUBJECT);
        this.providerIdentifier = (String)props.get(CFG_KEY_PROVIDER_IDENTIFIER);
        this.authFilterRef = (String)props.get(CFG_KEY_AUTH_FILTER_REF);
        this.authFilterId = this.getAuthFilterId(this.authFilterRef);
        this.allowBasicAuthentication = (Boolean)props.get(CFG_KEY_ALLOW_BASIC_AUTHENTICATION);
        this.tryOpenIDIfBasicAuthFails = (Boolean)props.get(CFG_KEY_TRY_OPENID_IF_BASIC_AUTH_FAILS);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("mapIdentityToRegistryUser: " + this.mapIdentityToRegistryUser), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("useClientIdentity: " + this.useClientIdentity), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("connectTimeout: " + this.connectTimeout), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("allowStateless: " + this.allowStateless), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("failedAssocExpire: " + this.failedAssocExpire), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("nonceValidTime: " + this.nonceValidTime), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("maxDiscoveryCacheSize: " + this.maxDiscoveryCacheSize), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("maxDiscoverRetry: " + this.maxDiscoverRetry), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("searchNumberOfUserInfoToMap: " + this.searchNumberOfUserInfoToMap), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("maxAssociationAttempts: " + this.maxAssociationAttempts), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("socketTimeout: " + this.socketTimeout), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("sslRef: " + this.sslRef), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("hostNameVerificationEnabled: " + this.hostNameVerificationEnabled), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("userInfo: " + this.userInfo), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("httpsRequired: " + this.httpsRequired), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("authenticationMode: " + authenticationMode), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("checkImmediate: " + this.checkImmediate), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("sharedKeyEncryptionEnabled: " + sharedKeyEncryptionEnabled), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("hashAlgorithm: " + hashAlgorithm), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("sessionEncryptionType: " + this.sessionEncryptionType), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("signatureAlgorithm: " + this.signatureAlgorithm), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("groupIdentifier: " + this.groupIdentifier), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("realmIdentifier: " + this.realmIdentifier), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("encoding: " + this.characterEncoding), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("includeUserInfoInSubject: " + this.includeUserInfoInSubject), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("includeCustomCacheKeyInSubject: " + this.includeCustomCacheKeyInSubject), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("providerIdentifier: " + this.providerIdentifier), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("authFilterRef: " + this.authFilterRef), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("authFilterId: " + this.authFilterId), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("allowBasicAuthentication: " + this.allowBasicAuthentication), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("tryOpenIDIfBasicAuthFails: " + this.tryOpenIDIfBasicAuthFails), (Object[])new Object[0]);
        }
        this.validateConfig();
    }

    private void setSessionEncryptionType(Boolean sharedKeyEnc, String hashAlgorithmValue) {
        if (sharedKeyEnc.booleanValue()) {
            if (HASH_ALG_SHA1.equalsIgnoreCase(hashAlgorithmValue)) {
                CryptoUtils.logInsecureAlgorithm((String)CFG_KEY_HASH_ALGORITHM, (String)hashAlgorithmValue);
                this.sessionEncryptionType = ENCRYPTION_DH_SHA1;
            } else {
                this.sessionEncryptionType = ENCRYPTION_DH_SHA256;
            }
        } else {
            this.sessionEncryptionType = ENCRYPTION_NO;
        }
    }

    private void setSignatureAlgorithm(String hashAlgorithmValue) {
        if (HASH_ALG_SHA1.equalsIgnoreCase(hashAlgorithmValue)) {
            CryptoUtils.logInsecureAlgorithm((String)CFG_KEY_HASH_ALGORITHM, (String)hashAlgorithmValue);
            this.signatureAlgorithm = SIGNATURE_HMAC_SHA1;
        } else {
            this.signatureAlgorithm = SIGNATURE_HMAC_SHA256;
        }
    }

    private void validateConfig() {
        if (!this.allowStateless && this.maxAssociationAttempts == 0) {
            this.maxAssociationAttempts = 4;
            Tr.warning((TraceComponent)tc, (String)"OPENID_RP_CONFIG_DISABLED_ASSOCIATION_AND_NOT_ALLOW_STATELESS_INVALID", (Object[])new Object[0]);
        }
    }

    private List<UserInfo> processUserInfo(Map<String, Object> props, String key) {
        String[] pids = (String[])props.get(key);
        if (pids == null || pids.length == 0) {
            return null;
        }
        List<String> ps = Collections.emptyList();
        ps = Arrays.asList(pids);
        return this.getUserInfoAttrs(ps);
    }

    private List<UserInfo> getUserInfoAttrs(List<String> pids) {
        ArrayList<UserInfo> uiList = new ArrayList<UserInfo>();
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminRef.getServiceWithException();
        Configuration config = null;
        for (String pid : pids) {
            try {
                Configuration[] configList = configAdmin.listConfigurations(FilterUtils.createPropertyFilter((String)"service.pid", (String)pid));
                if (configList != null && configList.length > 0) {
                    config = configAdmin.getConfiguration(pid, this.bundleLocation);
                }
            }
            catch (InvalidSyntaxException configList) {
                FFDCFilter.processException((Throwable)configList, (String)"com.ibm.ws.security.openid20.internal.OpenidClientConfigImpl", (String)"307", (Object)this, (Object[])new Object[]{pids});
            }
            catch (IOException configList) {
                FFDCFilter.processException((Throwable)configList, (String)"com.ibm.ws.security.openid20.internal.OpenidClientConfigImpl", (String)"308", (Object)this, (Object[])new Object[]{pids});
            }
            if (config == null) continue;
            Dictionary props = config.getProperties();
            String alias = (String)props.get(CFG_KEY_ALIAS);
            String type = (String)props.get(CFG_KEY_URI_TYPE);
            int count = (Integer)props.get(CFG_KEY_COUNT);
            boolean required = (Boolean)props.get(CFG_KEY_REQUIRED);
            UserInfo u = new UserInfo(alias, type, count, required);
            uiList.add(u);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (uiList.isEmpty()) {
                Tr.debug((TraceComponent)tc, (String)"there is no userInfo.", (Object[])new Object[0]);
            } else {
                for (UserInfo ui : uiList) {
                    Tr.debug((TraceComponent)tc, (String)("alias=" + ui.getAlias() + " type=" + ui.getType() + " count=" + ui.getCount() + " required=" + ui.getRequired()), (Object[])new Object[0]);
                }
            }
        }
        return uiList;
    }

    @Override
    public boolean getAllowStateless() {
        return this.allowStateless;
    }

    @Override
    public long getNonceValidTime() {
        return this.nonceValidTime;
    }

    @Override
    public int getMaxDiscoveryCacheSize() {
        return this.maxDiscoveryCacheSize;
    }

    @Override
    public int getMaxAssociationAttemps() {
        return this.maxAssociationAttempts;
    }

    @Override
    public String getSessionEncryptionType() {
        return this.sessionEncryptionType;
    }

    @Override
    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @Override
    public String getSslRef() {
        return this.sslRef;
    }

    @Override
    public List<UserInfo> getUserInfo() {
        return this.userInfo;
    }

    @Override
    public long getFailedAssocExpire() {
        return this.failedAssocExpire;
    }

    @Override
    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public long getSocketTimeout() {
        return this.socketTimeout;
    }

    @Override
    public boolean isHostNameVerificationEnabled() {
        return this.hostNameVerificationEnabled;
    }

    @Override
    public boolean ishttpsRequired() {
        return this.httpsRequired;
    }

    @Override
    public boolean isCheckImmediate() {
        return this.checkImmediate;
    }

    @Override
    public boolean isMapIdentityToRegistryUser() {
        return this.mapIdentityToRegistryUser;
    }

    @Override
    public boolean isUseClientIdentity() {
        return this.useClientIdentity;
    }

    @Override
    public int getSearchNumberOfUserInfoToMap() {
        return this.searchNumberOfUserInfoToMap;
    }

    @Override
    public int getMaxDiscoverRetry() {
        return this.maxDiscoverRetry;
    }

    @Override
    public String getGroupIdentifier() {
        return this.groupIdentifier;
    }

    @Override
    public String getRealmIdentifier() {
        return this.realmIdentifier;
    }

    @Override
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    @Override
    public boolean isIncludeUserInfoInSubject() {
        return this.includeUserInfoInSubject;
    }

    @Override
    public boolean isIncludeCustomCacheKeyInSubject() {
        return this.includeCustomCacheKeyInSubject;
    }

    @Override
    public String getProviderIdentifier() {
        return this.providerIdentifier;
    }

    @Override
    public String getAuthFilterId() {
        return this.authFilterId;
    }

    /*
     * WARNING - void declaration
     */
    private String getAuthFilterId(String authFilterRef) {
        if (authFilterRef == null || authFilterRef.isEmpty()) {
            return null;
        }
        Configuration config = null;
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminRef.getService();
        try {
            if (configAdmin != null) {
                config = configAdmin.getConfiguration(authFilterRef, this.bundleLocation);
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.openid20.internal.OpenidClientConfigImpl", (String)"520", (Object)this, (Object[])new Object[]{authFilterRef});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"Invalid authFilterRef configuration", (Object[])new Object[]{e.getMessage()});
            }
            return null;
        }
        if (config == null) {
            return null;
        }
        Dictionary props = config.getProperties();
        if (props == null) {
            return null;
        }
        String id = (String)props.get(KEY_ID);
        return id;
    }

    @Override
    public boolean allowBasicAuthentication() {
        return this.allowBasicAuthentication;
    }

    @Override
    public boolean isTryOpenIDIfBasicAuthFails() {
        return this.tryOpenIDIfBasicAuthFails;
    }
}

