/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.targets.cache.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.service.internal.AnnotationCacheServiceImpl_Logging;
import com.ibm.ws.annocache.targets.TargetsTableAnnotations;
import com.ibm.ws.annocache.targets.TargetsTableClasses;
import com.ibm.ws.annocache.targets.TargetsTableClassesMulti;
import com.ibm.ws.annocache.targets.TargetsTableContainers;
import com.ibm.ws.annocache.targets.TargetsTableDetails;
import com.ibm.ws.annocache.targets.TargetsTableTimeStamp;
import com.ibm.ws.annocache.targets.cache.TargetCache_ParseError;
import com.ibm.ws.annocache.targets.cache.TargetCache_Reader;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory;
import com.ibm.ws.annocache.util.internal.UtilImpl_InternMap;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.annocache.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.annocache.targets.cache.TargetCache_InternalConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class TargetCacheImpl_Reader
implements TargetCache_Reader,
TargetCache_InternalConstants {
    private static final String CLASS_NAME = TargetCacheImpl_Reader.class.getSimpleName();
    protected static final Logger logger = AnnotationCacheServiceImpl_Logging.ANNO_LOGGER;
    protected final TargetCacheImpl_Factory factory;
    protected final String path;
    protected final InputStream stream;
    protected final Charset charset;
    protected final InputStreamReader reader;
    protected final BufferedReader bufferedReader;
    protected int lineNo;
    protected String line;
    protected String parsedName;
    protected String parsedValue;
    protected String parsedTable;
    protected String parsedVersion;
    protected String parsedStamp;
    protected String parsedEncoding;
    protected boolean isCompletedHeader;
    protected int parsedVersionValue;
    public static final int PARSE_ERROR_LIMIT = 100;
    protected final List<TargetCache_ParseError> parseErrors;
    static final long serialVersionUID = -2581032821199327480L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetCacheImpl_Reader(TargetCacheImpl_Factory factory, String path, InputStream stream, Charset charset) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "<init>", new Object[]{factory, path, stream, charset});
        }
        this.factory = factory;
        this.path = path;
        this.stream = stream;
        this.charset = charset;
        this.reader = new InputStreamReader(stream, charset);
        this.bufferedReader = new BufferedReader(this.reader);
        this.lineNo = 0;
        this.line = null;
        this.parsedName = null;
        this.parsedValue = null;
        this.parseErrors = new ArrayList<TargetCache_ParseError>();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "<init>", this);
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetCacheImpl_Factory getFactory() {
        return this.factory;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getPath() {
        return this.path;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public InputStream getStream() {
        return this.stream;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getEncoding() {
        return this.charset.name();
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public InputStreamReader getReader() {
        return this.reader;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void close() throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "close", new Object[0]);
        }
        this.getReader().close();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "close");
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BufferedReader getBufferedReader() {
        return this.bufferedReader;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String readNextLine() throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "readNextLine", new Object[0]);
        }
        String string = this.bufferedReader.readLine();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "readNextLine", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void clearHeader() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "clearHeader", new Object[0]);
        }
        if (this.isCompletedHeader) {
            this.parsedVersionValue = 0;
            this.isCompletedHeader = false;
        }
        this.parsedTable = null;
        this.parsedVersion = null;
        this.parsedStamp = null;
        this.parsedEncoding = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "clearHeader");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setCompletedHeader() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "setCompletedHeader", new Object[0]);
        }
        boolean bl = this.isCompletedHeader = this.parsedTable != null && this.parsedVersion != null && this.parsedStamp != null && this.parsedEncoding != null;
        if (this.isCompletedHeader) {
            this.parsedVersionValue = this.parsedVersion.equals("1.0") ? 10 : (this.parsedVersion.equals("2.0") ? 20 : -1);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "setCompletedHeader");
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean isComment() {
        return this.line.startsWith("#");
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean isEndDelimiter() {
        return this.line.startsWith("# X===");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String parseLine() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "parseLine", new Object[0]);
        }
        int separatorOffset = this.line.indexOf(":");
        if (separatorOffset == -1) {
            String string = "Colon delimited value expected.";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "parseLine", string);
            }
            return string;
        }
        if (separatorOffset == 0) {
            String string = "Null initial value.";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "parseLine", string);
            }
            return string;
        }
        if (separatorOffset == this.line.length() - 1) {
            String string = "Null final value.";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "parseLine", string);
            }
            return string;
        }
        String leadingText = this.line.substring(0, separatorOffset);
        String trailingText = this.line.substring(separatorOffset + 1).trim();
        this.parsedName = leadingText;
        this.parsedValue = trailingText;
        String string = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "parseLine", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean handleHeader(String expectedTableTag, String[] acceptedTableVersions) {
        boolean isHeaderField;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "handleHeader", new Object[]{expectedTableTag, acceptedTableVersions});
        }
        if (this.parsedName.equals("Table")) {
            isHeaderField = true;
            if (!this.unexpectedHeader(expectedTableTag) && !this.dupHeader(this.parsedTable)) {
                this.parsedTable = this.parsedValue;
                this.setCompletedHeader();
            }
        } else if (this.parsedName.equals("Version")) {
            isHeaderField = true;
            if (!this.unexpectedHeader(acceptedTableVersions) && !this.dupHeader(this.parsedVersion)) {
                this.parsedVersion = this.parsedValue;
                this.setCompletedHeader();
            }
        } else if (this.parsedName.equals("Encoding")) {
            isHeaderField = true;
            if (!this.dupHeader(this.parsedEncoding)) {
                this.parsedEncoding = this.parsedValue;
                this.setCompletedHeader();
            }
        } else if (this.parsedName.equals("Written")) {
            isHeaderField = true;
            if (!this.dupHeader(this.parsedStamp)) {
                this.parsedStamp = this.parsedValue;
                this.setCompletedHeader();
            }
        } else {
            isHeaderField = false;
        }
        boolean bl = isHeaderField;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "handleHeader", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean unexpectedHeader(String allowedValue) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "unexpectedHeader", new Object[]{allowedValue});
        }
        if (!this.parsedValue.equals(allowedValue)) {
            this.addParseError("Value [ " + this.parsedValue + " ] does not match [ " + allowedValue + " ] for class [ " + this.getClass().getName() + " ]");
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "unexpectedHeader", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "unexpectedHeader", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean unexpectedHeader(String[] allowedValues) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "unexpectedHeader", new Object[]{allowedValues});
        }
        boolean matched = false;
        for (String allowedValue : allowedValues) {
            if (!this.parsedValue.equals(allowedValue)) continue;
            matched = true;
            break;
        }
        if (!matched) {
            this.addParseError("Value [ " + this.parsedValue + " ] does not match [ " + Arrays.toString(allowedValues) + " ] for class [ " + this.getClass().getName() + " ]");
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "unexpectedHeader", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "unexpectedHeader", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean dupHeader(String priorValue) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "dupHeader", new Object[]{priorValue});
        }
        if (priorValue != null) {
            this.addParseError("Header [ " + this.parsedName + " ] duplication: Old [ " + priorValue + " ] New [ " + this.parsedValue + " ]");
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "dupHeader", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "dupHeader", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<TargetCache_ParseError> parse(TargetsReader useReader) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "parse", new Object[]{useReader});
        }
        String methodName = "parse";
        String expectedTableTag = useReader.getTableTag();
        Object[] acceptedTableVersions = useReader.getTableVersions();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Expected table [ " + expectedTableTag + " ]");
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Accepted table version [ " + Arrays.toString(acceptedTableVersions) + " ]");
        }
        this.clearHeader();
        while ((this.line = this.readNextLine()) != null) {
            ++this.lineNo;
            this.line = this.line.trim();
            if (this.line.length() == 0) continue;
            if (this.isEndDelimiter()) break;
            if (this.isComment()) continue;
            String parseMessage = this.parseLine();
            if (parseMessage != null) {
                this.addParseError(parseMessage);
                continue;
            }
            if (!this.isCompletedHeader) {
                this.handleHeader(expectedTableTag, (String[])acceptedTableVersions);
                continue;
            }
            useReader.handleBody();
        }
        useReader.handleTrailer();
        List<TargetCache_ParseError> list = this.parseErrors;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "parse", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected TargetCache_ParseError addParseError(String parseMessage) {
        TargetCache_ParseError parseError;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "addParseError", new Object[]{parseMessage});
        }
        int numParseErrors = this.parseErrors.size();
        if (numParseErrors < 100) {
            parseError = new TargetCache_ParseError(TargetCache_ParseError.NULL_MSG_ID, parseMessage, this.getPath(), this.lineNo, this.line);
        } else if (numParseErrors == 100) {
            parseMessage = "Parse error limit reached [ 100 ]";
            parseError = new TargetCache_ParseError(TargetCache_ParseError.NULL_MSG_ID, parseMessage, this.getPath(), this.lineNo, this.line);
        } else {
            parseError = null;
        }
        if (parseError != null) {
            this.parseErrors.add(parseError);
        }
        TargetCache_ParseError targetCache_ParseError = parseError;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            targetCache_ParseError = targetCache_ParseError;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "addParseError", targetCache_ParseError);
        }
        return targetCache_ParseError;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<TargetCache_ParseError> read(TargetsTableContainers containerTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "read", new Object[]{containerTable});
        }
        ContainerTableReader containerReader = new ContainerTableReader(containerTable);
        List<TargetCache_ParseError> list = this.parse(containerReader);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "read", list);
        }
        return list;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<TargetCache_ParseError> read(TargetsTableTimeStamp stampTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "read", new Object[]{stampTable});
        }
        StampTableReader stampReader = new StampTableReader(stampTable);
        List<TargetCache_ParseError> list = this.parse(stampReader);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "read", list);
        }
        return list;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<TargetCache_ParseError> readResolvedRefs(UtilImpl_InternMap internMap, Set<String> i_resolvedClassNames) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "readResolvedRefs", new Object[]{internMap, i_resolvedClassNames});
        }
        RefsReader resolvedRefsReader = new RefsReader("Resolved References", "1.0", internMap, i_resolvedClassNames);
        List<TargetCache_ParseError> list = this.parse(resolvedRefsReader);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "readResolvedRefs", list);
        }
        return list;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<TargetCache_ParseError> readUnresolvedRefs(UtilImpl_InternMap internMap, Set<String> i_unresolvedClassNames) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "readUnresolvedRefs", new Object[]{internMap, i_unresolvedClassNames});
        }
        RefsReader unresolvedRefsReader = new RefsReader("Unresolved References", "1.0", internMap, i_unresolvedClassNames);
        List<TargetCache_ParseError> list = this.parse(unresolvedRefsReader);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "readUnresolvedRefs", list);
        }
        return list;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<TargetCache_ParseError> read(TargetsTableClasses classTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "read", new Object[]{classTable});
        }
        ClassTableReader classReader = new ClassTableReader(classTable);
        List<TargetCache_ParseError> list = this.parse(classReader);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "read", list);
        }
        return list;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<TargetCache_ParseError> readMulti(TargetsTableClassesMulti classTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "readMulti", new Object[]{classTable});
        }
        ClassTableMultiReader classReader = new ClassTableMultiReader(classTable);
        List<TargetCache_ParseError> list = this.parse(classReader);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "readMulti", list);
        }
        return list;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<TargetCache_ParseError> read(TargetsTableAnnotations targetTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "read", new Object[]{targetTable});
        }
        TargetTableReader targetReader = new TargetTableReader(targetTable);
        List<TargetCache_ParseError> list = this.parse(targetReader);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "read", list);
        }
        return list;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<TargetCache_ParseError> read(TargetsTableDetails detailTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "read", new Object[]{detailTable});
        }
        DetailTableReader detailReader = new DetailTableReader(detailTable);
        List<TargetCache_ParseError> list = this.parse(detailReader);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader", "read", list);
        }
        return list;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public abstract class TargetsReader {
        protected String i_packageName = null;
        protected String i_className = null;
        protected String modifiers = null;
        protected String i_fieldName = null;
        protected String i_methodSignature = null;
        protected String i_annotationClassName;
        static final long serialVersionUID = -65911470628022915L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public abstract String getTableTag();

        public abstract String getTableVersion();

        public String[] getTableVersions() {
            return new String[]{this.getTableVersion()};
        }

        protected String internPackageName(String packageName) {
            throw new UnsupportedOperationException();
        }

        protected String internClassName(String className) {
            throw new UnsupportedOperationException();
        }

        protected String internFieldName(String fieldName) {
            throw new UnsupportedOperationException();
        }

        protected String internMethodSignature(String methodSignature) {
            throw new UnsupportedOperationException();
        }

        public abstract boolean handleBody();

        public void handleTrailer() {
            this.i_annotationClassName = null;
            this.i_methodSignature = null;
            this.i_fieldName = null;
            this.modifiers = null;
            this.i_className = null;
            this.i_packageName = null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader$TargetsReader", TargetsReader.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class ContainerTableReader
    extends TargetsReader {
        protected final TargetsTableContainers containerTable;
        protected String name;
        protected String signature;
        static final long serialVersionUID = -5953217731510222884L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ContainerTableReader(TargetsTableContainers containerTable) {
            this.containerTable = containerTable;
            this.name = null;
            this.signature = null;
        }

        @Override
        public String getTableTag() {
            return "Container";
        }

        @Override
        public String getTableVersion() {
            return "2.0";
        }

        @Override
        public String[] getTableVersions() {
            return TargetCache_InternalConstants.CONTAINER_TABLE_VERSIONS;
        }

        @Override
        public boolean handleBody() {
            boolean didHandle;
            if (TargetCacheImpl_Reader.this.parsedName.equals("Name")) {
                if (this.name != null) {
                    TargetCacheImpl_Reader.this.addParseError("Tag [ " + TargetCacheImpl_Reader.this.parsedName + " ] follows unclosed [ " + "Name" + " ]: Ignoring prior name [ " + this.name + " ]");
                    this.name = null;
                    this.signature = null;
                }
                this.name = TargetCacheImpl_Reader.this.parsedValue.equals("root") ? "/" : TargetCacheImpl_Reader.this.parsedValue;
                didHandle = true;
            } else if (TargetCacheImpl_Reader.this.parsedVersionValue >= 20 && TargetCacheImpl_Reader.this.parsedName.equals("Signature")) {
                if (this.name == null) {
                    TargetCacheImpl_Reader.this.addParseError("Signature [ " + TargetCacheImpl_Reader.this.parsedValue + " ] does not follow [ " + "Name" + " ]: Ignoring");
                } else if (this.signature != null) {
                    TargetCacheImpl_Reader.this.addParseError("Signature [ " + TargetCacheImpl_Reader.this.parsedValue + " ] collision at [ " + this.name + " ]; prior value [ " + this.signature + " ]");
                } else {
                    this.signature = TargetCacheImpl_Reader.this.parsedValue;
                }
                didHandle = true;
            } else if (TargetCacheImpl_Reader.this.parsedName.equals("Policy")) {
                if (this.name == null) {
                    TargetCacheImpl_Reader.this.addParseError("Tag [ " + TargetCacheImpl_Reader.this.parsedName + " ] does not follow [ " + "Name" + " ]: Ignoring");
                } else {
                    ClassSource_Aggregate.ScanPolicy policy;
                    String useSignature;
                    String useName = this.name;
                    this.name = null;
                    if (TargetCacheImpl_Reader.this.parsedVersionValue < 20) {
                        useSignature = "** UNAVAILABLE **";
                    } else if (this.signature == null) {
                        TargetCacheImpl_Reader.this.addParseError("No signature for [ " + this.name + " ]; marking as unavailable");
                        useSignature = "** UNAVAILABLE **";
                    } else {
                        useSignature = this.signature;
                        this.signature = null;
                    }
                    try {
                        policy = ClassSource_Aggregate.ScanPolicy.valueOf(TargetCacheImpl_Reader.this.parsedValue);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader$ContainerTableReader", (String)"573", (Object)this, (Object[])new Object[0]);
                        policy = null;
                        TargetCacheImpl_Reader.this.addParseError("Value [ " + TargetCacheImpl_Reader.this.parsedValue + " ] is not a valid policy value: Ignoring");
                    }
                    if (policy != null) {
                        ClassSource_Aggregate.ScanPolicy lastPolicy = this.containerTable.removeName(this.name);
                        if (lastPolicy != null) {
                            TargetCacheImpl_Reader.this.addParseError("Policy [ " + TargetCacheImpl_Reader.this.parsedValue + " ] collision at [ " + useName + " ] with prior assignment to policy [ " + lastPolicy.name() + " ]: Replacing");
                        }
                        this.containerTable.addName(useName, useSignature, policy);
                    }
                }
                didHandle = true;
            } else {
                didHandle = false;
            }
            return didHandle;
        }

        @Override
        public void handleTrailer() {
            if (this.name != null) {
                TargetCacheImpl_Reader.this.addParseError("Missing [ Policy ] for last [ Name ]");
            }
            super.handleTrailer();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader$ContainerTableReader", ContainerTableReader.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class StampTableReader
    extends TargetsReader {
        protected final TargetsTableTimeStamp stampTable;
        private String name;
        private String stamp;
        static final long serialVersionUID = 3425579178279891847L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public StampTableReader(TargetsTableTimeStamp stampTable) {
            this.stampTable = stampTable;
            this.name = null;
            this.stamp = null;
        }

        @Override
        public String getTableTag() {
            return "Stamp";
        }

        @Override
        public String getTableVersion() {
            return "1.0";
        }

        @Override
        public boolean handleBody() {
            boolean didHandle;
            if (TargetCacheImpl_Reader.this.parsedName.equals("Name")) {
                if (this.name != null) {
                    TargetCacheImpl_Reader.this.addParseError("Multiple [ Name ]: Replacing [ " + this.name + " ] with [ " + TargetCacheImpl_Reader.this.parsedValue + " ]");
                }
                this.stampTable.setName(TargetCacheImpl_Reader.this.parsedValue);
                didHandle = true;
            } else if (TargetCacheImpl_Reader.this.parsedName.equals("Stamp")) {
                if (this.stamp != null) {
                    TargetCacheImpl_Reader.this.addParseError("Multiple [ Stamp ]: Replacing [ " + this.stamp + " ] with [ " + TargetCacheImpl_Reader.this.parsedValue + " ]");
                }
                this.stampTable.setStamp(TargetCacheImpl_Reader.this.parsedValue);
                didHandle = true;
            } else {
                didHandle = false;
            }
            return didHandle;
        }

        @Override
        public void handleTrailer() {
            if (this.stampTable.getName() == null) {
                TargetCacheImpl_Reader.this.addParseError("No [ Name ] element was read.");
            }
            if (this.stampTable.getStamp() == null) {
                TargetCacheImpl_Reader.this.addParseError("No [ Stamp ] element was read.");
            }
            super.handleTrailer();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader$StampTableReader", StampTableReader.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class RefsReader
    extends TargetsReader {
        protected final UtilImpl_InternMap internMap;
        protected final Set<String> refs;
        protected final String tableTag;
        protected final String tableVersion;
        static final long serialVersionUID = 4608266649023256352L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public RefsReader(String tableTag, String tableVersion, UtilImpl_InternMap internMap, Set<String> refs) {
            this.tableTag = tableTag;
            this.tableVersion = tableVersion;
            this.internMap = internMap;
            this.refs = refs;
        }

        public String intern(String className) {
            return this.internMap.intern(className);
        }

        protected void addRef(String className) {
            this.refs.add(this.intern(className));
        }

        @Override
        public String getTableTag() {
            return this.tableTag;
        }

        @Override
        public String getTableVersion() {
            return this.tableVersion;
        }

        @Override
        public boolean handleBody() {
            if (TargetCacheImpl_Reader.this.parsedName.equals("Class")) {
                this.addRef(TargetCacheImpl_Reader.this.parsedValue);
                return true;
            }
            return false;
        }

        @Override
        public void handleTrailer() {
            super.handleTrailer();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader$RefsReader", RefsReader.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class ClassTableReader
    extends TargetsReader {
        protected final TargetsTableClasses classTable;
        protected String i_superclassName;
        protected List<String> i_interfaceNames;
        static final long serialVersionUID = 5928968726892023543L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ClassTableReader(TargetsTableClasses classTable) {
            this.classTable = classTable;
            this.i_superclassName = null;
            this.i_interfaceNames = new ArrayList<String>();
        }

        @Override
        @Trivial
        protected String internPackageName(String packageName) {
            return this.classTable.internClassName(packageName);
        }

        @Override
        @Trivial
        protected String internClassName(String className) {
            return this.classTable.internClassName(className);
        }

        @Override
        @Trivial
        protected String internFieldName(String fieldName) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Trivial
        protected String internMethodSignature(String methodSignature) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTableTag() {
            return "Classes";
        }

        @Override
        public String getTableVersion() {
            return "1.0";
        }

        protected void consumePackageOrClass() {
            if (this.i_packageName != null) {
                this.classTable.record(this.i_packageName);
                this.i_packageName = null;
            } else if (this.i_className != null) {
                int modifiersValue = this.modifiers == null ? 0 : Integer.parseInt(this.modifiers, 16);
                this.classTable.record(this.i_className, this.i_superclassName, this.i_interfaceNames, modifiersValue);
                this.i_className = null;
                this.i_superclassName = null;
                this.i_interfaceNames.clear();
                this.modifiers = null;
            }
        }

        @Override
        public boolean handleBody() {
            boolean didHandle;
            if (TargetCacheImpl_Reader.this.parsedName.equals("Package")) {
                this.consumePackageOrClass();
                this.i_packageName = this.internPackageName(TargetCacheImpl_Reader.this.parsedValue);
                didHandle = true;
            } else if (TargetCacheImpl_Reader.this.parsedName.equals("Class")) {
                this.consumePackageOrClass();
                this.i_className = this.internClassName(TargetCacheImpl_Reader.this.parsedValue);
                didHandle = true;
            } else if (TargetCacheImpl_Reader.this.parsedName.equals("Superclass")) {
                if (this.i_className == null) {
                    TargetCacheImpl_Reader.this.addParseError("Tag [ " + TargetCacheImpl_Reader.this.parsedName + " ] must follow [ " + "Class" + " ]");
                } else {
                    this.i_superclassName = this.internClassName(TargetCacheImpl_Reader.this.parsedValue);
                }
                didHandle = true;
            } else if (TargetCacheImpl_Reader.this.parsedName.equals("Interface")) {
                if (this.i_className == null) {
                    TargetCacheImpl_Reader.this.addParseError("Tag [ " + TargetCacheImpl_Reader.this.parsedName + " ] must follow [ " + "Class" + " ]");
                } else {
                    String i_interfaceName = this.internClassName(TargetCacheImpl_Reader.this.parsedValue);
                    this.i_interfaceNames.add(i_interfaceName);
                }
                didHandle = true;
            } else if (TargetCacheImpl_Reader.this.parsedName.equals("Modifiers")) {
                if (this.i_className == null) {
                    TargetCacheImpl_Reader.this.addParseError("Tag [ " + TargetCacheImpl_Reader.this.parsedName + " ] must follow [ " + "Class" + " ]");
                } else {
                    int startOffset = 2;
                    int endOffset = TargetCacheImpl_Reader.this.parsedValue.indexOf(" ");
                    this.modifiers = TargetCacheImpl_Reader.this.parsedValue.substring(startOffset, endOffset);
                }
                didHandle = true;
            } else {
                didHandle = false;
            }
            return didHandle;
        }

        @Override
        public void handleTrailer() {
            this.consumePackageOrClass();
            super.handleTrailer();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader$ClassTableReader", ClassTableReader.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class ClassTableMultiReader
    extends TargetsReader {
        protected final TargetsTableClassesMulti classTable;
        protected String classSourceName;
        protected String i_superclassName;
        protected List<String> i_interfaceNames;
        static final long serialVersionUID = 7211368840986706753L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ClassTableMultiReader(TargetsTableClassesMulti classTable) {
            this.classTable = classTable;
            this.classSourceName = null;
            this.i_superclassName = null;
            this.i_interfaceNames = new ArrayList<String>();
        }

        @Override
        @Trivial
        protected String internPackageName(String packageName) {
            return this.classTable.internClassName(packageName);
        }

        @Override
        @Trivial
        protected String internClassName(String className) {
            return this.classTable.internClassName(className);
        }

        @Override
        @Trivial
        protected String internFieldName(String fieldName) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Trivial
        protected String internMethodSignature(String methodSignature) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTableTag() {
            return "Classes";
        }

        @Override
        public String getTableVersion() {
            return "1.0";
        }

        protected void consumePackageOrClass() {
            if (this.classSourceName != null) {
                if (this.i_packageName != null) {
                    this.classTable.record(this.classSourceName, this.i_packageName);
                    this.i_packageName = null;
                } else {
                    int modifiersValue = this.modifiers == null ? 0 : Integer.parseInt(this.modifiers, 16);
                    this.classTable.record(this.classSourceName, this.i_className, this.i_superclassName, this.i_interfaceNames, modifiersValue);
                }
            }
            this.classSourceName = null;
            this.i_className = null;
            this.i_superclassName = null;
            this.i_interfaceNames.clear();
            this.modifiers = null;
        }

        @Override
        public boolean handleBody() {
            boolean didHandle;
            if (TargetCacheImpl_Reader.this.parsedName.equals("Package")) {
                this.consumePackageOrClass();
                this.i_packageName = this.internPackageName(TargetCacheImpl_Reader.this.parsedValue);
                didHandle = true;
            } else if (TargetCacheImpl_Reader.this.parsedName.equals("Class")) {
                this.consumePackageOrClass();
                this.i_className = this.internClassName(TargetCacheImpl_Reader.this.parsedValue);
                didHandle = true;
            } else if (TargetCacheImpl_Reader.this.parsedName.equals("Class Source")) {
                if (this.i_className == null && this.i_packageName == null) {
                    TargetCacheImpl_Reader.this.addParseError("Tag [ " + TargetCacheImpl_Reader.this.parsedName + " ] must follow [ " + "Package" + " ] or [ " + "Class" + " ]");
                } else {
                    this.classSourceName = TargetCacheImpl_Reader.this.parsedValue;
                }
                didHandle = true;
            } else if (TargetCacheImpl_Reader.this.parsedName.equals("Superclass")) {
                if (this.i_className == null) {
                    TargetCacheImpl_Reader.this.addParseError("Tag [ " + TargetCacheImpl_Reader.this.parsedName + " ] must follow [ " + "Class" + " ]");
                } else {
                    this.i_superclassName = this.internClassName(TargetCacheImpl_Reader.this.parsedValue);
                }
                didHandle = true;
            } else if (TargetCacheImpl_Reader.this.parsedName.equals("Interface")) {
                if (this.i_className == null) {
                    TargetCacheImpl_Reader.this.addParseError("Tag [ " + TargetCacheImpl_Reader.this.parsedName + " ] must follow [ " + "Class" + " ]");
                } else {
                    String i_interfaceName = this.internClassName(TargetCacheImpl_Reader.this.parsedValue);
                    this.i_interfaceNames.add(i_interfaceName);
                }
                didHandle = true;
            } else if (TargetCacheImpl_Reader.this.parsedName.equals("Modifiers")) {
                if (this.i_className == null) {
                    TargetCacheImpl_Reader.this.addParseError("Tag [ " + TargetCacheImpl_Reader.this.parsedName + " ] must follow [ " + "Class" + " ]");
                } else {
                    int startOffset = 2;
                    int endOffset = TargetCacheImpl_Reader.this.parsedValue.indexOf(" ");
                    this.modifiers = TargetCacheImpl_Reader.this.parsedValue.substring(startOffset, endOffset);
                }
                didHandle = true;
            } else {
                didHandle = false;
            }
            return didHandle;
        }

        @Override
        public void handleTrailer() {
            this.consumePackageOrClass();
            super.handleTrailer();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader$ClassTableMultiReader", ClassTableMultiReader.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class TargetTableReader
    extends TargetsReader {
        protected final TargetsTableAnnotations targetTable;
        static final long serialVersionUID = 8859556383663038075L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public TargetTableReader(TargetsTableAnnotations targetTable) {
            this.targetTable = targetTable;
        }

        @Override
        @Trivial
        protected String internPackageName(String packageName) {
            return this.targetTable.internClassName(packageName);
        }

        @Override
        @Trivial
        protected String internClassName(String className) {
            return this.targetTable.internClassName(className);
        }

        @Override
        @Trivial
        protected String internFieldName(String fieldName) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Trivial
        protected String internMethodSignature(String methodSignature) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTableTag() {
            return "Annotation Targets";
        }

        @Override
        public String getTableVersion() {
            return "1.0";
        }

        @Override
        public boolean handleBody() {
            boolean didHandle;
            if (TargetCacheImpl_Reader.this.parsedName.equals("Package")) {
                this.i_packageName = null;
                this.i_className = null;
                this.i_packageName = this.internPackageName(TargetCacheImpl_Reader.this.parsedValue);
                didHandle = true;
            } else if (TargetCacheImpl_Reader.this.parsedName.equals("Class")) {
                this.i_packageName = null;
                this.i_className = null;
                this.i_className = this.internClassName(TargetCacheImpl_Reader.this.parsedValue);
                didHandle = true;
            } else if (TargetCacheImpl_Reader.this.parsedName.equals("Package Annotation")) {
                if (this.i_packageName == null) {
                    TargetCacheImpl_Reader.this.addParseError("Tag [ " + TargetCacheImpl_Reader.this.parsedName + " ] with no proceeding [ " + "Package" + " ]: Ignoring");
                } else {
                    String i_parsedAnnotationClassName = this.internClassName(TargetCacheImpl_Reader.this.parsedValue);
                    this.targetTable.recordPackageAnnotation(this.i_packageName, i_parsedAnnotationClassName);
                }
                didHandle = true;
            } else if (TargetCacheImpl_Reader.this.parsedName.equals("Class Annotation")) {
                if (this.i_className == null) {
                    TargetCacheImpl_Reader.this.addParseError("Tag [ " + TargetCacheImpl_Reader.this.parsedName + " ] with no proceeding of [ " + "Class" + " ]: Ignoring");
                } else {
                    String i_parsedAnnotationClassName = this.internClassName(TargetCacheImpl_Reader.this.parsedValue);
                    this.targetTable.recordClassAnnotation(this.i_className, i_parsedAnnotationClassName);
                }
                didHandle = true;
            } else if (TargetCacheImpl_Reader.this.parsedName.equals("Field Annotation")) {
                if (this.i_className == null) {
                    TargetCacheImpl_Reader.this.addParseError("Tag [ " + TargetCacheImpl_Reader.this.parsedName + " ] with no proceeding [ " + "Class" + " ]: Ignoring");
                } else {
                    String i_parsedAnnotationClassName = this.internClassName(TargetCacheImpl_Reader.this.parsedValue);
                    this.targetTable.recordFieldAnnotation(this.i_className, i_parsedAnnotationClassName);
                }
                didHandle = true;
            } else if (TargetCacheImpl_Reader.this.parsedName.equals("Method Annotation")) {
                if (this.i_className == null) {
                    TargetCacheImpl_Reader.this.addParseError("Tag [ " + TargetCacheImpl_Reader.this.parsedName + " ] with no proceeding [ " + "Class" + " ]: Ignoring");
                } else {
                    String i_parsedAnnotationClassName = this.internClassName(TargetCacheImpl_Reader.this.parsedValue);
                    this.targetTable.recordMethodAnnotation(this.i_className, i_parsedAnnotationClassName);
                }
                didHandle = true;
            } else {
                didHandle = false;
            }
            return didHandle;
        }

        @Override
        public void handleTrailer() {
            super.handleTrailer();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader$TargetTableReader", TargetTableReader.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class DetailTableReader
    extends TargetsReader {
        protected final TargetsTableDetails detailTable;
        static final long serialVersionUID = 22592918387083123L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public DetailTableReader(TargetsTableDetails detailTable) {
            this.detailTable = detailTable;
        }

        @Override
        @Trivial
        protected String internPackageName(String packageName) {
            return this.detailTable.getParentData().internClassName(packageName);
        }

        @Override
        @Trivial
        protected String internClassName(String className) {
            return this.detailTable.getParentData().internClassName(className);
        }

        @Override
        @Trivial
        protected String internFieldName(String fieldName) {
            return this.detailTable.getParentData().internFieldName(fieldName);
        }

        @Override
        @Trivial
        protected String internMethodSignature(String methodSignature) {
            return this.detailTable.getParentData().internMethodSignature(methodSignature);
        }

        @Override
        public String getTableTag() {
            return "Annotation Details";
        }

        @Override
        public String getTableVersion() {
            return "1.0";
        }

        @Override
        public boolean handleBody() {
            boolean didHandle;
            if (TargetCacheImpl_Reader.this.parsedName.equals("Package")) {
                this.i_packageName = null;
                this.i_className = null;
                this.i_packageName = this.internPackageName(TargetCacheImpl_Reader.this.parsedValue);
                didHandle = true;
            } else if (TargetCacheImpl_Reader.this.parsedName.equals("Class")) {
                this.i_packageName = null;
                this.i_className = null;
                this.i_className = this.internClassName(TargetCacheImpl_Reader.this.parsedValue);
                didHandle = true;
            } else if (TargetCacheImpl_Reader.this.parsedName.equals("Field")) {
                if (this.i_className == null) {
                    TargetCacheImpl_Reader.this.addParseError("Tag [ " + TargetCacheImpl_Reader.this.parsedName + " ] with no proceeding [ " + "Class" + " ]: Ignoring");
                } else {
                    this.i_fieldName = this.internFieldName(TargetCacheImpl_Reader.this.parsedValue);
                }
                didHandle = true;
            } else if (TargetCacheImpl_Reader.this.parsedName.equals("Method")) {
                if (this.i_className == null) {
                    TargetCacheImpl_Reader.this.addParseError("Tag [ " + TargetCacheImpl_Reader.this.parsedName + " ] with no proceeding [ " + "Class" + " ]: Ignoring");
                } else {
                    this.i_methodSignature = this.internMethodSignature(TargetCacheImpl_Reader.this.parsedValue);
                }
                didHandle = true;
            } else if (TargetCacheImpl_Reader.this.parsedName.equals("Annotation")) {
                if (this.i_annotationClassName != null) {
                    TargetCacheImpl_Reader.this.addParseError("Tag [ " + TargetCacheImpl_Reader.this.parsedName + " ] following unclosed [ " + "Annotation" + " ]: Ignoring");
                } else if (this.i_packageName == null && this.i_className == null) {
                    TargetCacheImpl_Reader.this.addParseError("Tag [ " + TargetCacheImpl_Reader.this.parsedName + " ] with no proceeding [ " + "Package" + " ] or [ " + "Class" + " ]: Ignoring");
                } else {
                    this.i_annotationClassName = this.internClassName(TargetCacheImpl_Reader.this.parsedValue);
                }
                didHandle = true;
            } else if (TargetCacheImpl_Reader.this.parsedName.equals("Detail")) {
                String annotationDetail = TargetCacheImpl_Reader.this.parsedValue;
                if (this.i_annotationClassName == null) {
                    TargetCacheImpl_Reader.this.addParseError("Tag [ " + TargetCacheImpl_Reader.this.parsedName + " ] with no proceeding [ " + "Annotation" + " ]: Ignoring");
                }
                String i_useAnnotationClassName = this.i_annotationClassName;
                this.i_annotationClassName = null;
                if (this.i_packageName != null) {
                    this.detailTable.i_putPackageAnnotation(this.i_packageName, i_useAnnotationClassName, annotationDetail);
                } else if (this.i_methodSignature != null) {
                    this.detailTable.i_putMethodAnnotation(this.i_className, this.i_methodSignature, i_useAnnotationClassName, annotationDetail);
                } else if (this.i_fieldName != null) {
                    this.detailTable.i_putFieldAnnotation(this.i_className, this.i_fieldName, i_useAnnotationClassName, annotationDetail);
                } else if (this.i_className != null) {
                    this.detailTable.i_putClassAnnotation(this.i_className, i_useAnnotationClassName, annotationDetail);
                } else {
                    throw new IllegalStateException("Annotation [ " + i_useAnnotationClassName + " ] set with no target value.");
                }
                didHandle = true;
            } else {
                didHandle = false;
            }
            return didHandle;
        }

        @Override
        public void handleTrailer() {
            if (this.i_annotationClassName != null) {
                TargetCacheImpl_Reader.this.addParseError("Tag [ Annotation ] not completed by [ Detail ]");
            }
            super.handleTrailer();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader$DetailTableReader", DetailTableReader.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        }
    }
}

