/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.util.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.annocache.util.Util_BidirectionalMap;
import com.ibm.wsspi.annocache.util.Util_Factory;
import com.ibm.wsspi.annocache.util.Util_InternMap;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class UtilImpl_BidirectionalMap
implements Util_BidirectionalMap {
    private static final Logger logger = Logger.getLogger("com.ibm.ws.annocache.util");
    private static final Logger stateLogger = Logger.getLogger("com.ibm.ws.annocache.util.state");
    public static final String CLASS_NAME = "UtilImpl_BidirectionalMap";
    protected final Util_Factory factory;
    protected final String holderTag;
    protected final String heldTag;
    protected final Util_InternMap holderInternMap;
    protected Util_InternMap heldInternMap;
    protected Map<String, Set<String>> i_holderToHeldMap;
    protected Map<String, Set<String>> i_heldToHoldersMap;
    static final long serialVersionUID = 1901377398262084118L;

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getHashText() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + "(" + this.holderTag + " : " + this.heldTag + ")";
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected UtilImpl_BidirectionalMap(Util_Factory factory, String holderTag, String heldTag, Util_InternMap holderInternMap, Util_InternMap heldInternMap) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "<init>", new Object[]{factory, holderTag, heldTag, holderInternMap, heldInternMap});
        }
        String methodName = "<init>";
        this.factory = factory;
        this.holderTag = holderTag;
        this.heldTag = heldTag;
        this.holderInternMap = holderInternMap;
        this.heldInternMap = heldInternMap;
        this.i_holderToHeldMap = new IdentityHashMap<String, Set<String>>();
        this.i_heldToHoldersMap = new IdentityHashMap<String, Set<String>>();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ]", this.getHashText());
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "<init>", this);
        }
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Util_Factory getFactory() {
        return this.factory;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean getIsEnabled() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "getIsEnabled", new Object[0]);
        }
        boolean bl = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "getIsEnabled", bl);
        }
        return bl;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getHolderTag() {
        return this.holderTag;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getHeldTag() {
        return this.heldTag;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Util_InternMap getHolderInternMap() {
        return this.holderInternMap;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean containsHolder(String holderName) {
        String methodName = "containsHolder";
        boolean result = this.holderInternMap.contains(holderName);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Contains holder [ {1} ] [ {2} ]", new Object[]{this.getHashText(), holderName, result});
        }
        return result;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String internHolder(String name, boolean doForce) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "internHolder", new Object[]{name, doForce});
        }
        String string = this.holderInternMap.intern(name, doForce);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "internHolder", string);
        }
        return string;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Util_InternMap getHeldInternMap() {
        return this.heldInternMap;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean containsHeld(String heldName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "containsHeld", new Object[]{heldName});
        }
        String methodName = "containsHeld";
        boolean result = this.heldInternMap.contains(heldName);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Contains held [ {1} ] [ {2} ]", new Object[]{this.getHashText(), heldName, result});
        }
        boolean bl = result;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "containsHeld", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String internHeld(String name, boolean doForce) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "internHeld", new Object[]{name, doForce});
        }
        String string = this.heldInternMap.intern(name, doForce);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "internHeld", string);
        }
        return string;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getHolderSet() {
        return this.i_holderToHeldMap.keySet();
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getHeldSet() {
        return this.i_heldToHoldersMap.keySet();
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isEmpty() {
        String methodName = "isEmpty";
        boolean result = this.i_heldToHoldersMap.isEmpty();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER / RETURN [ {1} ]", new Object[]{this.getHashText(), result});
        }
        return result;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean holds(String holderName, String heldName) {
        boolean result;
        String methodName = "holds";
        String i_holderName = this.internHolder(holderName, false);
        if (i_holderName == null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER [ {1} ] [ {2} ] / RETURN [ false ] (holder not stored)", new Object[]{this.getHashText(), holderName, heldName});
            }
            return false;
        }
        String i_heldName = this.internHeld(heldName, false);
        if (i_heldName == null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER [ {1} ] [ {2} ] / RETURN [ false ] (held not stored)", new Object[]{this.getHashText(), holderName, heldName});
            }
            return false;
        }
        Set<String> i_held = this.i_holderToHeldMap.get(i_holderName);
        boolean bl = result = i_held == null ? false : i_held.contains(i_heldName);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER [ {1} ] [ {2} ] / RETURN [ {3} ]", new Object[]{this.getHashText(), holderName, heldName, result});
        }
        return result;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> selectHeldOf(String holderName) {
        String methodName = "selectHeldOf";
        String i_holderName = this.internHolder(holderName, false);
        if (i_holderName == null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER [ {1} ] / RETURN [ 0 ] (holder not stored)", new Object[]{this.getHashText(), holderName});
            }
            return Collections.emptySet();
        }
        Set<String> i_held = this.i_selectHeldOf(i_holderName);
        if (i_held == null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER [ {1} ] / RETURN [ 0 ] (null held)", new Object[]{this.getHashText(), holderName});
            }
            return Collections.emptySet();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER [ {1} ] / RETURN [ {2} ]", new Object[]{this.getHashText(), holderName, i_held.size()});
        }
        return i_held;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_selectHeldOf(String i_holderName) {
        String methodName = "i_selectHeldOf";
        Set<String> result = this.i_holderToHeldMap.get(i_holderName);
        if (logger.isLoggable(Level.FINER)) {
            String resultString = result == null ? "null" : Integer.toString(result.size());
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER [ {1} ] / RETURN [ {2} ]", new Object[]{this.getHashText(), i_holderName, resultString});
        }
        return result;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> selectHoldersOf(String heldName) {
        String methodName = "selectHoldersOf";
        String i_heldName = this.internHeld(heldName, false);
        if (i_heldName == null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER [ {1} ] / RETURN [ 0 ] (held not stored)", new Object[]{this.getHashText(), heldName});
            }
            return Collections.emptySet();
        }
        Set<String> i_holders = this.i_selectHoldersOf(i_heldName);
        if (i_holders == null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER [ {1} ] / RETURN [ 0 ] (null holders)", new Object[]{this.getHashText(), heldName});
            }
            return Collections.emptySet();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER [ {1} ] / RETURN [ {2} ]", new Object[]{this.getHashText(), heldName, i_holders.size()});
        }
        return i_holders;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_selectHoldersOf(String i_heldName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "i_selectHoldersOf", new Object[]{i_heldName});
        }
        String methodName = "i_selectHoldersOf";
        Set<String> result = this.i_heldToHoldersMap.get(i_heldName);
        if (logger.isLoggable(Level.FINER)) {
            String resultString = result == null ? "null" : Integer.toString(result.size());
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER [ {1} ] / RETURN [ {2} ]", new Object[]{this.getHashText(), i_heldName, resultString});
        }
        Set<String> set = result;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "i_selectHoldersOf", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean record(String holderName, String heldName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "record", new Object[]{holderName, heldName});
        }
        boolean bl = this.i_record(this.internHolder(holderName, true), this.internHeld(heldName, true));
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "record", bl);
        }
        return bl;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean i_record(String i_holderName, String i_heldName) {
        String methodName = "i_record";
        boolean addedHeldToHolder = this.i_recordHolderToHeld(i_holderName, i_heldName);
        boolean addedHolderToHeld = this.i_recordHeldToHolder(i_holderName, i_heldName);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Holder [ {1} ] Held [ {2} ] [ {3} ]", new Object[]{this.getHashText(), i_holderName, i_heldName, addedHeldToHolder});
        }
        if (addedHeldToHolder != addedHolderToHeld) {
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "[ {0} ] Holder [ {1} ] Held [ {2} ] Added to holder [ {3} ] Added to held [ {4} ]", new Object[]{this.getHashText(), i_holderName, i_heldName, addedHeldToHolder, addedHolderToHeld});
        }
        return addedHeldToHolder;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean i_recordHolderToHeld(String i_holderName, String i_heldName) {
        String methodName = "i_recordHolderToHeld";
        Set<String> i_held = this.i_recordHolder(i_holderName);
        boolean didAdd = i_held.add(i_heldName);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Holder [ {1} ] Held [ {2} ] [ {3} ]", new Object[]{this.getHashText(), i_holderName, i_heldName, didAdd});
        }
        return didAdd;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Set<String> i_recordHolder(String i_holderName) {
        String methodName = "i_recordHolder";
        Set<String> i_held = this.i_holderToHeldMap.get(i_holderName);
        if (i_held == null) {
            i_held = this.factory.createIdentityStringSet();
            this.i_holderToHeldMap.put(i_holderName, i_held);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Holder [ {1} ] Added", new Object[]{this.getHashText(), i_holderName});
            }
        } else if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Holder [ {1} ] Already present", new Object[]{this.getHashText(), i_holderName});
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Holder [ {1} ] Held [ {2} ]", new Object[]{this.getHashText(), i_held.size()});
        }
        return i_held;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean i_recordHeldToHolder(String i_holderName, String i_heldName) {
        String methodName = "i_recordHeldToHolder";
        Set<String> i_holders = this.i_recordHeld(i_heldName);
        boolean didAdd = i_holders.add(i_holderName);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Holder [ {1} ] Held [ {2} ] [ {3} ]", new Object[]{this.getHashText(), i_holderName, i_heldName, didAdd});
        }
        return didAdd;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Set<String> i_recordHeld(String i_heldName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "i_recordHeld", new Object[]{i_heldName});
        }
        String methodName = "i_recordHeld";
        Set<String> i_holders = this.i_heldToHoldersMap.get(i_heldName);
        if (i_holders == null) {
            i_holders = this.factory.createIdentityStringSet();
            this.i_heldToHoldersMap.put(i_heldName, i_holders);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Held [ {1} ] Added", new Object[]{this.getHashText(), i_heldName});
            }
        } else if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Held [ {1} ] Already present", new Object[]{this.getHashText(), i_heldName});
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Holder [ {1} ] Holders [ {2} ]", new Object[]{this.getHashText(), i_holders.size()});
        }
        Set<String> set = i_holders;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "i_recordHeld", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void i_record(UtilImpl_BidirectionalMap otherMap) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "i_record", new Object[]{otherMap});
        }
        for (String i_nextHolder : this.getHolderSet()) {
            Set<String> i_held = this.i_selectHeldOf(i_nextHolder);
            if (i_held == null) continue;
            for (String i_nextHeld : i_held) {
                this.i_record(i_nextHolder, i_nextHeld);
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "i_record");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void i_record(UtilImpl_BidirectionalMap otherMap, Set<String> i_restrictedHolders) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "i_record", new Object[]{otherMap, i_restrictedHolders});
        }
        for (String i_otherHolder : otherMap.getHolderSet()) {
            Set<String> i_otherHeld;
            if (!i_restrictedHolders.contains(i_otherHolder) || (i_otherHeld = otherMap.i_selectHeldOf(i_otherHolder)) == null) continue;
            for (String i_otherHeldName : i_otherHeld) {
                this.i_record(i_otherHolder, i_otherHeldName);
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "i_record");
        }
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void logState() {
        if (!stateLogger.isLoggable(Level.FINER)) {
            return;
        }
        this.log(logger);
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void log(Logger useLogger) {
        if (useLogger.isLoggable(Level.FINER)) {
            String methodName = "log";
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "BiDi Map: BEGIN: [ {0} ]", this.getHashText());
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Holder Intern Map:");
            this.getHolderInternMap().log(useLogger);
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Held Intern Map:");
            this.getHeldInternMap().log(useLogger);
            this.logHolderMap(useLogger);
            this.logHeldMap(useLogger);
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "BiDi Map: END: [ {0} ]", this.getHashText());
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void logHolderMap(Logger useLogger) {
        String methodName = "logHolderMap";
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Holder-to-held Map: BEGIN");
        for (Map.Entry<String, Set<String>> i_holderEntry : this.i_holderToHeldMap.entrySet()) {
            String i_holderName = i_holderEntry.getKey();
            Set<String> i_held = i_holderEntry.getValue();
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Holder [ {0} ] Held [ {1} ]", new Object[]{i_holderName, i_held});
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Holder-to-held Map: END");
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void logHeldMap(Logger useLogger) {
        String methodName = "logHeldMap";
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Held-to-holder Map: BEGIN");
        for (Map.Entry<String, Set<String>> i_heldEntry : this.i_heldToHoldersMap.entrySet()) {
            String i_heldName = i_heldEntry.getKey();
            Set<String> i_holders = i_heldEntry.getValue();
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Held [ {0} ] Holders [ {1} ]", new Object[]{i_heldName, i_holders});
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Held-to-holder Map: END");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean i_equals(UtilImpl_BidirectionalMap otherMap, boolean isCongruent) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "i_equals", new Object[]{otherMap, isCongruent});
        }
        if (otherMap == null) {
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "i_equals", bl);
            }
            return bl;
        }
        if (otherMap == this) {
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "i_equals", bl);
            }
            return bl;
        }
        if (this.i_holderToHeldMap.keySet().size() != otherMap.i_holderToHeldMap.keySet().size()) {
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "i_equals", bl);
            }
            return bl;
        }
        for (Map.Entry<String, Set<String>> i_holderEntry : this.i_holderToHeldMap.entrySet()) {
            String i_holderName = i_holderEntry.getKey();
            Set<String> i_held = i_holderEntry.getValue();
            if (isCongruent) {
                Set<String> i_otherHeld = otherMap.i_holderToHeldMap.get(i_holderName);
                if (i_otherHeld == null) {
                    boolean bl = false;
                    if (logger != null && logger.isLoggable(Level.FINER)) {
                        bl = bl;
                        logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "i_equals", bl);
                    }
                    return bl;
                }
                if (i_held.size() != i_otherHeld.size()) {
                    boolean bl = false;
                    if (logger != null && logger.isLoggable(Level.FINER)) {
                        bl = bl;
                        logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "i_equals", bl);
                    }
                    return bl;
                }
                if (i_held.containsAll(i_otherHeld)) continue;
                boolean bl = false;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    bl = bl;
                    logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "i_equals", bl);
                }
                return bl;
            }
            String i_otherHolderName = otherMap.internHolder(i_holderName, false);
            if (i_otherHolderName == null) {
                boolean bl = false;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    bl = bl;
                    logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "i_equals", bl);
                }
                return bl;
            }
            Set<String> i_otherHeld = otherMap.selectHeldOf(i_otherHolderName);
            if (i_otherHeld == null) {
                boolean bl = false;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    bl = bl;
                    logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "i_equals", bl);
                }
                return bl;
            }
            if (i_held.size() != i_otherHeld.size()) {
                boolean bl = false;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    bl = bl;
                    logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "i_equals", bl);
                }
                return bl;
            }
            for (String i_heldName : i_held) {
                String i_otherHeldName = otherMap.internHeld(i_heldName, false);
                if (i_otherHeldName == null) {
                    boolean bl = false;
                    if (logger != null && logger.isLoggable(Level.FINER)) {
                        bl = bl;
                        logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "i_equals", bl);
                    }
                    return bl;
                }
                if (i_otherHeld.contains(i_otherHeldName)) continue;
                boolean bl = false;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    bl = bl;
                    logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "i_equals", bl);
                }
                return bl;
            }
        }
        boolean bl = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap", "i_equals", bl);
        }
        return bl;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void update(Set<String> i_allResolved, Set<String> i_newlyResolved, Set<String> i_allUnresolved, Set<String> i_newlyUnresolved) {
        Object[] logParms;
        String methodName = "update";
        if (logger.isLoggable(Level.FINER)) {
            logParms = new Object[]{this.getHashText(), null};
            logParms[1] = Integer.toString(i_allResolved.size());
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] All resolved [ {1} ]", logParms);
            logParms[1] = Integer.toString(i_newlyResolved.size());
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] New resolved [ {1} ]", logParms);
            logParms[1] = Integer.toString(i_allUnresolved.size());
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Initial all unresolved [ {1} ]", logParms);
            logParms[1] = Integer.toString(i_newlyUnresolved.size());
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Initial new unresolved [ {1} ]", logParms);
        } else {
            logParms = null;
        }
        for (Set<String> i_held : this.i_holderToHeldMap.values()) {
            for (String i_heldName : i_held) {
                if (i_allResolved.contains(i_heldName) || !i_allUnresolved.add(i_heldName)) continue;
                if (logParms != null) {
                    logParms[1] = i_heldName;
                    logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] New unresolved [ {1} ]", logParms);
                }
                i_newlyUnresolved.add(i_heldName);
            }
        }
        if (logParms != null) {
            logParms[1] = Integer.toString(i_allUnresolved.size());
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Final all unresolved [ {1} ]", logParms);
            logParms[1] = Integer.toString(i_newlyUnresolved.size());
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Final new unresolved [ {1} ]", logParms);
        }
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void log(TraceComponent useLogger) {
        if (useLogger.isDebugEnabled()) {
            Tr.debug((TraceComponent)useLogger, (String)MessageFormat.format("BEGIN Intern Map [ {0} ]:", this.getHashText()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)useLogger, (String)MessageFormat.format("BiDi Map: BEGIN: [ {0} ]", this.getHashText()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)useLogger, (String)"Holder Intern Map:", (Object[])new Object[0]);
            this.getHolderInternMap().log(useLogger);
            Tr.debug((TraceComponent)useLogger, (String)"Held Intern Map:", (Object[])new Object[0]);
            this.getHeldInternMap().log(useLogger);
            this.logHolderMap(useLogger);
            this.logHeldMap(useLogger);
            Tr.debug((TraceComponent)useLogger, (String)MessageFormat.format("BiDi Map: END: [ {0} ]", this.getHashText()), (Object[])new Object[0]);
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void logHolderMap(TraceComponent useLogger) {
        Tr.debug((TraceComponent)useLogger, (String)"Holder-to-held Map: BEGIN", (Object[])new Object[0]);
        for (Map.Entry<String, Set<String>> i_holderEntry : this.i_holderToHeldMap.entrySet()) {
            String i_holderName = i_holderEntry.getKey();
            Set<String> i_held = i_holderEntry.getValue();
            Tr.debug((TraceComponent)useLogger, (String)MessageFormat.format("  Holder [ {0} ] Held [ {1} ]", i_holderName, i_held), (Object[])new Object[0]);
        }
        Tr.debug((TraceComponent)useLogger, (String)"Holder-to-held Map: END", (Object[])new Object[0]);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void logHeldMap(TraceComponent useLogger) {
        Tr.debug((TraceComponent)useLogger, (String)"Held-to-holder Map: BEGIN", (Object[])new Object[0]);
        for (Map.Entry<String, Set<String>> i_heldEntry : this.i_heldToHoldersMap.entrySet()) {
            String i_heldName = i_heldEntry.getKey();
            Set<String> i_holders = i_heldEntry.getValue();
            Tr.debug((TraceComponent)useLogger, (String)MessageFormat.format("  Held [ {0} ] Holders [ {1} ]", i_heldName, i_holders), (Object[])new Object[0]);
        }
        Tr.debug((TraceComponent)useLogger, (String)"Held-to-holder Map: END", (Object[])new Object[0]);
    }
}

