/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.asn1;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.asn1.ASN1OutputStream;
import com.ibm.ws.transport.iiop.asn1.BEROutputStream;
import com.ibm.ws.transport.iiop.asn1.DEREncodable;
import com.ibm.ws.transport.iiop.asn1.DERObject;
import com.ibm.ws.transport.iiop.asn1.DEROctetString;
import com.ibm.ws.transport.iiop.asn1.DEROutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BERConstructedOctetString
extends DEROctetString {
    private Vector octs;
    static final long serialVersionUID = -5650486515204605120L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    private static byte[] toBytes(Vector octs) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        for (int i = 0; i != octs.size(); ++i) {
            try {
                DEROctetString o = (DEROctetString)octs.elementAt(i);
                bOut.write(o.getOctets());
                continue;
            }
            catch (ClassCastException o) {
                void e;
                FFDCFilter.processException((Throwable)o, (String)"com.ibm.ws.transport.iiop.asn1.BERConstructedOctetString", (String)"43", null, (Object[])new Object[]{octs});
                throw new IllegalArgumentException(octs.elementAt(i).getClass().getName() + " found in input should only contain DEROctetString", (Throwable)e);
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.transport.iiop.asn1.BERConstructedOctetString", (String)"47", null, (Object[])new Object[]{octs});
                throw new IllegalArgumentException("exception converting octets " + e.getMessage(), e);
            }
        }
        return bOut.toByteArray();
    }

    public BERConstructedOctetString(byte[] string) {
        super(string);
    }

    public BERConstructedOctetString(Vector octs) {
        super(BERConstructedOctetString.toBytes(octs));
        this.octs = octs;
    }

    public BERConstructedOctetString(DERObject obj) {
        super(obj);
    }

    public BERConstructedOctetString(DEREncodable obj) {
        super(obj.getDERObject());
    }

    @Override
    public byte[] getOctets() {
        return this.string;
    }

    public Enumeration getObjects() {
        if (this.octs == null) {
            return this.generateOcts().elements();
        }
        return this.octs.elements();
    }

    private Vector generateOcts() {
        byte[] nStr;
        int start = 0;
        int end = 0;
        Vector<DEROctetString> vec = new Vector<DEROctetString>();
        while (end + 1 < this.string.length) {
            if (this.string[end] == 0 && this.string[end + 1] == 0) {
                nStr = new byte[end - start + 1];
                System.arraycopy(this.string, start, nStr, 0, nStr.length);
                vec.addElement(new DEROctetString(nStr));
                start = end + 1;
            }
            ++end;
        }
        nStr = new byte[this.string.length - start];
        System.arraycopy(this.string, start, nStr, 0, nStr.length);
        vec.addElement(new DEROctetString(nStr));
        return vec;
    }

    @Override
    public void encode(DEROutputStream out) throws IOException {
        if (out instanceof ASN1OutputStream || out instanceof BEROutputStream) {
            out.write(36);
            out.write(128);
            if (this.octs != null) {
                for (int i = 0; i != this.octs.size(); ++i) {
                    out.writeObject(this.octs.elementAt(i));
                }
            } else {
                byte[] nStr;
                int start = 0;
                int end = 0;
                while (end + 1 < this.string.length) {
                    if (this.string[end] == 0 && this.string[end + 1] == 0) {
                        nStr = new byte[end - start + 1];
                        System.arraycopy(this.string, start, nStr, 0, nStr.length);
                        out.writeObject(new DEROctetString(nStr));
                        start = end + 1;
                    }
                    ++end;
                }
                nStr = new byte[this.string.length - start];
                System.arraycopy(this.string, start, nStr, 0, nStr.length);
                out.writeObject(new DEROctetString(nStr));
            }
            out.write(0);
            out.write(0);
        } else {
            super.encode(out);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.transport.iiop.asn1.BERConstructedOctetString", BERConstructedOctetString.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
    }
}

