/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.encryption;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.common.crypto.CryptoUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
final class AuditCrypto {
    private static TraceComponent tc = Tr.register(AuditCrypto.class, null, (String)"com.ibm.ejs.resources.security");
    private static IvParameterSpec ivs16 = null;
    static final long serialVersionUID = 3567301403020553307L;

    static final byte[] generateSharedKey() {
        return CryptoUtils.generateRandomBytes((int)32);
    }

    static final byte[] encrypt(byte[] data, byte[] key) {
        return AuditCrypto.encrypt(data, key, "AES/CBC/PKCS5Padding");
    }

    /*
     * WARNING - void declaration
     */
    static final byte[] encrypt(byte[] data, byte[] key, String cipher) {
        long start_time = 0L;
        if (tc.isDebugEnabled()) {
            start_time = System.currentTimeMillis();
            Tr.debug((TraceComponent)tc, (String)("Cipher used to encrypt: " + cipher), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Data size: " + data.length), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Key size: " + key.length), (Object[])new Object[0]);
        }
        if (null == data) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"data Array was null", (Object[])new Object[0]);
            }
            return null;
        }
        byte[] mesg = null;
        try {
            SecretKey sKey = AuditCrypto.constructSecretKey(key, cipher);
            Cipher ci = AuditCrypto.createCipher(1, key, cipher, sKey);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("encrypt() Cipher.doFinal()\n   data: " + new String(data)), (Object[])new Object[0]);
            }
            mesg = ci.doFinal(data);
        }
        catch (NoSuchAlgorithmException sKey) {
            void e;
            FFDCFilter.processException((Throwable)sKey, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"72", null, (Object[])new Object[]{data, key, cipher});
            Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"2256");
        }
        catch (InvalidKeyException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"75", null, (Object[])new Object[]{data, key, cipher});
            Tr.debug((TraceComponent)tc, (String)"Error: Key invalid", (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"2264");
        }
        catch (InvalidKeySpecException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"79", null, (Object[])new Object[]{data, key, cipher});
            Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"2267");
        }
        catch (NoSuchPaddingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"82", null, (Object[])new Object[]{data, key, cipher});
            Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"2270");
        }
        catch (IllegalBlockSizeException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"85", null, (Object[])new Object[]{data, key, cipher});
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"2273");
        }
        catch (BadPaddingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"88", null, (Object[])new Object[]{data, key, cipher});
            Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"2276");
        }
        catch (InvalidAlgorithmParameterException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"91", null, (Object[])new Object[]{data, key, cipher});
            Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"2279");
        }
        catch (NoSuchProviderException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"94", null, (Object[])new Object[]{data, key, cipher});
            Tr.error((TraceComponent)tc, (String)"security.ltpa.noprovider", (Object[])new Object[]{e});
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"2282");
        }
        if (tc.isDebugEnabled()) {
            long end_time = System.currentTimeMillis();
            Tr.debug((TraceComponent)tc, (String)("Total encryption time: " + (end_time - start_time)), (Object[])new Object[0]);
        }
        return mesg;
    }

    static final byte[] decrypt(byte[] mesg, byte[] key) {
        return AuditCrypto.decrypt(mesg, key, "AES/CBC/PKCS5Padding");
    }

    /*
     * WARNING - void declaration
     */
    static final byte[] decrypt(byte[] mesg, byte[] key, String cipher) {
        long start_time = 0L;
        if (tc.isDebugEnabled()) {
            start_time = System.currentTimeMillis();
            Tr.debug((TraceComponent)tc, (String)("Cipher used to decrypt: " + cipher), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("key size: " + key.length), (Object[])new Object[0]);
        }
        byte[] tmpMesg = null;
        try {
            SecretKey sKey = AuditCrypto.constructSecretKey(key, cipher);
            Cipher ci = AuditCrypto.createCipher(2, key, cipher, sKey);
            tmpMesg = ci.doFinal(mesg);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("decrypt() Cipher.doFinal()\n   tmpMesg: " + new String(tmpMesg)), (Object[])new Object[0]);
            }
        }
        catch (NoSuchAlgorithmException sKey) {
            void e;
            FFDCFilter.processException((Throwable)sKey, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"133", null, (Object[])new Object[]{mesg, key, cipher});
            Tr.error((TraceComponent)tc, (String)"no such algorithm exception", (Object[])new Object[]{e});
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"2385");
        }
        catch (InvalidKeyException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"136", null, (Object[])new Object[]{mesg, key, cipher});
            Tr.debug((TraceComponent)tc, (String)"Error: Key invalid", (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"2393");
        }
        catch (InvalidKeySpecException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"140", null, (Object[])new Object[]{mesg, key, cipher});
            Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"2396");
        }
        catch (NoSuchPaddingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"143", null, (Object[])new Object[]{mesg, key, cipher});
            Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"2399");
        }
        catch (IllegalBlockSizeException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"146", null, (Object[])new Object[]{mesg, key, cipher});
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"2402");
        }
        catch (BadPaddingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"149", null, (Object[])new Object[]{mesg, key, cipher});
            Tr.debug((TraceComponent)tc, (String)"BadPaddingException validating token, normal when token generated from other factory.", (Object[])new Object[]{e.getMessage()});
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"2405");
        }
        catch (InvalidAlgorithmParameterException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"152", null, (Object[])new Object[]{mesg, key, cipher});
            Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.auditAuditCrypto", (String)"2408");
        }
        catch (NoSuchProviderException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"155", null, (Object[])new Object[]{mesg, key, cipher});
            Tr.error((TraceComponent)tc, (String)"security.ltpa.noprovider", (Object[])new Object[]{e});
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.auditAuditCrypto", (String)"2412");
        }
        if (tc.isDebugEnabled()) {
            long end_time = System.currentTimeMillis();
            Tr.debug((TraceComponent)tc, (String)("Total decryption time: " + (end_time - start_time)), (Object[])new Object[0]);
        }
        return tmpMesg;
    }

    private static SecretKey constructSecretKey(byte[] key, String cipher) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        return new SecretKeySpec(key, 0, 32, "AES");
    }

    private static Cipher createCipher(int cipherMode, byte[] key, String cipher, SecretKey sKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchProviderException {
        Cipher ci = Cipher.getInstance(cipher);
        AuditCrypto.setIVS16(key);
        ci.init(cipherMode, (Key)sKey, ivs16);
        return ci;
    }

    public static IvParameterSpec getIVS16() {
        return ivs16;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public static synchronized void setIVS16(byte[] key) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setIVS16", (Object[])new Object[0]);
        }
        try {
            byte[] iv16 = new byte[16];
            for (int i = 0; i < 16; ++i) {
                iv16[i] = key[i];
            }
            ivs16 = new IvParameterSpec(iv16);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setIVS16: ivs16 successfully set", (Object[])new Object[0]);
            }
        }
        catch (Exception iv16) {
            void e;
            FFDCFilter.processException((Throwable)iv16, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"222", null, (Object[])new Object[]{key});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setIVS16 unxepected exception setting initialization vector", (Object[])new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.ltpa.LTPAToken2Factory.initialize", (String)"2568");
        }
    }
}

