/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.mp.jwt.error;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.mp.jwt.error.ErrorHandler;
import com.ibm.wsspi.security.tai.TAIResult;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ErrorHandlerImpl
implements ErrorHandler {
    private static final TraceComponent tc = Tr.register(ErrorHandlerImpl.class, (String)"MPJWT", (String)"com.ibm.ws.security.mp.jwt.resources.MicroProfileJwtMessages");
    private static final String AUTH_HEADER = "WWW-Authenticate";
    private static final String REALM = "MP-JWT";
    private static final String ERROR_CODE = "error=\"invalid_token\"";
    private static final String BEARER = "Bearer realm=\"MP-JWT\"";
    static final long serialVersionUID = 5823474843729932839L;

    public static ErrorHandler getInstance() {
        return new ErrorHandlerImpl();
    }

    @Override
    public TAIResult handleErrorResponse(HttpServletResponse response, TAIResult result) {
        this.handleErrorResponse(response, result.getStatus());
        return result;
    }

    @Override
    public void handleErrorResponse(HttpServletResponse response, int httpErrorCode) {
        if (!response.isCommitted()) {
            response.setStatus(httpErrorCode);
        }
        String errorMessage = this.getErrorMessage();
        response.setHeader(AUTH_HEADER, errorMessage);
    }

    String getErrorMessage() {
        String message = this.getRealmMessage();
        message = message + ", error=\"invalid_token\"";
        return message;
    }

    String getRealmMessage() {
        return BEARER;
    }
}

