/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.jakartasec.identitystore;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.cdi40.internal.utils.CDI40Utils;
import io.openliberty.security.jakartasec.credential.OidcTokensCredential;
import io.openliberty.security.jakartasec.identitystore.OpenIdContextImpl;
import io.openliberty.security.jakartasec.identitystore.OpenIdContextUtils;
import io.openliberty.security.jakartasec.tokens.AccessTokenImpl;
import io.openliberty.security.jakartasec.tokens.IdentityTokenImpl;
import io.openliberty.security.jakartasec.tokens.OpenIdClaimsImpl;
import io.openliberty.security.jakartasec.tokens.RefreshTokenImpl;
import io.openliberty.security.oidcclientcore.client.ClaimsMappingConfig;
import io.openliberty.security.oidcclientcore.client.Client;
import io.openliberty.security.oidcclientcore.client.OidcClientConfig;
import io.openliberty.security.oidcclientcore.config.MetadataUtils;
import io.openliberty.security.oidcclientcore.exceptions.OidcClientConfigurationException;
import io.openliberty.security.oidcclientcore.exceptions.OidcDiscoveryException;
import io.openliberty.security.oidcclientcore.token.TokenResponse;
import io.openliberty.security.oidcclientcore.userinfo.UserInfoHandler;
import jakarta.json.JsonObject;
import jakarta.security.enterprise.credential.Credential;
import jakarta.security.enterprise.identitystore.CredentialValidationResult;
import jakarta.security.enterprise.identitystore.IdentityStore;
import jakarta.security.enterprise.identitystore.openid.AccessToken;
import jakarta.security.enterprise.identitystore.openid.IdentityToken;
import jakarta.security.enterprise.identitystore.openid.OpenIdClaims;
import jakarta.security.enterprise.identitystore.openid.OpenIdContext;
import jakarta.servlet.http.HttpServletRequest;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OidcIdentityStore
implements IdentityStore {
    public static final TraceComponent tc = Tr.register(OidcIdentityStore.class, (String)"OpenIdConnect", (String)"io.openliberty.security.jakartasec.internal.resources.JakartaSecurity30Messages");
    static final long serialVersionUID = -3598182764074126354L;

    @FFDCIgnore(value={Exception.class})
    public CredentialValidationResult validate(Credential credential) {
        if (!(credential instanceof OidcTokensCredential)) {
            return CredentialValidationResult.NOT_VALIDATED_RESULT;
        }
        if (credential.isValid()) {
            OidcTokensCredential castCredential = (OidcTokensCredential)credential;
            TokenResponse tokenResponse = castCredential.getTokenResponse();
            Client client = castCredential.getClient();
            if (tokenResponse != null && client != null && tokenResponse.getAccessTokenString() != null) {
                try {
                    HttpServletRequest request = castCredential.getRequest();
                    JwtClaims idTokenClaims = client.validate(tokenResponse, request, castCredential.getResponse());
                    OidcClientConfig oidcClientConfig = client.getOidcClientConfig();
                    long tokenMinValidityInMillis = oidcClientConfig.getTokenMinValidity();
                    AccessToken accessToken = this.createAccessTokenFromTokenResponse(tokenMinValidityInMillis, tokenResponse);
                    IdentityToken identityToken = this.createIdentityTokenFromTokenResponse(tokenMinValidityInMillis, tokenResponse, idTokenClaims);
                    OpenIdClaims userInfoClaims = this.createOpenIdClaimsFromUserInfoResponse(oidcClientConfig, accessToken);
                    CredentialValidationResult credentialValidationResult = this.createCredentialValidationResult(client.getOidcClientConfig(), accessToken, idTokenClaims, userInfoClaims);
                    JsonObject providerMetadata = this.getProviderMetadataAsJsonObject(client.getOidcClientConfig());
                    this.setOpenIdContext(castCredential.getOpenIdContext(), credentialValidationResult.getCallerUniqueId(), tokenResponse, accessToken, identityToken, userInfoClaims, providerMetadata, request.getParameter("state"), oidcClientConfig.isUseSession(), client.getOidcClientConfig().getClientId());
                    return credentialValidationResult;
                }
                catch (Exception e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"validate", (Object[])new Object[]{"Exception occurred for client " + client.getOidcClientConfig().getClientId(), e});
                    }
                    Tr.error((TraceComponent)tc, (String)"CREDENTIAL_VALIDATION_ERROR", (Object[])new Object[]{client.getOidcClientConfig().getClientId(), e.toString()});
                    return CredentialValidationResult.INVALID_RESULT;
                }
            }
        }
        return CredentialValidationResult.INVALID_RESULT;
    }

    private void setOpenIdContext(OpenIdContext openIdContext, String subjectIdentifier, TokenResponse tokenResponse, AccessToken accessToken, IdentityToken identityToken, OpenIdClaims userinfoClaims, JsonObject providerMetadata, String state, boolean useSession, String clientId) {
        OpenIdContextImpl openIdContextImpl = (OpenIdContextImpl)CDI40Utils.getContextualInstanceFromProxy((Object)openIdContext);
        Map tokenResponseRawMap = tokenResponse.asMap();
        long expiresIn = 0L;
        if (tokenResponseRawMap.containsKey("expires_in")) {
            expiresIn = Long.parseLong((String)tokenResponseRawMap.get("expires_in"));
        }
        openIdContextImpl.setSubject(subjectIdentifier);
        openIdContextImpl.setTokenType((String)tokenResponseRawMap.get("token_type"));
        openIdContextImpl.setAccessToken(accessToken);
        openIdContextImpl.setIdentityToken(identityToken);
        openIdContextImpl.setExpiresIn(expiresIn);
        openIdContextImpl.setClaims(userinfoClaims);
        openIdContextImpl.setProviderMetadata(providerMetadata);
        openIdContextImpl.setState(state);
        openIdContextImpl.setUseSession(useSession);
        openIdContextImpl.setClientId(clientId);
        String refreshTokenString = tokenResponse.getRefreshTokenString();
        if (refreshTokenString != null) {
            openIdContextImpl.setRefreshToken(new RefreshTokenImpl(refreshTokenString));
        } else {
            openIdContextImpl.setRefreshToken(null);
        }
    }

    @FFDCIgnore(value={Exception.class})
    protected AccessToken createAccessTokenFromTokenResponse(long tokenMinValidityInMillis, TokenResponse tokenResponse) {
        String claimsAsJsonString;
        String METHODNAME = "createAccessTokenFromTokenResponse";
        Map tokenResponseRawMap = tokenResponse.asMap();
        long expiresIn = 0L;
        if (tokenResponseRawMap != null && tokenResponseRawMap.containsKey("expires_in")) {
            expiresIn = Long.parseLong((String)tokenResponseRawMap.get("expires_in"));
        }
        String accessTokenString = tokenResponse.getAccessTokenString();
        boolean isJWT = false;
        Map jwtClaims = null;
        String[] parts = accessTokenString.split(Pattern.quote("."));
        if (parts.length > 1) {
            try {
                try {
                    claimsAsJsonString = new String(Base64.getDecoder().decode(parts[0]), StandardCharsets.UTF_8);
                    JwtClaims.parse((String)claimsAsJsonString).getClaimsMap();
                    isJWT = true;
                }
                catch (Exception e1) {
                    String claimsAsJsonString2 = new String(Base64.getDecoder().decode(parts[1]), StandardCharsets.UTF_8);
                    jwtClaims = JwtClaims.parse((String)claimsAsJsonString2).getClaimsMap();
                    isJWT = true;
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        if (isJWT) {
            block11: {
                if (jwtClaims == null) {
                    try {
                        claimsAsJsonString = new String(Base64.getDecoder().decode(parts[1]), StandardCharsets.UTF_8);
                        jwtClaims = JwtClaims.parse((String)claimsAsJsonString).getClaimsMap();
                    }
                    catch (Exception e1) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block11;
                        Tr.debug((TraceComponent)tc, (String)"createAccessTokenFromTokenResponse", (Object[])new Object[]{"The tokenResponse accessTokenString was parsable for the first part, but couldn't parse out a claimsMap.", e1});
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"createAccessTokenFromTokenResponse", (Object[])new Object[]{"Creating a jwt access token based on the tokenResponse accessTokenString"});
            }
            return new AccessTokenImpl(accessTokenString, jwtClaims, tokenResponse.getResponseGenerationTime(), expiresIn, tokenMinValidityInMillis);
        }
        return new AccessTokenImpl(accessTokenString, tokenResponse.getResponseGenerationTime(), expiresIn, tokenMinValidityInMillis);
    }

    private IdentityToken createIdentityTokenFromTokenResponse(long tokenMinValidityInMillis, TokenResponse tokenResponse, JwtClaims idTokenClaims) {
        String idTokenString = tokenResponse.getIdTokenString();
        if (idTokenString == null) {
            return null;
        }
        return new IdentityTokenImpl(idTokenString, idTokenClaims.getClaimsMap(), tokenMinValidityInMillis);
    }

    @FFDCIgnore(value={Exception.class})
    private OpenIdClaims createOpenIdClaimsFromUserInfoResponse(OidcClientConfig oidcClientConfig, AccessToken accessToken) {
        Map userInfoClaims;
        block3: {
            UserInfoHandler userInfoHandler = this.getUserInfoHandler();
            userInfoClaims = null;
            try {
                userInfoClaims = userInfoHandler.getUserInfoClaims(oidcClientConfig, accessToken.getToken());
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"The {0} OpenID Connect client cannot create claims from the UserInfo data that was returned from the OpenID Connect provider. {1}", (Object[])new Object[]{oidcClientConfig.getClientId(), e.toString()});
            }
        }
        if (userInfoClaims == null) {
            return null;
        }
        return new OpenIdClaimsImpl(userInfoClaims);
    }

    UserInfoHandler getUserInfoHandler() {
        return new UserInfoHandler();
    }

    CredentialValidationResult createCredentialValidationResult(OidcClientConfig clientConfig, AccessToken accessToken, JwtClaims idTokenClaims, OpenIdClaims userInfoClaims) throws MalformedClaimException {
        String issuer = this.getIssuer(clientConfig, accessToken, idTokenClaims, userInfoClaims);
        String caller = this.getCallerName(clientConfig, accessToken, idTokenClaims, userInfoClaims);
        if (caller == null) {
            Tr.error((TraceComponent)tc, (String)"CREDENTIAL_VALIDATION_CALLER_MISSING", (Object[])new Object[]{this.getCallerNameClaim(clientConfig)});
            return CredentialValidationResult.INVALID_RESULT;
        }
        Set<String> groups = this.getCallerGroups(clientConfig, accessToken, idTokenClaims, userInfoClaims);
        return new CredentialValidationResult(issuer, caller, null, caller, groups);
    }

    @FFDCIgnore(value={OidcDiscoveryException.class})
    private JsonObject getProviderMetadataAsJsonObject(OidcClientConfig oidcClientConfig) {
        try {
            return OpenIdContextUtils.convertJsonObject(MetadataUtils.getProviderDiscoveryMetaData((OidcClientConfig)oidcClientConfig));
        }
        catch (OidcClientConfigurationException | OidcDiscoveryException oe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getProviderMetadataAsJsonObject", (Object[])new Object[]{"getProviderDiscoveryMetaData threw an exception, the providerMetadata JsonObject will be null.", oe});
            }
            return null;
        }
    }

    String getIssuer(OidcClientConfig clientConfig, AccessToken accessToken, JwtClaims idTokenClaims, OpenIdClaims userInfoClaims) throws MalformedClaimException {
        String issuer = this.getClaimValueFromTokens("iss", accessToken, idTokenClaims, userInfoClaims, String.class);
        if (issuer == null || issuer.isEmpty()) {
            issuer = this.issuerFromProviderMetadata(clientConfig);
        }
        return issuer;
    }

    private String issuerFromProviderMetadata(OidcClientConfig clientConfig) {
        return clientConfig.getProviderMetadata().getIssuer();
    }

    String getCallerName(OidcClientConfig clientConfig, AccessToken accessToken, JwtClaims idTokenClaims, OpenIdClaims userInfoClaims) throws MalformedClaimException {
        String callerNameClaim = this.getCallerNameClaim(clientConfig);
        if (callerNameClaim == null || callerNameClaim.isEmpty()) {
            return null;
        }
        return this.getClaimValueFromTokens(callerNameClaim, accessToken, idTokenClaims, userInfoClaims, String.class);
    }

    Set<String> getCallerGroups(OidcClientConfig clientConfig, AccessToken accessToken, JwtClaims idTokenClaims, OpenIdClaims userInfoClaims) throws MalformedClaimException {
        String callerGroupClaim = this.getCallerGroupsClaim(clientConfig);
        if (callerGroupClaim == null || callerGroupClaim.isEmpty()) {
            return null;
        }
        List groups = this.getClaimValueFromTokens(callerGroupClaim, accessToken, idTokenClaims, userInfoClaims, List.class);
        if (groups != null) {
            return Set.copyOf(groups);
        }
        return null;
    }

    String getCallerNameClaim(OidcClientConfig clientConfig) {
        ClaimsMappingConfig claimsMappingConfig = clientConfig.getClaimsMappingConfig();
        if (claimsMappingConfig != null) {
            return claimsMappingConfig.getCallerNameClaim();
        }
        return null;
    }

    String getCallerGroupsClaim(OidcClientConfig clientConfig) {
        ClaimsMappingConfig claimsMappingConfig = clientConfig.getClaimsMappingConfig();
        if (claimsMappingConfig != null) {
            return claimsMappingConfig.getCallerGroupsClaim();
        }
        return null;
    }

    <T> T getClaimValueFromTokens(String claim, AccessToken accessToken, JwtClaims idTokenClaims, OpenIdClaims userInfoClaims, Class<T> claimType) throws MalformedClaimException {
        T claimValue = this.getClaimFromAccessToken(accessToken, claim);
        if (this.valueExistsAndIsNotEmpty(claimValue, claimType)) {
            return claimValue;
        }
        claimValue = this.getClaimFromIdToken(idTokenClaims, claim, claimType);
        if (this.valueExistsAndIsNotEmpty(claimValue, claimType)) {
            return claimValue;
        }
        claimValue = this.getClaimFromUserInfo(userInfoClaims, claim, claimType);
        if (this.valueExistsAndIsNotEmpty(claimValue, claimType)) {
            return claimValue;
        }
        return null;
    }

    <T> T getClaimFromAccessToken(AccessToken accessToken, String claim) {
        if (accessToken.isJWT()) {
            return (T)accessToken.getClaim(claim);
        }
        return null;
    }

    <T> T getClaimFromIdToken(JwtClaims idTokenClaims, String claim, Class<T> claimType) throws MalformedClaimException {
        return (T)idTokenClaims.getClaimValue(claim, claimType);
    }

    <T> T getClaimFromUserInfo(OpenIdClaims userInfoClaims, String claim, Class<T> claimType) {
        if (userInfoClaims == null) {
            return null;
        }
        if (claimType.equals(String.class)) {
            Optional claimValue = userInfoClaims.getStringClaim(claim);
            if (claimValue.isPresent()) {
                return claimValue.get();
            }
            return null;
        }
        if (claimType.equals(List.class)) {
            return (T)userInfoClaims.getArrayStringClaim(claim);
        }
        return null;
    }

    <T> boolean valueExistsAndIsNotEmpty(T claimValue, Class<T> claimType) {
        if (claimValue == null) {
            return false;
        }
        if (claimType.equals(String.class) && ((String)claimValue).isEmpty()) {
            return false;
        }
        if (claimType.equals(Set.class) && ((Set)claimValue).isEmpty()) {
            return false;
        }
        return !claimType.equals(List.class) || !((List)claimValue).isEmpty();
    }
}

