/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.services.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.services.ConfigField;
import io.openliberty.microprofile.openapi20.internal.services.ConfigFieldProvider;
import io.smallrye.openapi.api.OpenApiConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE)
public class ConfigFieldProvider20Impl
implements ConfigFieldProvider {
    static final long serialVersionUID = -6264416027019286011L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Collection<ConfigField> getConfigFields() {
        return Arrays.asList(ConfigField20.values());
    }

    public Collection<ConfigField> getIndexingConfigFields() {
        ArrayList<ConfigField> result = new ArrayList<ConfigField>();
        result.add(ConfigField20.SCAN_DISABLE);
        result.add(ConfigField20.SCAN_CLASSES);
        result.add(ConfigField20.SCAN_EXCLUDE_CLASSES);
        result.add(ConfigField20.SCAN_PACKAGES);
        result.add(ConfigField20.SCAN_EXCLUDE_PACKAGES);
        result.add(ConfigField20.SCAN_DEPENDENCIES_DISABLE);
        result.add(ConfigField20.SCAN_DEPENDENCIES_JARS);
        return result;
    }

    public String getPathServers(OpenApiConfig config, String path) {
        return ConfigField.serializeSet((Set)config.pathServers(path));
    }

    public String getOperationServers(OpenApiConfig config, String operationId) {
        return ConfigField.serializeSet((Set)config.operationServers(operationId));
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.openapi20.internal.services.impl.ConfigFieldProvider20Impl", ConfigFieldProvider20Impl.class, null, null);
    }

    private static enum ConfigField20 implements ConfigField
    {
        MODEL_READER("modelReader", "mp.openapi.model.reader", OpenApiConfig::modelReader),
        FILTER("filter", "mp.openapi.filter", OpenApiConfig::filter),
        SCAN_DISABLE("scanDisable", "mp.openapi.scan.disable", c -> Boolean.toString(c.scanDisable())),
        SCAN_PACKAGES("scanPackages", "mp.openapi.scan.packages", OpenApiConfig::scanPackages, Pattern::pattern),
        SCAN_CLASSES("scanClasses", "mp.openapi.scan.classes", OpenApiConfig::scanClasses, Pattern::pattern),
        SCAN_EXCLUDE_PACKAGES("scanExcludePackages", "mp.openapi.scan.exclude.packages", OpenApiConfig::scanExcludePackages, Pattern::pattern),
        SCAN_EXCLUDE_CLASSES("scanExcludeClasses", "mp.openapi.scan.exclude.classes", OpenApiConfig::scanExcludeClasses, Pattern::pattern),
        SERVERS("servers", "mp.openapi.servers", c -> ConfigField.serializeSet((Set)c.servers())),
        SCAN_DEPENDENCIES_DISABLE("scanDependenciesDisable", "mp.openapi.extensions.smallrye.scan-dependencies.disable", c -> Boolean.toString(c.scanDependenciesDisable())),
        SCAN_DEPENDENCIES_JARS("scanDependenciesJars", "mp.openapi.extensions.smallrye.scan-dependencies.jars", c -> ConfigField.serializeSet((Set)c.scanDependenciesJars())),
        CUSTOM_SCHEMA_REGISTRY_CLASS("customSchemaRegistryClass", "mp.openapi.extensions.smallrye.custom-schema-registry.class", OpenApiConfig::customSchemaRegistryClass),
        APPLICATION_PATH_DISABLE("applicationPathDisable", "mp.openapi.extensions.smallrye.application-path.disable", c -> Boolean.toString(c.applicationPathDisable())),
        PRIVATE_PROPERTIES_ENABLE("privatePropertiesEnable", "mp.openapi.extensions.smallrye.private-properties.enable", c -> Boolean.toString(c.privatePropertiesEnable())),
        PROPERTY_NAMING_STRATEGY("propertyNamingStrategy", "mp.openapi.extensions.smallrye.property-naming-strategy", OpenApiConfig::propertyNamingStrategy),
        SORTED_PROPERTIES_ENABLE("sortedPropertiesEnable", "mp.openapi.extensions.smallrye.sorted-properties.enable", c -> Boolean.toString(c.sortedPropertiesEnable())),
        SCHEMAS("getSchemas", "mp.openapi.schema.*", c -> ConfigField.serializeMap((Map)c.getSchemas())),
        OPEN_API_VERSION("getOpenApiVersion", "mp.openapi.extensions.smallrye.openapi", OpenApiConfig::getOpenApiVersion),
        INFO_TITLE("getInfoTitle", "mp.openapi.extensions.smallrye.info.title", OpenApiConfig::getInfoTitle),
        INFO_VERSION("getInfoVersion", "mp.openapi.extensions.smallrye.info.version", OpenApiConfig::getInfoVersion),
        INFO_DESCRIPTION("getInfoDescription", "mp.openapi.extensions.smallrye.info.description", OpenApiConfig::getInfoDescription),
        INFO_TERMS_OF_SERVICE("getInfoTermsOfService", "mp.openapi.extensions.smallrye.info.termsOfService", OpenApiConfig::getInfoTermsOfService),
        INFO_CONTACT_EMAIL("getInfoContactEmail", "mp.openapi.extensions.smallrye.info.contact.email", OpenApiConfig::getInfoContactEmail),
        INFO_CONTACT_NAME("getInfoContactName", "mp.openapi.extensions.smallrye.info.contact.name", OpenApiConfig::getInfoContactName),
        INFO_CONTACT_URL("getInfoContactUrl", "mp.openapi.extensions.smallrye.info.contact.url", OpenApiConfig::getInfoContactUrl),
        INFO_LICENSE_NAME("getInfoLicenseName", "mp.openapi.extensions.smallrye.info.license.name", OpenApiConfig::getInfoLicenseName),
        INFO_LICENSE_URL("getInfoLicenseUrl", "mp.openapi.extensions.smallrye.info.license.url", OpenApiConfig::getInfoLicenseName),
        OPERATION_ID_STRATEGY("getOperationIdStrategy", "mp.openapi.extensions.smallrye.operationIdStrategy", OpenApiConfig::getOperationIdStrategy, Enum::name),
        ARRAY_REFERENCES_ENABLE("arrayReferencesEnable", "mp.openapi.extensions.smallrye.array-references.enable", c -> Boolean.toString(c.arrayReferencesEnable())),
        DEFAULT_PRODUCES("getDefaultProduces", "mp.openapi.extensions.smallrye.defaultProduces", OpenApiConfig::getDefaultProduces, Optional::toString),
        DEFAULT_CONSUMES("getDefaultConsumes", "mp.openapi.extensions.smallrye.defaultConsumes", OpenApiConfig::getDefaultConsumes, Optional::toString),
        ALLOW_NAKED_PATH_PARAMETER("allowNakedPathParameter", "allowNakedPathParameter", OpenApiConfig::allowNakedPathParameter, Optional::toString);

        Function<OpenApiConfig, String> function;
        String methodName;
        String propertyName;

        private ConfigField20(String name, String propertyName, Function<OpenApiConfig, String> function) {
            this.methodName = name;
            this.function = function;
            this.propertyName = propertyName;
        }

        private <V> ConfigField20(String methodName, String propertyName, Function<OpenApiConfig, V> valueGetter, Function<V, String> stringConverter) {
            this.methodName = methodName;
            this.propertyName = propertyName;
            this.function = c -> {
                Object value = valueGetter.apply((OpenApiConfig)c);
                return value == null ? null : (String)stringConverter.apply(value);
            };
        }

        public String getMethod() {
            return this.methodName;
        }

        public String getValue(OpenApiConfig config) {
            return this.function.apply(config);
        }

        public String getProperty() {
            return this.propertyName;
        }
    }
}

