/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.service;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.wsat.Constants;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.bind.JAXBElement;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.EndpointReferenceUtils;
import org.apache.cxf.ws.addressing.ReferenceParametersType;

@TraceObjectField(fieldName="TC", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WSATUtil {
    private static final TraceComponent TC = Tr.register(WSATUtil.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
    static final long serialVersionUID = 4681618968405959789L;

    public static EndpointReferenceType createEpr(String hostname) {
        EndpointReferenceType epr = new EndpointReferenceType();
        AttributedURIType uri = new AttributedURIType();
        uri.setValue(hostname);
        epr.setAddress(uri);
        epr.setReferenceParameters(new ReferenceParametersType());
        return epr;
    }

    public static EndpointReferenceType createEpr(String hostname, String globalId, String recoveryId) {
        EndpointReferenceType epr = WSATUtil.createEpr(hostname);
        ReferenceParametersType para = epr.getReferenceParameters();
        if (recoveryId != null && !recoveryId.isEmpty()) {
            para.getAny().add(new JAXBElement(Constants.WS_WSAT_REC_REF, String.class, (Object)recoveryId));
        }
        if (globalId != null && !globalId.isEmpty()) {
            para.getAny().add(new JAXBElement(Constants.WS_WSAT_CTX_REF, String.class, (Object)globalId));
        }
        return epr;
    }

    public static String createRedirectAddr(String origAddr, String newAddr) {
        URL redirectURL;
        try {
            URL origURL = new URL(origAddr);
            URL recoveryURL = new URL(newAddr);
            redirectURL = new URL(recoveryURL.getProtocol(), recoveryURL.getHost(), recoveryURL.getPort(), origURL.getFile());
        }
        catch (MalformedURLException origURL) {
            FFDCFilter.processException((Throwable)origURL, (String)"com.ibm.ws.wsat.service.WSATUtil", (String)"67", null, (Object[])new Object[]{origAddr, newAddr});
            return null;
        }
        String ret = redirectURL.toString();
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"REROUTE ADDRESS: {0}", (Object[])new Object[]{ret});
        }
        return ret;
    }

    public static EndpointReferenceType cloneEPR(EndpointReferenceType epr) {
        EndpointReferenceType newEpr = EndpointReferenceUtils.duplicate((EndpointReferenceType)epr);
        ReferenceParametersType refs = new ReferenceParametersType();
        for (Object ref : epr.getReferenceParameters().getAny()) {
            refs.getAny().add(ref);
        }
        newEpr.setReferenceParameters(refs);
        return newEpr;
    }
}

