/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.matching;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.processor.impl.ControllableProxySubscription;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.matching.MessageProcessorSearchResults;
import com.ibm.ws.sib.processor.matching.TopicAclTraversalResults;
import com.ibm.ws.sib.processor.matching.TopicAuthorization;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class NeighbourFlexHandler
implements MessageProcessorSearchResults.Handler {
    private static final TraceComponent tc = SibTr.register(NeighbourFlexHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    TopicAuthorization authorization = null;

    @Override
    public Object initResult() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initResult");
        }
        HashSet theResults = new HashSet();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initResult");
        }
        return theResults;
    }

    @Override
    public void resetResult(Object result) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetResult");
        }
        if (result != null) {
            ((HashSet)result).clear();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetResult");
        }
    }

    @Override
    public void processIntermediateMatches(List targets, Object result) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processIntermediateMatches", (Object)("targets: " + targets + ";results: " + result));
        }
        ((Set)result).addAll(targets);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processIntermediateMatches");
        }
    }

    @Override
    public void postProcessMatches(DestinationHandler topicSpace, String topic, Object[] results, int index) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"postProcessMatches", (Object)("results: " + Arrays.toString(results) + ";index: " + index + ";topic" + topic));
        }
        Set subRes = (Set)results[index];
        Iterator itr = subRes.iterator();
        if (this.authorization != null && this.authorization.isBusSecure() && topicSpace != null && topicSpace.isTopicAccessCheckRequired()) {
            while (itr.hasNext()) {
                ControllableProxySubscription cps = (ControllableProxySubscription)itr.next();
                if (!cps.isForeignSecuredProxy()) continue;
                String userid = cps.getMESubUserId();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Foreign bus proxy in a secured env for user, " + userid + ", on topic, " + topic));
                }
                try {
                    if (this.authorization.checkPermissionToSubscribe(topicSpace, topic, userid, (TopicAclTraversalResults)results[0])) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Not authorized, remove from PSOH results");
                    }
                    itr.remove();
                }
                catch (Exception exception) {}
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"postProcessMatches");
        }
    }

    @Override
    public void setAuthorization(TopicAuthorization authorization) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setAuthorization", (Object)("authorization: " + authorization));
        }
        this.authorization = authorization;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setAuthorization");
        }
    }

    @Override
    public String toString(Object[] results, int index) {
        StringBuffer buffer = new StringBuffer(" neighb: [");
        Set cpss = (Set)results[index];
        Iterator itr = cpss.iterator();
        boolean first = true;
        while (itr.hasNext()) {
            ControllableProxySubscription cps = (ControllableProxySubscription)itr.next();
            if (!first) {
                buffer.append(", ");
            } else {
                first = false;
            }
            buffer.append(cps);
        }
        buffer.append("]");
        return buffer.toString();
    }
}

