/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.provider.service;

import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.CDIProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class CDIProviderService
implements CDIProvider {
    private static volatile CDIProvider cdiProvider = null;

    @Override
    public CDI<Object> getCDI() {
        if (cdiProvider == null) {
            this.fetchCDIRuntime();
        }
        return cdiProvider.getCDI();
    }

    private synchronized void fetchCDIRuntime() {
        if (cdiProvider == null) {
            final Bundle bundle = FrameworkUtil.getBundle(CDIProvider.class);
            CDIProvider cdiProvider = AccessController.doPrivileged(new PrivilegedAction<CDIProvider>(){

                @Override
                public CDIProvider run() {
                    BundleContext bCtx = bundle.getBundleContext();
                    ServiceReference svcRef = bCtx.getServiceReference(CDIProvider.class);
                    return svcRef == null ? null : (CDIProvider)bCtx.getService(svcRef);
                }
            });
            if (cdiProvider == null) {
                throw new IllegalStateException("Failed to get the cdiProvider.");
            }
            CDIProviderService.cdiProvider = cdiProvider;
        }
    }
}

