/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIParameter;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.component.html.HtmlCommandScript;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.FacesEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.renderkit.html.util.AjaxScriptBuilder;
import org.apache.myfaces.shared.renderkit.RendererUtils;
import org.apache.myfaces.shared.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared.renderkit.html.JavascriptContext;
import org.apache.myfaces.shared.renderkit.html.util.FormInfo;
import org.apache.myfaces.shared.renderkit.html.util.JavascriptUtils;
import org.apache.myfaces.shared.renderkit.html.util.ResourceUtils;
import org.apache.myfaces.shared.renderkit.html.util.SharedStringBuilder;
import org.apache.myfaces.shared.util.StringUtils;

public class HtmlCommandScriptRenderer
extends HtmlRenderer {
    private static final String AJAX_SB = "oam.renderkit.AJAX_SB";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        super.encodeBegin(context, component);
        HtmlCommandScript commandScript = (HtmlCommandScript)component;
        ResponseWriter writer = context.getResponseWriter();
        ResourceUtils.renderDefaultJsfJsInlineIfNecessary(context, writer);
        writer.startElement("span", component);
        writer.writeAttribute("id", (Object)component.getClientId(context), null);
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        JavascriptContext script = new JavascriptContext();
        String cmdName = commandScript.getName();
        String name = cmdName != null && cmdName.length() > 0 ? JavascriptUtils.getValidJavascriptName(cmdName, true) : JavascriptUtils.getValidJavascriptName(component.getClientId(context), true);
        script.prettyLine();
        script.increaseIndent();
        script.append("var " + name + " = function(o, event){var o=(typeof o==='object')&&o?o:{};");
        script.prettyLine();
        List<UIParameter> uiParams = HtmlRendererUtils.getValidUIParameterChildren(context, this.getChildren((UIComponent)commandScript), false, false);
        UIParameter behaviorEventMarker = new UIParameter();
        behaviorEventMarker.setName("jakarta.faces.behavior.event");
        behaviorEventMarker.setValue((Object)commandScript.getDefaultEventName());
        ArrayList<UIParameter> finalUIParams = new ArrayList<UIParameter>(uiParams.size() + 1);
        finalUIParams.addAll(uiParams);
        finalUIParams.add(behaviorEventMarker);
        StringBuilder ajax = SharedStringBuilder.get(context, AJAX_SB, 60);
        AjaxScriptBuilder.build((FacesContext)context, (StringBuilder)ajax, (UIComponent)commandScript, (String)commandScript.getClientId(context), (String)commandScript.getOnevent(), (String)commandScript.getExecute(), (String)commandScript.getRender(), (Boolean)commandScript.getResetValues(), (String)commandScript.getOnerror(), (String)commandScript.getOnevent(), finalUIParams);
        script.append(ajax.toString());
        script.decreaseIndent();
        script.append("}");
        if (commandScript.isAutorun()) {
            script.append(";");
            script.append("myfaces._impl.core._Runtime.addOnLoad(window,");
            script.append(name);
            script.append(");");
        }
        writer.writeText((Object)script.toString(), null);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("script");
        writer.endElement("span");
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        super.decode(facesContext, component);
        HtmlCommandScript commandScript = (HtmlCommandScript)component;
        if (HtmlRendererUtils.isDisabled(component) || !commandScript.isRendered()) {
            return;
        }
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        String behaviorEventName = (String)paramMap.get("jakarta.faces.behavior.event");
        if (behaviorEventName != null) {
            String item;
            String sourceId = (String)paramMap.get("jakarta.faces.source");
            String componentClientId = component.getClientId(facesContext);
            String clientId = sourceId;
            if (sourceId.startsWith(componentClientId) && sourceId.length() > componentClientId.length() && StringUtils.isInteger((String)(item = sourceId.substring(componentClientId.length() + 1)))) {
                clientId = componentClientId;
            }
            if (component.getClientId(facesContext).equals(clientId)) {
                boolean disabled = HtmlRendererUtils.isDisabled(component);
                FormInfo formInfo = RendererUtils.findNestingForm(component, facesContext);
                boolean activateActionEvent = false;
                if (formInfo != null && !disabled) {
                    String reqValue = (String)facesContext.getExternalContext().getRequestParameterMap().get(HtmlRendererUtils.getHiddenCommandLinkFieldName(formInfo, facesContext));
                    boolean bl = activateActionEvent = reqValue != null && reqValue.equals(clientId) || HtmlRendererUtils.isPartialOrBehaviorSubmit(facesContext, clientId);
                    if (activateActionEvent) {
                        RendererUtils.initPartialValidationAndModelUpdate(component, facesContext);
                    }
                }
                if (activateActionEvent) {
                    component.queueEvent((FacesEvent)new ActionEvent(component));
                }
            }
        }
        if (component instanceof ClientBehaviorHolder && !HtmlRendererUtils.isDisabled(component)) {
            HtmlRendererUtils.decodeClientBehaviors(facesContext, component);
        }
    }
}

