/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.impl;

import java.util.function.Supplier;

public class ThrottleState {
    public final long[] buckets;
    private int currentBucket = 0;
    private long lastBucketTime;
    private long runningTotal = 0L;
    private long weightedRunningTotal = 0L;
    private final double weightedBuckets = 5.0;
    private final double weightMultiplier = 2.0;
    private final int windowIntervals = 20;
    private final double bucketDurationMs;
    private long lastAccessTime;
    private final Supplier<Integer> maxMessagesSupplier;

    public ThrottleState(int throttleWindowDuration, Supplier<Integer> maxMessagesSupplier) {
        this.maxMessagesSupplier = maxMessagesSupplier;
        this.bucketDurationMs = throttleWindowDuration / 20;
        this.buckets = new long[20];
        this.lastBucketTime = System.currentTimeMillis();
        this.lastAccessTime = System.currentTimeMillis();
    }

    public synchronized boolean increment() {
        this.rotateBuckets();
        int n = this.currentBucket;
        this.buckets[n] = this.buckets[n] + 1L;
        ++this.runningTotal;
        this.lastAccessTime = System.currentTimeMillis();
        double weight = this.getBucketWeight(0);
        this.weightedRunningTotal = (long)((double)this.weightedRunningTotal + weight);
        return this.runningTotal > (long)this.maxMessagesSupplier.get().intValue();
    }

    private void rotateBuckets() {
        long now = System.currentTimeMillis();
        int elapsed = (int)((double)(now - this.lastBucketTime) / this.bucketDurationMs);
        if (elapsed > 0) {
            for (int i = 1; i <= Math.min(elapsed, this.buckets.length); ++i) {
                int idx = (this.currentBucket + i) % this.buckets.length;
                double weight = this.getBucketWeight(i);
                this.weightedRunningTotal = (long)((double)this.weightedRunningTotal - (double)this.buckets[idx] * weight);
                this.runningTotal -= this.buckets[idx];
                this.buckets[idx] = 0L;
            }
            this.currentBucket = (this.currentBucket + elapsed) % this.buckets.length;
            this.lastBucketTime = (long)((double)this.lastBucketTime + (double)elapsed * this.bucketDurationMs);
        }
    }

    public double getBucketWeight(int offset) {
        return (double)offset < 5.0 ? 2.0 : 1.0;
    }

    public synchronized long getRunningTotal() {
        return this.runningTotal;
    }

    public synchronized long getWeightedRunningTotal() {
        return this.weightedRunningTotal;
    }

    public synchronized long getLastAccessTime() {
        return this.lastAccessTime;
    }
}

