/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.config;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.ssl.SSLSupport;
import io.openliberty.security.oidcclientcore.client.OidcClientConfig;
import io.openliberty.security.oidcclientcore.discovery.DiscoveryHandler;
import io.openliberty.security.oidcclientcore.exceptions.OidcClientConfigurationException;
import io.openliberty.security.oidcclientcore.exceptions.OidcDiscoveryException;
import javax.net.ssl.SSLSocketFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={OidcMetadataService.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE)
public class OidcMetadataService {
    public static final TraceComponent tc = Tr.register(OidcMetadataService.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    public static final String KEY_METADATA_SERVICE = "oidcMetadataService";
    private static final String KEY_SSL_SUPPORT = "sslSupport";
    protected static volatile SSLSupport sslSupport;
    static final long serialVersionUID = 9034807100773926847L;

    @Reference(name="sslSupport", policy=ReferencePolicy.DYNAMIC)
    public void setSslSupport(SSLSupport sslSupportSvc) {
        sslSupport = sslSupportSvc;
    }

    public void unsetSslSupport(SSLSupport sslSupportSvc) {
        sslSupport = null;
    }

    public static SSLSupport getSSLSupport() {
        return sslSupport;
    }

    public static SSLSocketFactory getSSLSocketFactory() {
        if (sslSupport != null) {
            return sslSupport.getSSLSocketFactory();
        }
        return null;
    }

    public DiscoveryHandler getDiscoveryHandler() {
        SSLSocketFactory sslSocketFactory = OidcMetadataService.getSSLSocketFactory();
        return new DiscoveryHandler(sslSocketFactory);
    }

    public JSONObject getProviderDiscoveryMetadata(OidcClientConfig oidcClientConfig) throws OidcClientConfigurationException, OidcDiscoveryException {
        JSONObject discoveryData = null;
        String discoveryUri = oidcClientConfig.getProviderURI();
        if (discoveryUri == null || discoveryUri.isEmpty()) {
            String clientId = oidcClientConfig.getClientId();
            String nlsMessage = Tr.formatMessage((TraceComponent)tc, (String)"OIDC_CLIENT_MISSING_PROVIDER_URI", (Object[])new Object[]{clientId});
            throw new OidcClientConfigurationException(clientId, nlsMessage);
        }
        discoveryUri = this.addWellKnownSuffixIfNeeded(discoveryUri);
        discoveryData = this.fetchProviderMetadataFromDiscoveryUrl(discoveryUri, oidcClientConfig.getClientId());
        return discoveryData;
    }

    String addWellKnownSuffixIfNeeded(String providerUri) {
        if (!providerUri.endsWith(".well-known/openid-configuration")) {
            if (!providerUri.endsWith("/")) {
                providerUri = providerUri + "/";
            }
            providerUri = providerUri + ".well-known/openid-configuration";
        }
        return providerUri;
    }

    JSONObject fetchProviderMetadataFromDiscoveryUrl(String discoveryUri, String clientId) throws OidcDiscoveryException {
        DiscoveryHandler discoveryHandler = this.getDiscoveryHandler();
        return discoveryHandler.fetchDiscoveryDataJson(discoveryUri, clientId);
    }
}

