/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.token;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.security.oidcclientcore.token.TokenConstants;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TokenResponse {
    private final JSONObject rawResponse;
    private final String idTokenString;
    private final String accessTokenString;
    private final String refreshTokenString;
    private final Instant responseGenerationTime = Instant.now();
    private Map<String, String> responseAsMap = null;
    static final long serialVersionUID = 7979525711963811327L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public TokenResponse(JSONObject rawResponse) {
        Map<String, String> tokens = this.getTokensFromJson(rawResponse);
        this.rawResponse = rawResponse;
        this.idTokenString = tokens.get("id_token");
        this.accessTokenString = tokens.get("access_token");
        this.refreshTokenString = tokens.get("refresh_token");
    }

    private Map<String, String> getTokensFromJson(JSONObject json) {
        HashMap<String, String> tokens = new HashMap<String, String>();
        List<String> tokenTypes = Arrays.asList(TokenConstants.TOKEN_TYPES);
        for (String key : json.keySet()) {
            Object value = json.get((Object)key);
            if (!(value instanceof String) || !tokenTypes.contains(key)) continue;
            tokens.put(key, value.toString());
        }
        return tokens;
    }

    public String getIdTokenString() {
        return this.idTokenString;
    }

    public String getAccessTokenString() {
        return this.accessTokenString;
    }

    public String getRefreshTokenString() {
        return this.refreshTokenString;
    }

    public Map<String, String> asMap() {
        if (this.responseAsMap != null) {
            return this.responseAsMap;
        }
        if (this.rawResponse == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Set keys = this.rawResponse.keySet();
        for (String key : keys) {
            map.put(key, this.rawResponse.get((Object)key).toString());
        }
        this.responseAsMap = new HashMap<String, String>(map);
        return map;
    }

    public Instant getResponseGenerationTime() {
        return this.responseGenerationTime;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.security.oidcclientcore.token.TokenResponse", TokenResponse.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    }
}

