/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.config.Component;
import com.ibm.ws.cache.config.ConfigEntry;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.servlet.FragmentCacheProcessor;
import com.ibm.ws.cache.servlet.SOAPRequestHandler;
import com.ibm.ws.common.crypto.CryptoUtils;
import com.ibm.ws.common.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.xml.ParserFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.servlet.ServletInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.helpers.DefaultHandler;

public class WebServicesCacheProcessor
extends FragmentCacheProcessor {
    protected static TraceComponent tc = Tr.register(WebServicesCacheProcessor.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    public static final String SOAP_ACTION = "SOAPAction";
    public static final String HASH = "Hash";
    public static final String LITERAL = "Literal";
    private static final String HASH_TYPE = CryptoUtils.isFips140_3Enabled() ? "SHA256" : "SHA";
    SAXParserFactory factory = null;
    SAXParser parser = null;
    SOAPRequestHandler soapHandler = null;
    MessageDigest md = null;

    private void newSAXParser() {
        block7: {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WSCP.newSAXParser()", (Object[])new Object[0]);
            }
            try {
                this.factory = ParserFactory.newSAXParserFactory();
                this.factory.setFeature("http://xml.org/sax/features/namespaces", true);
                this.parser = this.factory.newSAXParser();
                this.soapHandler = new SOAPRequestHandler();
            }
            catch (ParserConfigurationException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.config.WebServicesCacheProcessor.newSAXParser", (String)"44", (Object)((Object)this));
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"WSCP: ParserConfigurationException in newSAXParser()", (Object[])new Object[0]);
                }
            }
            catch (SAXNotRecognizedException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.config.WebServicesCacheProcessor.newSAXParser", (String)"47", (Object)((Object)this));
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"WSCP: SAXNotRecognizedException in newSAXParser()", (Object[])new Object[0]);
                }
            }
            catch (SAXException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.config.WebServicesCacheProcessor.newSAXParser", (String)"50", (Object)((Object)this));
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)"WSCP: SAXException in newSAXParser()", (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void reset(ConfigEntry ce) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WSCP.reset()", (Object[])new Object[0]);
        }
        if (this.soapHandler != null) {
            this.soapHandler.reset();
        }
        super.reset(ce);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object getComponentValue(Component c) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WSCP.getComponentValue(Component) for " + this.configEntry.name), (Object[])new Object[0]);
        }
        if (c == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WSCP.getComponentValue(): null component passed in, returning null.", (Object[])new Object[0]);
            }
            return null;
        }
        boolean setRequiredToTrue = true;
        DCache cache = ServerCache.getCache((String)this.configEntry.instanceName);
        if (cache != null) {
            setRequiredToTrue = cache.getCacheConfig().isWebservicesSetRequiredTrue();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WSCP.getComponentValue(): webservicesSetRequireTrue: " + setRequiredToTrue), (Object[])new Object[0]);
            }
        }
        switch (c.iType) {
            case 8: {
                if (setRequiredToTrue) {
                    c.required = true;
                }
                if (!this.request.getMethod().equals("POST")) {
                    return null;
                }
                if (c.values == null && c.notValues == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"WSCP.getComponentValue(): serviceOperation type component has neither value nor not-value, returning null.", (Object[])new Object[0]);
                    }
                    return null;
                }
                String serviceOperation = null;
                try {
                    if (this.parser == null) {
                        this.newSAXParser();
                    }
                    if (!this.soapHandler.isParsed()) {
                        this.request.setGeneratingId(true);
                        this.parser.parse((InputStream)this.request.getInputStream(), (DefaultHandler)this.soapHandler);
                        this.request.setGeneratingId(false);
                    }
                    serviceOperation = this.soapHandler.getServiceOperation();
                }
                catch (SAXException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cache.config.WebServicesCacheProcessor.getComponentValue", (String)"90", (Object)((Object)this));
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"WSCP: SAXException in getComponentValue(), returning null.", (Object[])new Object[0]);
                    }
                    return null;
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cache.config.WebServicesCacheProcessor.getComponentValue", (String)"94", (Object)((Object)this));
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"WSCP: IOException in getComponentValue(), returning null.", (Object[])new Object[0]);
                    }
                    return null;
                }
                return serviceOperation;
            }
            case 9: {
                if (setRequiredToTrue) {
                    c.required = true;
                }
                if (!this.request.getMethod().equals("POST")) {
                    return null;
                }
                if (c.values == null && c.notValues == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"WSCP.getComponentValue(): serviceOperationParameter type component has neither value nor not-value, returning null.", (Object[])new Object[0]);
                    }
                    return null;
                }
                String serviceParameter = null;
                try {
                    if (this.parser == null) {
                        this.newSAXParser();
                    }
                    if (!this.soapHandler.isParsed()) {
                        this.request.setGeneratingId(true);
                        this.parser.parse((InputStream)this.request.getInputStream(), (DefaultHandler)this.soapHandler);
                        this.request.setGeneratingId(false);
                    }
                    serviceParameter = (String)this.soapHandler.getServiceOperationParameter().get(c.id);
                }
                catch (SAXException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cache.config.WebServicesCacheProcessor.getComponentValue", (String)"121", (Object)((Object)this));
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"WSCP: SAXException in getComponentValue(), returning null.", (Object[])new Object[0]);
                    }
                    return null;
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cache.config.WebServicesCacheProcessor.getComponentValue", (String)"125", (Object)((Object)this));
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"WSCP: IOException in getComponentValue(), returning null.", (Object[])new Object[0]);
                    }
                    return null;
                }
                return serviceParameter;
            }
            case 7: {
                if (setRequiredToTrue) {
                    c.required = true;
                }
                if (c.values == null && c.notValues == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"WSCP.getComponentValue(): serviceOperation type component has neither value nor not-value, returning null.", (Object[])new Object[0]);
                    }
                    return null;
                }
                String soapAction = this.request.getHeader(SOAP_ACTION);
                if (soapAction != null && (soapAction = soapAction.trim()).startsWith("\"") && soapAction.endsWith("\"")) {
                    soapAction = soapAction.substring(1, soapAction.length() - 1);
                }
                return soapAction;
            }
            case 10: {
                Object var8_14;
                if (setRequiredToTrue) {
                    c.required = true;
                }
                if (!this.request.getMethod().equals("POST")) {
                    return null;
                }
                this.request.setGeneratingId(true);
                try {
                    int length;
                    byte[] buffer = new byte[1024];
                    ServletInputStream in = this.request.getInputStream();
                    ByteArrayOutputStream reqOS = new ByteArrayOutputStream();
                    while ((length = in.read(buffer)) != -1) {
                        reqOS.write(buffer, 0, length);
                    }
                    byte[] reqContent = reqOS.toByteArray();
                    if (c.id.equalsIgnoreCase(LITERAL)) {
                        String string = new String(reqContent);
                        return string;
                    }
                    if (this.md == null) {
                        this.md = MessageDigest.getInstance(HASH_TYPE);
                    }
                    byte[] reqHash = this.md.digest(reqContent);
                    String string = Base64Coder.encode((byte[])reqHash);
                    return string;
                }
                catch (NoSuchAlgorithmException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cache.config.WebServicesCacheProcessor.getComponentValue", (String)"175", (Object)((Object)this));
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"WSCP: NoSuchAlgorithmException in getComponentValue(), returning null.", (Object[])new Object[0]);
                    }
                    var8_14 = null;
                    return var8_14;
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cache.config.WebServicesCacheProcessor.getComponentValue", (String)"179", (Object)((Object)this));
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"WSCP: IOException in getComponentValue(), returning null.", (Object[])new Object[0]);
                    }
                    var8_14 = null;
                    return var8_14;
                }
                finally {
                    this.request.setGeneratingId(false);
                }
            }
        }
        return super.getComponentValue(c);
    }
}

