/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.event;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.audit.AuditEvent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.source.utils.AuditUtils;
import java.net.URLDecoder;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ApplicationPasswordTokenEvent
extends AuditEvent {
    private static final TraceComponent tc = Tr.register(ApplicationPasswordTokenEvent.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    static final long serialVersionUID = 4929468178943345605L;

    public ApplicationPasswordTokenEvent() {
        this.set("eventName", "APPLICATION_TOKEN_MANAGEMENT");
        this.setInitiator((Map)AuditEvent.STD_INITIATOR.clone());
        this.setObserver((Map)AuditEvent.STD_OBSERVER.clone());
        this.setTarget((Map)AuditEvent.STD_TARGET.clone());
        this.set("observer.name", "OidcSecurityService");
    }

    /*
     * WARNING - void declaration
     */
    public ApplicationPasswordTokenEvent(Map<String, Object> m) {
        block27: {
            this();
            try {
                String authResult;
                String sos;
                int index1;
                String endpoint;
                String sessionID;
                String agent;
                HttpServletRequest req = (HttpServletRequest)m.get("request");
                HttpServletResponse res = (HttpServletResponse)m.get("response");
                if (req != null && req.getRemoteAddr() != null) {
                    this.set("initiator.host.address", req.getRemoteAddr());
                }
                if ((agent = req.getHeader("User-Agent")) != null) {
                    this.set("initiator.host.agent", agent);
                }
                this.set("target.name", URLDecoder.decode(req.getRequestURI(), "UTF-8"));
                if (req.getQueryString() != null) {
                    String str = URLDecoder.decode(req.getQueryString(), "UTF-8");
                    str = AuditUtils.hidePassword(str);
                    this.set("target.params", str);
                }
                this.set("target.typeURI", "service/oidc");
                this.set("target.host.address", req.getLocalAddr() + ":" + req.getLocalPort());
                if (req.getUserPrincipal() != null && req.getUserPrincipal().getName() != null) {
                    this.set("target.credential.token", req.getUserPrincipal().getName());
                }
                if ((String)m.get("initiatorRole") != null) {
                    this.set("target.initiatorRole", m.get("initiatorRole"));
                }
                if ((sessionID = AuditUtils.getSessionID(req)) != null) {
                    this.set("target.session", sessionID);
                }
                if ((endpoint = (String)m.get("endpoint")) != null) {
                    this.set("target.endpoint", endpoint);
                    if ((String)m.get("appOrTokenId") != null) {
                        this.set("target.applicationId", m.get("appOrTokenId"));
                    }
                }
                if ((String)m.get("clientId") != null) {
                    this.set("target.clientId", m.get("clientId"));
                }
                if ((String)m.get("provider") != null) {
                    this.set("target.provider", m.get("provider"));
                }
                String user_id = "";
                if (req.getQueryString() != null) {
                    String queryString = URLDecoder.decode(req.getQueryString(), "UTF-8");
                    if (queryString != null && (index1 = queryString.indexOf("user_id=")) != -1) {
                        String queryString2 = queryString.substring(index1, queryString.length());
                        int index2 = queryString2.indexOf("&");
                        user_id = index2 != -1 && index2 != 8 ? queryString2.substring(8, index2) : (index2 != -1 && index2 == 8 ? "" : queryString2.substring(8, queryString2.length()));
                        this.set("target.userId", user_id);
                    }
                } else if ((String)m.get("user") != null) {
                    this.set("target.userId", m.get("user"));
                } else if (req.getUserPrincipal() != null && req.getUserPrincipal().getName() != null) {
                    this.set("target.userId", req.getUserPrincipal().getName());
                }
                if (req.getQueryString() != null) {
                    String str = URLDecoder.decode(req.getQueryString(), "UTF-8");
                    str = AuditUtils.hidePassword(str);
                    this.set("target.params", str);
                }
                this.set("target.method", AuditUtils.getRequestMethod(req));
                if (AuditUtils.getRequestMethod(req).equals("POST") && endpoint != null && (sos = (String)m.get("respBody")) != null && sos.indexOf("app_id") != -1) {
                    index1 = sos.indexOf("app_id");
                    int index2 = sos.indexOf("created_at");
                    if (index2 != -1) {
                        String s1 = sos.substring(index1 + 9, index2 - 3);
                        this.set("target.applicationId", s1);
                    }
                }
                if (AuditUtils.getRequestMethod(req).equals("DELETE")) {
                    this.set("target.numberRevoked", m.get("numberRevoked"));
                }
                if ((authResult = (String)m.get("auditOutcome")).equals("success")) {
                    this.setOutcome("success");
                    this.set("reason.reasonCode", res.getStatus());
                    this.set("reason.reasonType", AuditUtils.getRequestScheme(req));
                } else if (authResult.equals("failure")) {
                    this.setOutcome("failure");
                    this.set("reason.reasonCode", res.getStatus());
                    String detailedError = (String)m.get("detaileError");
                    if (detailedError != null) {
                        this.set("reason.reasonType", AuditUtils.getRequestScheme(req).concat(": ").concat(detailedError));
                    } else {
                        this.set("reason.reasonType", AuditUtils.getRequestScheme(req));
                    }
                }
            }
            catch (Exception req) {
                void e;
                FFDCFilter.processException((Throwable)req, (String)"com.ibm.ws.security.audit.event.ApplicationPasswordTokenEvent", (String)"168", (Object)((Object)this), (Object[])new Object[]{m});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block27;
                Tr.debug((TraceComponent)tc, (String)"Internal error creating ApplicationPasswordTokenEvent", (Object[])new Object[]{e});
            }
        }
    }
}

