/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.graphql.authorization.component;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Principal;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AuthorizationFilter
extends HttpFilter {
    private static final long serialVersionUID = 82334983658392003L;
    private static final TraceComponent tc = Tr.register(AuthorizationFilter.class, (String)"GraphQL", null);
    private static final AuthorizationFilter INSTANCE = new AuthorizationFilter();
    private static final ThreadLocal<HttpServletRequest> tlRequest = new ThreadLocal();
    private static final ThreadLocal<HttpServletResponse> tlResponse = new ThreadLocal();

    static AuthorizationFilter getInstance() {
        return INSTANCE;
    }

    private AuthorizationFilter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilter(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        try {
            tlRequest.set(req);
            tlResponse.set(res);
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
        }
        finally {
            tlRequest.remove();
            tlResponse.remove();
        }
    }

    boolean authenticate() throws IOException, ServletException {
        return this.getRequest().authenticate(this.getResponse());
    }

    Principal getUserPrincipal() {
        return this.getRequest().getUserPrincipal();
    }

    boolean isUserInRole(String role) {
        return this.getRequest().isUserInRole(role);
    }

    private HttpServletRequest getRequest() {
        HttpServletRequest req = tlRequest.get();
        if (req == null) {
            throw new IllegalStateException("Not in the context of a servlet request");
        }
        return req;
    }

    private HttpServletResponse getResponse() {
        HttpServletResponse res = tlResponse.get();
        if (res == null) {
            throw new IllegalStateException("Not in the context of a servlet request");
        }
        return res;
    }
}

