/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ui.internal.rest;

import com.ibm.websphere.jsonsupport.JSON;
import com.ibm.websphere.jsonsupport.JSONMarshallException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ui.internal.Filter;
import com.ibm.ws.ui.internal.RequestNLS;
import com.ibm.ws.ui.internal.rest.AdminCenterRestHandler;
import com.ibm.ws.ui.internal.rest.CommonRESTHandler;
import com.ibm.ws.ui.internal.rest.exceptions.BadRequestException;
import com.ibm.ws.ui.internal.rest.exceptions.MediaTypeNotSupportedException;
import com.ibm.ws.ui.internal.rest.exceptions.MethodNotSupportedException;
import com.ibm.ws.ui.internal.rest.exceptions.RESTException;
import com.ibm.ws.ui.internal.v1.pojo.Message;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public abstract class CommonJSONRESTHandler
extends CommonRESTHandler {
    private static final TraceComponent tc = Tr.register(CommonJSONRESTHandler.class);

    protected CommonJSONRESTHandler(String handlerURL, boolean handlesChildResource, boolean handlesGrandchildResource) {
        super(handlerURL, handlesChildResource, handlesGrandchildResource, new Filter(), null);
    }

    protected CommonJSONRESTHandler(String handlerURL, boolean handlesChildResource, boolean handlesGrandchildResource, Filter filter, JSON json) {
        super(handlerURL, handlesChildResource, handlesGrandchildResource, filter, json);
    }

    private void checkMediaTypeIsJson(RESTRequest request) throws MediaTypeNotSupportedException {
        String requestContentType = request.getHeader("Content-Type");
        if (requestContentType == null || requestContentType.indexOf("application/json") < 0) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Inbound Content-Type is not the required application/json rather it is " + requestContentType), (Object[])new Object[0]);
            }
            throw new MediaTypeNotSupportedException();
        }
    }

    @Override
    protected void delegateMethod(RESTRequest request, RESTResponse response) throws RESTException {
        String method = request.getMethod();
        if ("GET".equals(method)) {
            this.setJSONResponse(response, this.doGET(request, response), 200);
        } else if ("POST".equals(method)) {
            this.checkMediaTypeIsJson(request);
            AdminCenterRestHandler.POSTResponse pr = this.doPOST(request, response);
            response.setResponseHeader("Location", pr.createdURL);
            this.setJSONResponse(response, pr.jsonPayload, 201);
        } else if ("PUT".equals(method)) {
            this.checkMediaTypeIsJson(request);
            this.setJSONResponse(response, this.doPUT(request, response), 200);
        } else if ("DELETE".equals(method)) {
            this.setJSONResponse(response, this.doDELETE(request, response), 200);
        } else {
            throw new MethodNotSupportedException();
        }
    }

    protected final Object applyFilter(RESTRequest request, Object obj) throws RESTException {
        try {
            return this.filter.applyFieldFilter(request.getParameter("fields"), obj);
        }
        catch (Exception e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Unexpected Exception caught while applying filter to JSON Object", (Object[])new Object[]{e});
            }
            throw new RESTException(500);
        }
    }

    protected final <T> T readJSONPayload(RESTRequest request, Class<T> expectedType) throws RESTException {
        ArrayList<Class<T>> types = new ArrayList<Class<T>>();
        types.add(expectedType);
        return this.readJSONPayload(request, expectedType, types);
    }

    @Trivial
    private final <T> String getSupportedTypes(List<Class<? extends T>> types) {
        StringBuilder sb = new StringBuilder();
        for (Class<T> type : types) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(type.getCanonicalName());
        }
        return sb.toString();
    }

    @FFDCIgnore(value={EOFException.class, JSONMarshallException.class})
    protected final <T> T readJSONPayload(RESTRequest request, Class<T> superClass, List<Class<? extends T>> concreteTypes) throws RESTException {
        try {
            String readerContents = this.getReaderContents(request.getInputStream(), 8192);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attempting to parse RESTRequest POST payload as JSON", (Object[])new Object[]{readerContents});
            }
            JSON jsonService = this.getJSONService();
            for (Class<T> clazz : concreteTypes) {
                try {
                    return (T)jsonService.parse(readerContents, clazz);
                }
                catch (JSONMarshallException e) {
                    if (e.getMessage() != null && e.getMessage().equals("Unable to parse non-well-formed content")) {
                        throw e;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"Possibly expected JSONMarshallException while interpreting payload", (Object[])new Object[]{e});
                }
            }
            Message error = new Message(400, RequestNLS.formatMessage(tc, "POST_WRONG_JSON_PAYLOAD", this.getSupportedTypes(concreteTypes)));
            throw new BadRequestException("application/json; charset=UTF-8", error);
        }
        catch (EOFException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Encountered EOFException while reading RESTRequest payload", (Object[])new Object[]{e});
            }
            Message error = new Message(400, RequestNLS.formatMessage(tc, "POST_REQUIRES_JSON_PAYLOAD", this.getSupportedTypes(concreteTypes)));
            throw new BadRequestException("application/json; charset=UTF-8", error);
        }
        catch (JSONMarshallException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Encountered JSONMarshallException while reading RESTRequest payload", (Object[])new Object[]{e});
            }
            Message error = new Message(400, RequestNLS.formatMessage(tc, "POST_BAD_JSON_PAYLOAD", this.getSupportedTypes(concreteTypes)));
            throw new BadRequestException("application/json; charset=UTF-8", error);
        }
        catch (IOException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unexpected IOException while reading RESTRequest payload", (Object[])new Object[]{e});
            }
            throw new RESTException(500);
        }
    }

    @Override
    protected final void handleRESTException(RESTResponse response, RESTException e) throws IOException {
        if (e.getPayload() != null) {
            String contentType = e.getContentType();
            if ("text/plain".equals(contentType)) {
                response.setStatus(e.getStatus());
                response.setResponseHeader("Content-Type", e.getContentType());
                response.getOutputStream().write(e.getPayload().toString().getBytes(StandardCharsets.UTF_8));
            } else if (contentType != null && contentType.indexOf("application/json") > -1) {
                this.setJSONResponse(response, e.getPayload(), e.getStatus());
            } else {
                response.setStatus(500);
                response.setResponseHeader("Content-Type", "text/plain");
                response.getOutputStream().write("An internal error occurred. RESTException had a set payload but did not specify content type".getBytes(StandardCharsets.UTF_8));
            }
        } else {
            response.setStatus(e.getStatus());
        }
    }

    @Override
    @Trivial
    protected final String getReaderContents(InputStream input, int maxSize) throws IOException, BadRequestException {
        try {
            return super.getReaderContents(input, maxSize);
        }
        catch (BadRequestException e) {
            throw new BadRequestException("application/json; charset=UTF-8", e.getPayload());
        }
    }
}

