/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.sender.okhttp.internal;

import io.opentelemetry.exporter.internal.compression.Compressor;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.OutputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;

public final class GrpcRequestBody
extends RequestBody {
    private static final int HEADER_LENGTH = 5;
    private static final byte UNCOMPRESSED_FLAG = 0;
    private static final byte COMPRESSED_FLAG = 1;
    private static final MediaType GRPC_MEDIA_TYPE = MediaType.parse((String)"application/grpc");
    private final Marshaler marshaler;
    private final int messageSize;
    private final int contentLength;
    @Nullable
    private final Compressor compressor;

    public GrpcRequestBody(Marshaler marshaler, @Nullable Compressor compressor) {
        this.marshaler = marshaler;
        this.compressor = compressor;
        this.messageSize = marshaler.getBinarySerializedSize();
        this.contentLength = compressor != null ? -1 : 5 + this.messageSize;
    }

    @Nullable
    public MediaType contentType() {
        return GRPC_MEDIA_TYPE;
    }

    public long contentLength() {
        return this.contentLength;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        if (this.compressor == null) {
            sink.writeByte(0);
            sink.writeInt(this.messageSize);
            this.marshaler.writeBinaryTo(sink.outputStream());
        } else {
            try (Buffer compressedBody = new Buffer();){
                try (BufferedSink compressedSink = Okio.buffer((Sink)Okio.sink((OutputStream)this.compressor.compress(compressedBody.outputStream())));){
                    this.marshaler.writeBinaryTo(compressedSink.outputStream());
                }
                sink.writeByte(1);
                int compressedBytes = (int)compressedBody.size();
                sink.writeInt(compressedBytes);
                sink.write(compressedBody, (long)compressedBytes);
            }
        }
    }
}

