/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.logic;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.Predicate;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.ParentProfileRequestContextLookup;

public class MessageContextPredicateAdapter
implements net.shibboleth.utilities.java.support.logic.Predicate<MessageContext> {
    @Nonnull
    private static final ParentProfileRequestContextLookup<MessageContext> PRC_LOOKUP = new ParentProfileRequestContextLookup();
    @Nonnull
    private Predicate<ProfileRequestContext> adapted;
    private boolean noPRCSatisfies;

    public MessageContextPredicateAdapter(@Nonnull @ParameterName(name="prcPredicate") Predicate<ProfileRequestContext> prcPredicate) {
        this(prcPredicate, false);
    }

    public MessageContextPredicateAdapter(@Nonnull @ParameterName(name="prcPredicate") Predicate<ProfileRequestContext> prcPredicate, @ParameterName(name="unresolvedSatisfies") boolean unresolvedSatisfies) {
        this.adapted = (Predicate)Constraint.isNotNull(prcPredicate, (String)"The adapted predicate may not be null");
        this.noPRCSatisfies = unresolvedSatisfies;
    }

    public boolean test(@Nullable MessageContext input) {
        if (input == null) {
            return false;
        }
        ProfileRequestContext prc = (ProfileRequestContext)PRC_LOOKUP.apply((BaseContext)input);
        if (prc == null) {
            return this.noPRCSatisfies;
        }
        return this.adapted.test(prc);
    }
}

