/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.criteria.role.impl;

import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.metadata.criteria.role.EvaluableRoleDescriptorCriterion;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;

public class EvaluableProtocolRoleDescriptorCriterion
implements EvaluableRoleDescriptorCriterion {
    @Nonnull
    @NotEmpty
    private String protocol;

    public EvaluableProtocolRoleDescriptorCriterion(@Nonnull ProtocolCriterion criterion) {
        Constraint.isNotNull((Object)criterion, (String)"ProtocolCriterion was null");
        this.protocol = (String)Constraint.isNotNull((Object)criterion.getProtocol(), (String)"Criterion protocol was null");
    }

    public EvaluableProtocolRoleDescriptorCriterion(@Nonnull String roleProtocol) {
        this.protocol = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)roleProtocol), (String)"Entity Role protocol was null or empty");
    }

    @Override
    public boolean test(RoleDescriptor input) {
        if (input == null) {
            return false;
        }
        return input.isSupportedProtocol(this.protocol);
    }

    public int hashCode() {
        return this.protocol.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof EvaluableProtocolRoleDescriptorCriterion) {
            return Objects.equals(this.protocol, ((EvaluableProtocolRoleDescriptorCriterion)other).protocol);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("protocol", (Object)this.protocol).toString();
    }
}

