/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Timer;
import java.util.TimerTask;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.TimerSupport;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.metadata.resolver.RefreshableMetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.impl.AbstractBatchMetadataResolver;
import org.opensaml.saml.saml2.common.SAML2Support;
import org.opensaml.saml.saml2.common.TimeBoundSAMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public abstract class AbstractReloadingMetadataResolver
extends AbstractBatchMetadataResolver
implements RefreshableMetadataResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractReloadingMetadataResolver.class);
    private Timer taskTimer;
    private boolean createdOwnTaskTimer;
    private RefreshMetadataTask refreshMetadataTask;
    private float refreshDelayFactor = 0.75f;
    @Nonnull
    private Duration maxRefreshDelay;
    @Nonnull
    private Duration minRefreshDelay;
    @Nullable
    private Instant expirationTime;
    @Nonnull
    private Duration expirationWarningThreshold;
    @Nullable
    private Instant lastUpdate;
    @Nullable
    private Instant lastRefresh;
    @Nullable
    private Instant nextRefresh;
    @Nullable
    private Instant lastSuccessfulRefresh;
    @Nullable
    private Boolean wasLastRefreshSuccess;
    private boolean trackRefreshSuccess;
    @Nullable
    private Throwable lastFailureCause;

    protected AbstractReloadingMetadataResolver() {
        this(null);
    }

    protected AbstractReloadingMetadataResolver(@Nullable Timer backgroundTaskTimer) {
        this.setCacheSourceMetadata(true);
        this.minRefreshDelay = Duration.ofMinutes(5L);
        this.maxRefreshDelay = Duration.ofHours(4L);
        this.expirationWarningThreshold = Duration.ZERO;
        if (backgroundTaskTimer == null) {
            this.taskTimer = new Timer(TimerSupport.getTimerName((Object)this), true);
            this.createdOwnTaskTimer = true;
        } else {
            this.taskTimer = backgroundTaskTimer;
        }
    }

    @Override
    protected void setCacheSourceMetadata(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        if (!flag) {
            this.log.warn("{} Caching of source metadata may not be disabled for reloading metadata resolvers", (Object)this.getLogPrefix());
        } else {
            super.setCacheSourceMetadata(flag);
        }
    }

    public Instant getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    @Nullable
    public Instant getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    @Nullable
    public Instant getLastRefresh() {
        return this.lastRefresh;
    }

    @Override
    @Nullable
    public Instant getLastSuccessfulRefresh() {
        return this.lastSuccessfulRefresh;
    }

    @Override
    @Nullable
    public Boolean wasLastRefreshSuccess() {
        return this.wasLastRefreshSuccess;
    }

    @Override
    @Nullable
    public Throwable getLastFailureCause() {
        return this.lastFailureCause;
    }

    public Instant getNextRefresh() {
        return this.nextRefresh;
    }

    @Nonnull
    public Duration getExpirationWarningThreshold() {
        return this.expirationWarningThreshold;
    }

    public void setExpirationWarningThreshold(@Nonnull Duration threshold) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Constraint.isNotNull((Object)threshold, (String)"Expiration warning threshold cannot be null");
        Constraint.isFalse((boolean)threshold.isNegative(), (String)"Expiration warning threshold cannot be negative");
        this.expirationWarningThreshold = threshold;
    }

    @Nonnull
    public Duration getMaxRefreshDelay() {
        return this.maxRefreshDelay;
    }

    public void setMaxRefreshDelay(@Nonnull Duration delay) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Constraint.isNotNull((Object)delay, (String)"Maximum refresh delay cannot be null");
        Constraint.isFalse((delay.isNegative() || delay.isZero() ? 1 : 0) != 0, (String)"Maximum refresh delay must be greater than 0");
        this.maxRefreshDelay = delay;
    }

    public float getRefreshDelayFactor() {
        return this.refreshDelayFactor;
    }

    public void setRefreshDelayFactor(float factor) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        if (factor <= 0.0f || factor >= 1.0f) {
            throw new IllegalArgumentException("Refresh delay factor must be a number between 0.0 and 1.0, exclusive");
        }
        this.refreshDelayFactor = factor;
    }

    @Nonnull
    public Duration getMinRefreshDelay() {
        return this.minRefreshDelay;
    }

    public void setMinRefreshDelay(@Nonnull Duration delay) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Constraint.isNotNull((Object)delay, (String)"Minimum refresh delay cannot be null");
        Constraint.isFalse((delay.isNegative() || delay.isZero() ? 1 : 0) != 0, (String)"Minimum refresh delay must be greater than 0");
        this.minRefreshDelay = delay;
    }

    @Override
    protected void doDestroy() {
        this.refreshMetadataTask.cancel();
        if (this.createdOwnTaskTimer) {
            this.taskTimer.cancel();
        }
        this.expirationTime = null;
        this.lastRefresh = null;
        this.lastUpdate = null;
        this.nextRefresh = null;
        this.wasLastRefreshSuccess = null;
        this.lastSuccessfulRefresh = null;
        this.lastFailureCause = null;
        super.doDestroy();
    }

    @Override
    protected void initMetadataResolver() throws ComponentInitializationException {
        super.initMetadataResolver();
        try {
            this.refresh();
        }
        catch (ResolverException e) {
            throw new ComponentInitializationException("Error refreshing metadata during init", (Exception)((Object)e));
        }
        if (this.minRefreshDelay.compareTo(this.maxRefreshDelay) > 0) {
            throw new ComponentInitializationException("Minimum refresh delay " + this.minRefreshDelay + " is greater than maximum refresh delay " + this.maxRefreshDelay);
        }
    }

    @Override
    public synchronized void refresh() throws ResolverException {
        String mdId;
        Instant now;
        block15: {
            block13: {
                block11: {
                    block14: {
                        block12: {
                            now = null;
                            mdId = null;
                            this.trackRefreshSuccess = false;
                            if (!this.isDestroyed()) break block11;
                            this.logCachedMetadataExpiration(now);
                            if (!this.trackRefreshSuccess) break block12;
                            this.wasLastRefreshSuccess = true;
                            this.lastSuccessfulRefresh = now;
                            this.lastFailureCause = null;
                            break block14;
                        }
                        this.wasLastRefreshSuccess = false;
                    }
                    this.refreshMetadataTask = new RefreshMetadataTask();
                    long nextRefreshDelay = this.nextRefresh.toEpochMilli() - System.currentTimeMillis();
                    this.taskTimer.schedule((TimerTask)this.refreshMetadataTask, nextRefreshDelay);
                    this.log.info("{} Next refresh cycle for metadata provider '{}' will occur on '{}' ('{}' local time)", new Object[]{this.getLogPrefix(), mdId, this.nextRefresh, this.nextRefresh.atZone(ZoneId.systemDefault())});
                    this.lastRefresh = now;
                    return;
                }
                try {
                    if (this.refreshMetadataTask != null) {
                        this.refreshMetadataTask.cancel();
                    }
                    now = Instant.now();
                    mdId = this.getMetadataIdentifier();
                    this.log.debug("{} Beginning refresh of metadata from '{}'", (Object)this.getLogPrefix(), (Object)mdId);
                    byte[] mdBytes = this.fetchMetadata();
                    if (mdBytes == null) {
                        this.log.info("{} Metadata from '{}' has not changed since last refresh", (Object)this.getLogPrefix(), (Object)mdId);
                        this.processCachedMetadata(mdId, now);
                    } else {
                        this.log.debug("{} Processing new metadata from '{}'", (Object)this.getLogPrefix(), (Object)mdId);
                        this.processNewMetadata(mdId, now, mdBytes);
                    }
                    this.logCachedMetadataExpiration(now);
                    if (!this.trackRefreshSuccess) break block13;
                }
                catch (Throwable t) {
                    try {
                        this.trackRefreshSuccess = false;
                        this.lastFailureCause = t;
                        this.nextRefresh = Instant.now().plus(this.computeNextRefreshDelay(null));
                        this.log.error("{} Error occurred while attempting to refresh metadata from '{}'", new Object[]{this.getLogPrefix(), mdId, t});
                        if (t instanceof Exception) {
                            throw new ResolverException("Exception during refresh", (Exception)t);
                        }
                        throw new ResolverException(String.format("Saw an error of type '%s' with message '%s'", t.getClass().getName(), t.getMessage()));
                    }
                    catch (Throwable throwable) {
                        this.logCachedMetadataExpiration(now);
                        if (this.trackRefreshSuccess) {
                            this.wasLastRefreshSuccess = true;
                            this.lastSuccessfulRefresh = now;
                            this.lastFailureCause = null;
                        } else {
                            this.wasLastRefreshSuccess = false;
                        }
                        this.refreshMetadataTask = new RefreshMetadataTask();
                        long nextRefreshDelay = this.nextRefresh.toEpochMilli() - System.currentTimeMillis();
                        this.taskTimer.schedule((TimerTask)this.refreshMetadataTask, nextRefreshDelay);
                        this.log.info("{} Next refresh cycle for metadata provider '{}' will occur on '{}' ('{}' local time)", new Object[]{this.getLogPrefix(), mdId, this.nextRefresh, this.nextRefresh.atZone(ZoneId.systemDefault())});
                        this.lastRefresh = now;
                        throw throwable;
                    }
                }
                this.wasLastRefreshSuccess = true;
                this.lastSuccessfulRefresh = now;
                this.lastFailureCause = null;
                break block15;
            }
            this.wasLastRefreshSuccess = false;
        }
        this.refreshMetadataTask = new RefreshMetadataTask();
        long nextRefreshDelay = this.nextRefresh.toEpochMilli() - System.currentTimeMillis();
        this.taskTimer.schedule((TimerTask)this.refreshMetadataTask, nextRefreshDelay);
        this.log.info("{} Next refresh cycle for metadata provider '{}' will occur on '{}' ('{}' local time)", new Object[]{this.getLogPrefix(), mdId, this.nextRefresh, this.nextRefresh.atZone(ZoneId.systemDefault())});
        this.lastRefresh = now;
    }

    private void logCachedMetadataExpiration(@Nonnull Instant now) {
        String mdId = this.getMetadataIdentifier();
        XMLObject cached = this.getBackingStore().getCachedOriginalMetadata();
        if (cached != null && !this.isValid(cached)) {
            this.log.warn("{} Metadata root from '{}' currently live (post-refresh) is expired or otherwise invalid", (Object)this.getLogPrefix(), (Object)mdId);
        } else if (cached instanceof TimeBoundSAMLObject) {
            TimeBoundSAMLObject timebound = (TimeBoundSAMLObject)cached;
            if (this.isRequireValidMetadata() && timebound.getValidUntil() != null) {
                if (!this.getExpirationWarningThreshold().isZero() && timebound.getValidUntil().isBefore(now.plus(this.getExpirationWarningThreshold()))) {
                    this.log.warn("{} Metadata root from '{}' currently live (post-refresh) will expire within the configured threshhold at '{}'", new Object[]{this.getLogPrefix(), mdId, timebound.getValidUntil()});
                } else if (timebound.getValidUntil().isBefore(this.nextRefresh)) {
                    this.log.warn("{} Metadata root from '{}' currently live (post-refresh) will expire at '{}' before the next refresh scheduled for {}'", new Object[]{this.getLogPrefix(), mdId, timebound.getValidUntil(), this.nextRefresh});
                }
            }
        }
    }

    protected abstract String getMetadataIdentifier();

    protected abstract byte[] fetchMetadata() throws ResolverException;

    protected XMLObject unmarshallMetadata(byte[] metadataBytes) throws ResolverException {
        try {
            return this.unmarshallMetadata(new ByteArrayInputStream(metadataBytes));
        }
        catch (UnmarshallingException e) {
            String errorMsg = "Unable to unmarshall metadata";
            this.log.error("{} {}: {}", new Object[]{this.getLogPrefix(), "Unable to unmarshall metadata", e.getMessage()});
            throw new ResolverException("Unable to unmarshall metadata", (Exception)e);
        }
    }

    protected void processCachedMetadata(String metadataIdentifier, Instant refreshStart) throws ResolverException {
        this.log.debug("{} Computing new expiration time for cached metadata from '{}'", (Object)this.getLogPrefix(), (Object)metadataIdentifier);
        Instant metadataExpirationTime = SAML2Support.getEarliestExpiration(this.getBackingStore().getCachedOriginalMetadata(), refreshStart.plus(this.getMaxRefreshDelay()), refreshStart);
        this.trackRefreshSuccess = true;
        this.expirationTime = metadataExpirationTime;
        this.nextRefresh = Instant.now().plus(this.computeNextRefreshDelay(this.expirationTime));
    }

    protected void processNewMetadata(String metadataIdentifier, Instant refreshStart, byte[] metadataBytes) throws ResolverException {
        this.log.debug("{} Unmarshalling metadata from '{}'", (Object)this.getLogPrefix(), (Object)metadataIdentifier);
        XMLObject metadata = this.unmarshallMetadata(metadataBytes);
        if (!this.isValid(metadata)) {
            this.processPreExpiredMetadata(metadataIdentifier, refreshStart, metadataBytes, metadata);
        } else {
            this.processNonExpiredMetadata(metadataIdentifier, refreshStart, metadataBytes, metadata);
        }
    }

    protected void processPreExpiredMetadata(String metadataIdentifier, Instant refreshStart, byte[] metadataBytes, XMLObject metadata) {
        this.log.warn("{} Entire metadata document from '{}' was expired at time of loading, previous metadata retained, if any", (Object)this.getLogPrefix(), (Object)metadataIdentifier);
        this.nextRefresh = Instant.now().plus(this.computeNextRefreshDelay(null));
        this.trackRefreshSuccess = false;
        this.lastFailureCause = new ResolverException("Entire metadata document was already expired at time of loading");
    }

    protected void processNonExpiredMetadata(String metadataIdentifier, Instant refreshStart, byte[] metadataBytes, XMLObject metadata) throws ResolverException {
        Duration nextRefreshDelay;
        Document metadataDom = metadata.getDOM().getOwnerDocument();
        this.log.debug("{} Preprocessing metadata from '{}'", (Object)this.getLogPrefix(), (Object)metadataIdentifier);
        AbstractBatchMetadataResolver.BatchEntityBackingStore newBackingStore = null;
        try {
            newBackingStore = this.preProcessNewMetadata(metadata);
        }
        catch (FilterException e) {
            String errMsg = "Error filtering metadata from " + metadataIdentifier;
            this.log.error("{} {}: {}", new Object[]{this.getLogPrefix(), errMsg, e.getMessage()});
            throw new ResolverException(errMsg, (Exception)e);
        }
        this.log.debug("{} Releasing cached DOM for metadata from '{}'", (Object)this.getLogPrefix(), (Object)metadataIdentifier);
        this.releaseMetadataDOM(newBackingStore.getCachedOriginalMetadata());
        this.releaseMetadataDOM(newBackingStore.getCachedFilteredMetadata());
        this.log.debug("{} Post-processing metadata from '{}'", (Object)this.getLogPrefix(), (Object)metadataIdentifier);
        this.postProcessMetadata(metadataBytes, metadataDom, newBackingStore.getCachedOriginalMetadata(), newBackingStore.getCachedFilteredMetadata());
        this.log.debug("{} Computing expiration time for metadata from '{}'", (Object)this.getLogPrefix(), (Object)metadataIdentifier);
        Instant metadataExpirationTime = SAML2Support.getEarliestExpiration(newBackingStore.getCachedOriginalMetadata(), refreshStart.plus(this.getMaxRefreshDelay()), refreshStart);
        this.log.debug("{} Expiration of metadata from '{}' will occur at {}", new Object[]{this.getLogPrefix(), metadataIdentifier, metadataExpirationTime.toString()});
        this.setBackingStore(newBackingStore);
        this.lastUpdate = refreshStart;
        this.trackRefreshSuccess = true;
        Instant now = Instant.now();
        if (metadataExpirationTime.isBefore(now)) {
            this.expirationTime = now.plus(this.getMinRefreshDelay());
            nextRefreshDelay = this.getMaxRefreshDelay();
        } else {
            this.expirationTime = metadataExpirationTime;
            nextRefreshDelay = this.computeNextRefreshDelay(this.expirationTime);
        }
        this.nextRefresh = now.plus(nextRefreshDelay);
        this.log.info("{} New metadata successfully loaded for '{}'", (Object)this.getLogPrefix(), (Object)this.getMetadataIdentifier());
    }

    protected void postProcessMetadata(byte[] metadataBytes, Document metadataDom, XMLObject originalMetadata, XMLObject filteredMetadata) throws ResolverException {
    }

    @Nonnull
    protected Duration computeNextRefreshDelay(Instant expectedExpiration) {
        long refreshDelay;
        long now = System.currentTimeMillis();
        long expireInstant = 0L;
        if (expectedExpiration != null) {
            expireInstant = expectedExpiration.toEpochMilli();
        }
        if ((refreshDelay = (long)((float)(expireInstant - now) * this.getRefreshDelayFactor())) < this.getMinRefreshDelay().toMillis()) {
            refreshDelay = this.getMinRefreshDelay().toMillis();
        }
        return Duration.ofMillis(refreshDelay);
    }

    protected byte[] inputstreamToByteArray(InputStream ins) throws ResolverException {
        try {
            byte[] buffer = new byte[0x100000];
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            int n = 0;
            while (-1 != (n = ins.read(buffer))) {
                output.write(buffer, 0, n);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new ResolverException((Exception)e);
        }
        finally {
            try {
                ins.close();
            }
            catch (IOException iOException) {}
        }
    }

    private class RefreshMetadataTask
    extends TimerTask {
        private RefreshMetadataTask() {
        }

        @Override
        public void run() {
            try {
                if (AbstractReloadingMetadataResolver.this.isDestroyed()) {
                    return;
                }
                AbstractReloadingMetadataResolver.this.refresh();
            }
            catch (ResolverException e) {
                return;
            }
        }
    }
}

