/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.ProxyRestriction;

public class ProxyRestrictionImpl
extends AbstractXMLObject
implements ProxyRestriction {
    @Nonnull
    private final XMLObjectChildrenList<Audience> audiences = new XMLObjectChildrenList(this);
    @Nullable
    private Integer proxyCount;

    protected ProxyRestrictionImpl(@Nullable @NotEmpty String namespaceURI, @Nonnull @NotEmpty String elementLocalName, @Nullable @NotEmpty String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Override
    @Nullable
    public List<Audience> getAudiences() {
        return this.audiences;
    }

    @Override
    @Nullable
    public Integer getProxyCount() {
        return this.proxyCount;
    }

    @Override
    public void setProxyCount(@Nullable Integer newProxyCount) {
        if (newProxyCount != null && newProxyCount < 0) {
            throw new IllegalArgumentException("Count must be a non-negative integer.");
        }
        this.proxyCount = this.prepareForAssignment(this.proxyCount, newProxyCount);
    }

    @Override
    public List<XMLObject> getOrderedChildren() {
        ArrayList<Audience> children = new ArrayList<Audience>();
        children.addAll(this.audiences);
        return Collections.unmodifiableList(children);
    }
}

