/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.soap11.profile.impl;

import com.google.common.base.Predicates;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.context.EventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.CurrentOrPreviousEventLookup;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.soap11.Fault;
import org.opensaml.soap.soap11.FaultCode;
import org.opensaml.soap.soap11.FaultString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddSOAPFault
extends AbstractProfileAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AddSOAPFault.class);
    @Nullable
    private Function<ProfileRequestContext, Fault> contextFaultStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> detailedErrorsCondition = Predicates.alwaysFalse();
    @Nullable
    private Function<ProfileRequestContext, QName> faultCodeLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, String> faultStringLookupStrategy;
    @Nonnull
    @NonnullElements
    private QName defaultFaultCode = FaultCode.SERVER;
    @Nullable
    private String faultString;
    private boolean detailedErrors = false;
    private boolean nullifyOutboundMessage = true;

    public AddSOAPFault() {
        this.contextFaultStrategy = new MessageContextFaultStrategy();
    }

    public void setNullifyOutboundMessage(boolean flag) {
        this.nullifyOutboundMessage = flag;
    }

    public void setContextFaultStrategy(@Nullable Function<ProfileRequestContext, Fault> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.contextFaultStrategy = strategy;
    }

    public void setDetailedErrorsCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.detailedErrorsCondition = (Predicate)Constraint.isNotNull(condition, (String)"Detailed errors condition cannot be null");
    }

    public void setFaultCodeLookupStrategy(@Nullable Function<ProfileRequestContext, QName> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.faultCodeLookupStrategy = strategy;
    }

    public void setFaultStringLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.faultStringLookupStrategy = strategy;
    }

    public void setFaultCode(@Nonnull QName code) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.defaultFaultCode = (QName)Constraint.isNotNull((Object)code, (String)"Faultcode cannot be null");
    }

    public void setFaultString(@Nullable String message) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.faultString = StringSupport.trimOrNull((String)message);
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        this.detailedErrors = this.detailedErrorsCondition.test(profileRequestContext);
        this.log.debug("{} Detailed errors are {}", (Object)this.getLogPrefix(), (Object)(this.detailedErrors ? "enabled" : "disabled"));
        if (profileRequestContext.getOutboundMessageContext() != null && this.nullifyOutboundMessage) {
            profileRequestContext.getOutboundMessageContext().setMessage(null);
        } else {
            profileRequestContext.setOutboundMessageContext(new MessageContext());
        }
        return super.doPreExecute(profileRequestContext);
    }

    @Override
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Fault fault = this.resolveContextFault(profileRequestContext);
        if (fault == null) {
            fault = this.buildNewMappedFault(profileRequestContext);
        }
        SOAPMessagingSupport.registerSOAP11Fault(profileRequestContext.getOutboundMessageContext(), fault);
    }

    @Nullable
    private Fault resolveContextFault(ProfileRequestContext profileRequestContext) {
        if (this.contextFaultStrategy == null) {
            return null;
        }
        Fault fault = this.contextFaultStrategy.apply(profileRequestContext);
        if (fault != null) {
            this.log.debug("{} Resolved Fault instance via context strategy", (Object)this.getLogPrefix());
            if (fault.getCode() == null) {
                this.log.debug("{} Resolved Fault contained no FaultCode, using configured default", (Object)this.getLogPrefix());
                XMLObjectBuilder faultCodeBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(FaultCode.DEFAULT_ELEMENT_NAME);
                FaultCode code = (FaultCode)faultCodeBuilder.buildObject(FaultCode.DEFAULT_ELEMENT_NAME);
                code.setValue(this.defaultFaultCode);
                fault.setCode(code);
            }
            if (!this.detailedErrors) {
                this.log.debug("{} Removing any detailed error info from context Fault instance", (Object)this.getLogPrefix());
                if (this.faultString != null) {
                    this.buildFaultString(fault, this.faultString);
                } else {
                    fault.setMessage(null);
                }
                fault.setDetail(null);
                fault.setActor(null);
            }
        } else {
            this.log.debug("{} Failed to resolve any Fault instance via context strategy", (Object)this.getLogPrefix());
        }
        return fault;
    }

    @Nonnull
    private Fault buildNewMappedFault(ProfileRequestContext profileRequestContext) {
        XMLObjectBuilder faultBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Fault.DEFAULT_ELEMENT_NAME);
        XMLObjectBuilder faultCodeBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(FaultCode.DEFAULT_ELEMENT_NAME);
        Fault fault = (Fault)faultBuilder.buildObject(Fault.DEFAULT_ELEMENT_NAME);
        FaultCode code = (FaultCode)faultCodeBuilder.buildObject(FaultCode.DEFAULT_ELEMENT_NAME);
        if (this.faultCodeLookupStrategy != null) {
            QName fc = this.faultCodeLookupStrategy.apply(profileRequestContext);
            if (fc == null) {
                code.setValue(this.defaultFaultCode);
            } else {
                code.setValue(fc);
            }
        } else {
            code.setValue(this.defaultFaultCode);
        }
        fault.setCode(code);
        if (!this.detailedErrors || this.faultStringLookupStrategy == null) {
            if (this.faultString != null) {
                this.log.debug("{} Setting faultstring to defaulted value", (Object)this.getLogPrefix());
                this.buildFaultString(fault, this.faultString);
            }
        } else if (this.faultStringLookupStrategy != null) {
            String message = this.faultStringLookupStrategy.apply(profileRequestContext);
            if (message != null) {
                this.log.debug("{} Current state of request was mappable, setting faultstring to mapped value", (Object)this.getLogPrefix());
                this.buildFaultString(fault, message);
            } else if (this.faultString != null) {
                this.log.debug("{} Current state of request was not mappable, setting faultstring to defaulted value", (Object)this.getLogPrefix());
                this.buildFaultString(fault, this.faultString);
            }
        }
        return fault;
    }

    private void buildFaultString(@Nonnull Fault fault, @Nonnull @NotEmpty String message) {
        XMLObjectBuilder faultStringBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(FaultString.DEFAULT_ELEMENT_NAME);
        FaultString fs = (FaultString)faultStringBuilder.buildObject(FaultString.DEFAULT_ELEMENT_NAME);
        fs.setValue(message);
        fault.setMessage(fs);
    }

    public static class MessageContextFaultStrategy
    implements Function<ProfileRequestContext, Fault> {
        private Logger log = LoggerFactory.getLogger(MessageContextFaultStrategy.class);

        @Override
        @Nullable
        public Fault apply(@Nullable ProfileRequestContext input) {
            if (input == null) {
                return null;
            }
            Fault fault = null;
            if (input.getOutboundMessageContext() != null && (fault = SOAPMessagingSupport.getSOAP11Fault(input.getOutboundMessageContext())) != null) {
                this.log.debug("Found registered SOAP fault in outbound message context");
                return fault;
            }
            if (input.getInboundMessageContext() != null && (fault = SOAPMessagingSupport.getSOAP11Fault(input.getInboundMessageContext())) != null) {
                this.log.debug("Found registered SOAP fault in inbound message context");
                return fault;
            }
            return null;
        }
    }

    public static class FaultCodeMappingFunction
    implements Function<ProfileRequestContext, QName> {
        @Nonnull
        @NonnullElements
        private Map<String, QName> codeMappings;
        @Nonnull
        private Function<ProfileRequestContext, EventContext> eventContextLookupStrategy;

        public FaultCodeMappingFunction(@Nonnull @NonnullElements Map<String, QName> mappings) {
            Constraint.isNotNull(mappings, (String)"Faultcode mappings cannot be null");
            this.codeMappings = new HashMap<String, QName>(mappings.size());
            for (Map.Entry<String, QName> entry : mappings.entrySet()) {
                String event = StringSupport.trimOrNull((String)entry.getKey());
                if (event == null || entry.getValue() == null) continue;
                this.codeMappings.put(event, entry.getValue());
            }
            this.eventContextLookupStrategy = new CurrentOrPreviousEventLookup();
        }

        public void setEventContextLookupStrategy(@Nonnull Function<ProfileRequestContext, EventContext> strategy) {
            this.eventContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EventContext lookup strategy cannot be null");
        }

        @Override
        @Nullable
        public QName apply(@Nullable ProfileRequestContext input) {
            EventContext eventCtx = this.eventContextLookupStrategy.apply(input);
            if (eventCtx != null && eventCtx.getEvent() != null) {
                return this.codeMappings.get(eventCtx.getEvent().toString());
            }
            return null;
        }
    }
}

