/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wssecurity.impl;

import com.google.common.base.Strings;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.soap.wssecurity.AttributedString;
import org.opensaml.soap.wssecurity.impl.AbstractWSSecurityObjectMarshaller;
import org.w3c.dom.Element;

public class AttributedStringMarshaller
extends AbstractWSSecurityObjectMarshaller {
    @Override
    protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException {
        AttributedString attributedString = (AttributedString)xmlObject;
        if (!Strings.isNullOrEmpty((String)attributedString.getWSUId())) {
            XMLObjectSupport.marshallAttribute(AttributedString.WSU_ID_ATTR_NAME, attributedString.getWSUId(), domElement, true);
        }
        XMLObjectSupport.marshallAttributeMap(attributedString.getUnknownAttributes(), domElement);
    }

    @Override
    protected void marshallAttributeIDness(XMLObject xmlObject, Element domElement) throws MarshallingException {
        XMLObjectSupport.marshallAttributeIDness(AttributedString.WSU_ID_ATTR_NAME, domElement, true);
        super.marshallAttributeIDness(xmlObject, domElement);
    }

    @Override
    protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException {
        AttributedString attributedString = (AttributedString)xmlObject;
        ElementSupport.appendTextContent((Element)domElement, (String)attributedString.getValue());
    }
}

