/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.richclient.framework.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.channelfw.CFEndPoint;
import com.ibm.websphere.channelfw.OutboundChannelDefinition;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.serialization.DeserializationObjectInputStream;
import com.ibm.ws.sib.jfapchannel.framework.Framework;
import com.ibm.ws.sib.jfapchannel.framework.FrameworkException;
import com.ibm.ws.sib.jfapchannel.framework.NetworkTransportFactory;
import com.ibm.ws.sib.jfapchannel.impl.CommsOutboundChain;
import com.ibm.ws.sib.jfapchannel.richclient.framework.impl.ChannelFrameworkReference;
import com.ibm.ws.sib.jfapchannel.richclient.framework.impl.RichClientTransportFactory;
import com.ibm.ws.sib.jfapchannel.richclient.impl.octracker.JFapOutboundChannelDefinitionImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.channelfw.ChannelFramework;
import io.openliberty.netty.internal.exception.NettyException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class RichClientFramework
extends Framework {
    private static final TraceComponent tc = SibTr.register(RichClientFramework.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final String CLASS_NAME = RichClientFramework.class.getName();
    private static ArrayList<CFEndPoint> endPointsList = new ArrayList();
    private ChannelFramework framework = null;

    public RichClientFramework() {
        this(ChannelFrameworkReference.getInstance());
    }

    public RichClientFramework(ChannelFramework framework) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)framework);
        }
        this.framework = framework;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public NetworkTransportFactory getNetworkTransportFactory() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getNetworkTransportFactory");
        }
        RichClientTransportFactory factory = new RichClientTransportFactory();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getNetworkTransportFactory", (Object)factory);
        }
        return factory;
    }

    @Override
    public Map getOutboundConnectionProperties(String outboundTransportName) {
        if (tc.isDebugEnabled()) {
            SibTr.warning((TraceComponent)tc, (String)"RichClientFramework.java#getOutboundConnectionProperties(String outboundTransportName) called - not supported");
        }
        return null;
    }

    @Override
    public Map getOutboundConnectionProperties(Object ep) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getOutboundConnectionProperties", (Object)ep);
        }
        Map properties = null;
        if (ep instanceof CFEndPoint) {
            String chainName = ((CFEndPoint)ep).getName();
            CommsOutboundChain chain = CommsOutboundChain.getChainDetails(chainName);
            if (chain != null && chain.useNetty()) {
                throw new SIErrorException((Throwable)new NettyException("Chain " + chainName + "was set up to use Netty but code path has not been updated to allow Netty."));
            }
            OutboundChannelDefinition[] channelDefinitions = (OutboundChannelDefinition[])((CFEndPoint)ep).getOutboundChannelDefs().toArray();
            if (channelDefinitions.length < 1) {
                throw new SIErrorException(nls.getFormattedMessage("OUTCONNTRACKER_INTERNAL_SICJ0064", null, "OUTCONNTRACKER_INTERNAL_SICJ0064"));
            }
            properties = channelDefinitions[0].getOutboundChannelProperties();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getOutboundConnectionProperties", properties);
        }
        return properties;
    }

    @Override
    public Object prepareOutboundConnection(Object ep) throws FrameworkException {
        CFEndPoint originalEndPoint;
        String chainName;
        CommsOutboundChain chain;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"prepareOutboundConnection", (Object)ep);
        }
        if ((chain = CommsOutboundChain.getChainDetails(chainName = (originalEndPoint = (CFEndPoint)ep).getName())) != null && chain.useNetty()) {
            throw new SIErrorException((Throwable)new NettyException("Chain " + chainName + "was set up to use Netty but code path has not been updated to allow Netty."));
        }
        CFEndPoint endPoint = this.cloneEndpoint(originalEndPoint);
        Class<?> tcpChannelFactory = null;
        try {
            boolean targetThreadpoolExists = false;
            if (targetThreadpoolExists) {
                tcpChannelFactory = Class.forName("com.ibm.ws.tcp.channel.impl.WSTCPChannelFactory");
                HashMap<String, String> tcpProps = new HashMap<String, String>();
                tcpProps.put("threadPoolName", "SIBFAPThreadPool");
                this.modifyEndpointChannelProperties(endPoint, tcpChannelFactory, tcpProps, false);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Cannot find threadpool: SIBFAPThreadPool using default");
            }
        }
        catch (ClassNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".prepareEndPoint"), (String)"00290002", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unable to load TCP Channel", (Object)e);
            }
            throw new FrameworkException(e);
        }
        for (CFEndPoint tempEndPoint : endPointsList) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Comparing the Endpoints from list , sent from trm ", (Object)new Object[]{tempEndPoint, endPoint});
            }
            if (!this.areEndPointsEqual(tempEndPoint, endPoint)) continue;
            return tempEndPoint;
        }
        endPointsList.add(endPoint);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepareOutboundConnection", (Object)endPoint);
        }
        return endPoint;
    }

    private void modifyEndpointChannelProperties(CFEndPoint endPoint, Class<?> channelFactoryClass, Map properties, boolean overwriteExisting) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"modifyEndpointChannelProperties", (Object)new Object[]{endPoint, channelFactoryClass, properties, "" + overwriteExisting});
        }
        OutboundChannelDefinition[] outboundChannelDefs = (OutboundChannelDefinition[])endPoint.getOutboundChannelDefs().toArray();
        Class factoryClass = null;
        OutboundChannelDefinition existingChannelDef = null;
        int index = 0;
        boolean foundChannel = false;
        for (index = 0; index < outboundChannelDefs.length; ++index) {
            existingChannelDef = outboundChannelDefs[index];
            factoryClass = outboundChannelDefs[index].getOutboundFactory();
            if (!channelFactoryClass.isAssignableFrom(factoryClass)) continue;
            foundChannel = true;
            break;
        }
        if (foundChannel) {
            JFapOutboundChannelDefinitionImpl newChannelDef = new JFapOutboundChannelDefinitionImpl(existingChannelDef, properties, overwriteExisting);
            outboundChannelDefs[index] = newChannelDef;
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Did not find desired channel");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"modifyEndpointChannelProperties");
        }
    }

    @Override
    public InetAddress getHostAddress(Object endPoint) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getHostAddress", (Object)endPoint);
        }
        InetAddress address = null;
        if (endPoint instanceof CFEndPoint) {
            address = ((CFEndPoint)endPoint).getAddress();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getHostAddress", (Object)address);
        }
        return address;
    }

    @Override
    public int getHostPort(Object endPoint) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getHostPort", (Object)endPoint);
        }
        int port = 0;
        if (endPoint instanceof CFEndPoint) {
            port = ((CFEndPoint)endPoint).getPort();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getHostPort", (Object)port);
        }
        return port;
    }

    @Override
    public boolean areEndPointsEqual(Object ep1, Object ep2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"areEndPointsEqual", (Object)new Object[]{ep1, ep2});
        }
        boolean isEqual = false;
        if (ep1 instanceof CFEndPoint && ep2 instanceof CFEndPoint) {
            CFEndPoint cfEp1 = (CFEndPoint)ep1;
            CFEndPoint cfEp2 = (CFEndPoint)ep2;
            boolean bl = isEqual = this.isEqual(cfEp1.getAddress(), cfEp2.getAddress()) && this.isEqual(cfEp1.getName(), cfEp2.getName()) && cfEp1.getPort() == cfEp2.getPort() && cfEp1.isLocal() == cfEp2.isLocal() && cfEp1.isSSLEnabled() == cfEp2.isSSLEnabled();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"areEndPointsEqual", (Object)isEqual);
        }
        return isEqual;
    }

    @Override
    public int getEndPointHashCode(Object ep) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getEndPointHashCode", (Object)ep);
        }
        int hashCode = 0;
        if (ep instanceof CFEndPoint) {
            CFEndPoint cfEndPoint = (CFEndPoint)ep;
            if (cfEndPoint.getAddress() != null) {
                hashCode ^= cfEndPoint.getAddress().hashCode();
            }
            if (cfEndPoint.getName() != null) {
                hashCode ^= cfEndPoint.getName().hashCode();
            }
        }
        if (hashCode == 0) {
            hashCode ^= ep.hashCode();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getEndPointHashCode", (Object)hashCode);
        }
        return hashCode;
    }

    private boolean isEqual(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null && o2 != null || o1 != null && o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CFEndPoint cloneEndpoint(CFEndPoint originalEndPoint) {
        CFEndPoint endPoint;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"cloneEndpoint", (Object)originalEndPoint);
        }
        ByteArrayOutputStream baos = null;
        ObjectOutputStream out = null;
        ObjectInputStream in = null;
        try {
            baos = new ByteArrayOutputStream();
            out = new ObjectOutputStream(baos);
            out.writeObject(originalEndPoint);
            out.flush();
            ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
            in = new DeserializationObjectInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()), cl);
            endPoint = (CFEndPoint)in.readObject();
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".cloneEndpoint"), (String)"00290004", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught IOException copying endpoint", (Object)e);
            }
            endPoint = originalEndPoint;
        }
        catch (ClassNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".cloneEndpoint"), (String)"00290005", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught ClassNotFoundException copying endpoint", (Object)e);
            }
            endPoint = originalEndPoint;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {}
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"cloneEndpoint", (Object)endPoint);
        }
        return endPoint;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.rich.impl/src/com/ibm/ws/sib/jfapchannel/framework/impl/RichClientFramework.java, SIB.comms, WASX.SIB, uu1215.01 1.8");
        }
    }
}

