/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.trust.delegation;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rt.security.utils.SecurityUtils;
import org.apache.cxf.ws.security.trust.delegation.DelegationCallback;
import org.apache.wss4j.dom.message.token.UsernameToken;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WSSUsernameCallbackHandler
implements CallbackHandler {
    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        int i = 0;
        while (i < callbacks.length) {
            if (callbacks[i] instanceof DelegationCallback) {
                DelegationCallback callback = (DelegationCallback)callbacks[i];
                Message message = callback.getCurrentMessage();
                String username = (String)SecurityUtils.getSecurityPropertyValue((String)"security.username", (Message)message);
                if (username != null) {
                    Node contentNode = (Node)message.getContent(Node.class);
                    Document doc = contentNode != null ? contentNode.getOwnerDocument() : DOMUtils.getEmptyDocument();
                    UsernameToken usernameToken = this.createWSSEUsernameToken(username, doc);
                    callback.setToken(usernameToken.getElement());
                }
            } else {
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
            ++i;
        }
    }

    private UsernameToken createWSSEUsernameToken(String username, Document doc) {
        UsernameToken usernameToken = new UsernameToken(true, doc, null);
        usernameToken.setName(username);
        usernameToken.addWSUNamespace();
        usernameToken.addWSSENamespace();
        usernameToken.setID("id-" + username);
        return usernameToken;
    }
}

