/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.zipkin;

import zipkin2.Span;
import zipkin2.codec.BytesEncoder;
import zipkin2.reporter.Encoding;

final class BytesEncoderAdapter
implements zipkin2.reporter.BytesEncoder<Span> {
    private final BytesEncoder<Span> delegate;
    private final Encoding encoding;

    BytesEncoderAdapter(BytesEncoder<Span> delegate) {
        this.delegate = delegate;
        switch (delegate.encoding()) {
            case JSON: {
                this.encoding = Encoding.JSON;
                break;
            }
            case PROTO3: {
                this.encoding = Encoding.PROTO3;
                break;
            }
            case THRIFT: {
                this.encoding = Encoding.THRIFT;
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported encoding " + delegate.encoding());
            }
        }
    }

    public Encoding encoding() {
        return this.encoding;
    }

    public int sizeInBytes(Span span) {
        return this.delegate.sizeInBytes((Object)span);
    }

    public byte[] encode(Span span) {
        return this.delegate.encode((Object)span);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

