/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.db;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.DbClientCommonAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlClientAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlClientAttributesGetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlStatementInfo;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlStatementSanitizer;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;

public final class SqlClientAttributesExtractor<REQUEST, RESPONSE>
extends DbClientCommonAttributesExtractor<REQUEST, RESPONSE, SqlClientAttributesGetter<REQUEST>> {
    private static final AttributeKey<String> DB_OPERATION = AttributeKey.stringKey("db.operation");
    private static final AttributeKey<String> DB_STATEMENT = AttributeKey.stringKey("db.statement");
    private static final String SQL_CALL = "CALL";
    private static final SqlStatementSanitizer sanitizer = SqlStatementSanitizer.create(true);
    private final AttributeKey<String> dbTableAttribute;
    private final boolean statementSanitizationEnabled;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(SqlClientAttributesGetter<REQUEST> getter) {
        return SqlClientAttributesExtractor.builder(getter).build();
    }

    public static <REQUEST, RESPONSE> SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE> builder(SqlClientAttributesGetter<REQUEST> getter) {
        return new SqlClientAttributesExtractorBuilder(getter);
    }

    SqlClientAttributesExtractor(SqlClientAttributesGetter<REQUEST> getter, AttributeKey<String> dbTableAttribute, boolean statementSanitizationEnabled) {
        super(getter);
        this.dbTableAttribute = dbTableAttribute;
        this.statementSanitizationEnabled = statementSanitizationEnabled;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        super.onStart(attributes, parentContext, request);
        String rawStatement = ((SqlClientAttributesGetter)this.getter).getRawStatement(request);
        SqlStatementInfo sanitizedStatement = sanitizer.sanitize(rawStatement);
        String operation = sanitizedStatement.getOperation();
        AttributesExtractorUtil.internalSet(attributes, DB_STATEMENT, this.statementSanitizationEnabled ? sanitizedStatement.getFullStatement() : rawStatement);
        AttributesExtractorUtil.internalSet(attributes, DB_OPERATION, operation);
        if (!SQL_CALL.equals(operation)) {
            AttributesExtractorUtil.internalSet(attributes, this.dbTableAttribute, sanitizedStatement.getMainIdentifier());
        }
    }
}

