/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.interceptor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.jaxws.wsat.Constants;
import com.ibm.ws.jaxws.wsat.components.WSATConfigService;
import com.ibm.ws.wsat.utils.WSCoorUtil;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class SSLServerInterceptor
extends AbstractPhaseInterceptor<Message> {
    final TraceComponent tc = Tr.register(SSLServerInterceptor.class, (String)"WSAT", null);
    private static final String PEER_CERTIFICATES = "javax.net.ssl.peer_certificates";

    public SSLServerInterceptor() {
        super("receive");
        this.getAfter().add(Constants.WS_INTERCEPTOR_CLASSNAME);
    }

    public void handleMessage(Message msg) throws Fault {
        HttpServletRequest request;
        X509Certificate[] certChain;
        WSATConfigService s = WSCoorUtil.getConfigService();
        if (null == s) {
            throw new Fault("WSAT configuration service is not avaliable", this.tc.getLogger());
        }
        if (s.isSSLEnabled() && s.isClientAuthEnabled() && (null == (certChain = (X509Certificate[])(request = (HttpServletRequest)msg.get((Object)"HTTP.REQUEST")).getAttribute(PEER_CERTIFICATES)) || 0 == certChain.length)) {
            throw new Fault("NOT be able to get any certificate to verify, the certificate from client is either INVALID or NULL", this.tc.getLogger());
        }
    }
}

