/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.decorator.Decorator;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AfterTypeDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.enterprise.inject.spi.ProcessInjectionTarget;
import jakarta.enterprise.inject.spi.ProcessSessionBean;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.resteasy.cdi.ContextProducers;
import org.jboss.resteasy.cdi.JaxrsInjectionTarget;
import org.jboss.resteasy.cdi.Utils;
import org.jboss.resteasy.cdi.i18n.LogMessages;
import org.jboss.resteasy.cdi.i18n.Messages;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class ResteasyCdiExtension
implements Extension {
    private static boolean active;
    private static final String JAKARTA_EJB_STATELESS = "jakarta.ejb.Stateless";
    private static final String JAKARTA_EJB_SINGLETON = "jakarta.ejb.Singleton";
    private static final Annotation requestScopedLiteral;
    protected static final Annotation applicationScopedLiteral;
    private final Map<Class<?>, Type> sessionBeanInterface = new HashMap();
    private boolean generateClientBean = true;
    private boolean addContextProducers = true;
    private boolean noApplicationFound = true;
    static final long serialVersionUID = 2748082802261289494L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static boolean isCDIActive() {
        return active;
    }

    public void observeBeforeBeanDiscovery(@Observes BeforeBeanDiscovery event) {
        active = true;
    }

    public void processClientBean(@Observes ProcessBean<?> pb) {
        Set qualifiers;
        if (pb.getBean().getTypes().contains(Client.class) && (qualifiers = pb.getBean().getQualifiers()).contains(Any.Literal.INSTANCE) && qualifiers.contains(Default.Literal.INSTANCE)) {
            this.generateClientBean = false;
        }
    }

    public void registerClientProducer(@Observes AfterBeanDiscovery event) {
        if (this.generateClientBean) {
            event.addBean().addTransitiveTypeClosure(Client.class).scope(ApplicationScoped.class).produceWith(instance -> ClientBuilder.newClient((Configuration)RegisterBuiltin.getClientInitializedResteasyProviderFactory((ClassLoader)ResteasyCdiExtension.getClassLoader()))).disposeWith((client, instance) -> client.close());
        }
    }

    public void observeContextProducer(@Observes ProcessAnnotatedType<ContextProducers> event) {
        this.addContextProducers = false;
    }

    public void addContextProducer(@Observes AfterTypeDiscovery event, BeanManager beanManager) {
        if (this.addContextProducers) {
            AnnotatedType producersAnnotatedType = beanManager.createAnnotatedType(ContextProducers.class);
            event.addAnnotatedType(producersAnnotatedType, ContextProducers.class.getCanonicalName());
        }
        if (this.noApplicationFound) {
            AnnotatedType annotatedType = beanManager.createAnnotatedType(Application.class);
            event.addAnnotatedType(annotatedType, Application.class.getCanonicalName());
        }
    }

    public <T> void observeResources(@WithAnnotations(value={Path.class}) @Observes ProcessAnnotatedType<T> event, BeanManager beanManager) {
        AnnotatedType annotatedType = event.getAnnotatedType();
        if (!(annotatedType.getJavaClass().isInterface() || this.isSessionBean(annotatedType) || annotatedType.isAnnotationPresent(Decorator.class) || Utils.isScopeDefined(annotatedType, beanManager))) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.discoveredCDIBeanJaxRsResource(annotatedType.getJavaClass().getCanonicalName()));
            event.configureAnnotatedType().add(requestScopedLiteral);
        }
    }

    public <T> void observeProviders(@WithAnnotations(value={Provider.class}) @Observes ProcessAnnotatedType<T> event, BeanManager beanManager) {
        AnnotatedType annotatedType = event.getAnnotatedType();
        if (!(annotatedType.getJavaClass().isInterface() || this.isSessionBean(annotatedType) || this.isUnproxyableClass(annotatedType.getJavaClass()) || Utils.isScopeDefined(annotatedType, beanManager))) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.discoveredCDIBeanJaxRsProvider(annotatedType.getJavaClass().getCanonicalName()));
            event.configureAnnotatedType().add(applicationScopedLiteral);
        }
    }

    public <T extends Application> void observeApplications(@Observes ProcessAnnotatedType<T> event, BeanManager beanManager) {
        this.noApplicationFound = false;
        if (!Utils.isScopeDefined(event.getAnnotatedType(), beanManager)) {
            event.configureAnnotatedType().add(applicationScopedLiteral);
        }
    }

    public <T> void observeInjectionTarget(@Observes ProcessInjectionTarget<T> event) {
        if (Utils.isJaxrsComponent(event.getAnnotatedType().getJavaClass())) {
            event.setInjectionTarget(this.wrapInjectionTarget(event));
        }
    }

    protected <T> InjectionTarget<T> wrapInjectionTarget(ProcessInjectionTarget<T> event) {
        return new JaxrsInjectionTarget(event.getInjectionTarget(), event.getAnnotatedType().getJavaClass());
    }

    public <T> void observeSessionBeans(@Observes ProcessSessionBean<T> event) {
        Bean sessionBean = event.getBean();
        if (Utils.isJaxrsComponent(sessionBean.getBeanClass())) {
            this.addSessionBeanInterface(sessionBean);
        }
    }

    private void addSessionBeanInterface(Bean<?> bean) {
        for (Type type : bean.getTypes()) {
            Class clazz;
            if (!(type instanceof Class) || !((Class)type).isInterface() || !Utils.isJaxrsAnnotatedClass(clazz = (Class)type)) continue;
            this.sessionBeanInterface.put(bean.getBeanClass(), type);
            LogMessages.LOGGER.debug(Messages.MESSAGES.typeWillBeUsedForLookup(type, bean.getBeanClass()));
            return;
        }
        LogMessages.LOGGER.debug(Messages.MESSAGES.noLookupInterface(bean.getBeanClass()));
    }

    public Map<Class<?>, Type> getSessionBeanInterface() {
        return this.sessionBeanInterface;
    }

    private boolean isSessionBean(AnnotatedType<?> annotatedType) {
        for (Annotation annotation : annotatedType.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!annotationType.getName().equals(JAKARTA_EJB_STATELESS) && !annotationType.getName().equals(JAKARTA_EJB_SINGLETON)) continue;
            LogMessages.LOGGER.debug(Messages.MESSAGES.beanIsSLSBOrSingleton(annotatedType.getJavaClass()));
            return true;
        }
        return false;
    }

    private boolean isUnproxyableClass(Class<?> clazz) {
        return this.isFinal(clazz) || this.hasNonPrivateNonStaticFinalMethod(clazz) || this.hasNoNonPrivateNoArgsConstructor(clazz);
    }

    private boolean isFinal(Class<?> clazz) {
        return Modifier.isFinal(clazz.getModifiers());
    }

    private boolean hasNonPrivateNonStaticFinalMethod(Class<?> type) {
        for (Class<?> clazz = type; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!this.isFinal(method) || this.isPrivate(method) || this.isStatic(method)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasNoNonPrivateNoArgsConstructor(Class<?> clazz) {
        Constructor<?> constructor;
        try {
            constructor = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException exception) {
            return true;
        }
        return this.isPrivate(constructor);
    }

    private boolean isFinal(Member member) {
        return Modifier.isFinal(member.getModifiers());
    }

    private boolean isPrivate(Member member) {
        return Modifier.isPrivate(member.getModifiers());
    }

    private boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    private static ClassLoader getClassLoader() {
        if (System.getSecurityManager() == null) {
            ClassLoader result = Thread.currentThread().getContextClassLoader();
            if (result == null) {
                result = ResteasyCdiExtension.class.getClassLoader();
            }
            return result;
        }
        return AccessController.doPrivileged(() -> {
            ClassLoader result = Thread.currentThread().getContextClassLoader();
            if (result == null) {
                result = ResteasyCdiExtension.class.getClassLoader();
            }
            return result;
        });
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.cdi.ResteasyCdiExtension", ResteasyCdiExtension.class, null, null);
        requestScopedLiteral = new AnnotationLiteral<RequestScoped>(){
            private static final long serialVersionUID = 3381824686081435817L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.cdi.ResteasyCdiExtension$1", 1.class, null, null);
            }
        };
        applicationScopedLiteral = new AnnotationLiteral<ApplicationScoped>(){
            private static final long serialVersionUID = -8211157243671012820L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.cdi.ResteasyCdiExtension$2", 2.class, null, null);
            }
        };
    }
}

