/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.beanvalidation.v20.cdi.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.beanvalidation.service.BvalManagedObjectBuilder;
import com.ibm.ws.cdi.CDIService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.managedobject.ManagedObject;
import com.ibm.ws.managedobject.ManagedObjectException;
import com.ibm.ws.managedobject.ManagedObjectFactory;
import com.ibm.ws.managedobject.ManagedObjectService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.BootstrapConfiguration;
import javax.validation.ClockProvider;
import javax.validation.Configuration;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import javax.validation.valueextraction.ValueExtractor;
import org.hibernate.validator.cdi.spi.InjectingConstraintValidatorFactory;
import org.hibernate.validator.internal.engine.valueextraction.ValueExtractorDescriptor;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"type=BvalMOBuilder"})
public class BvalManagedObjectBuilderImpl
implements BvalManagedObjectBuilder {
    private static final TraceComponent tc = Tr.register(BvalManagedObjectBuilderImpl.class, (String)"BeanValidation", (String)"com.ibm.ws.beanvalidation.v20.cdi.internal.BVNLSMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS(BvalManagedObjectBuilderImpl.class, (String)"com.ibm.ws.beanvalidation.resources.nls.BVNLSMessages");
    private static final String REFERENCE_CDI_SERVICE = "cdiService";
    private static final String REFERENCE_MANAGED_OBJECT_SERVICE = "managedObjectService";
    private final AtomicServiceReference<CDIService> cdiService = new AtomicServiceReference("cdiService");
    private final AtomicServiceReference<ManagedObjectService> managedObjectServiceRef = new AtomicServiceReference("managedObjectService");
    static final long serialVersionUID = 9007318520704740013L;

    public ValidatorFactory injectValidatorFactoryResources(Configuration<?> config, ClassLoader appClassLoader, Version runtimeVersion) {
        if (((CDIService)this.cdiService.getServiceWithException()).isCurrentModuleCDIEnabled()) {
            this.createManagedConstraintValidatorFactory(config, appClassLoader, runtimeVersion);
            this.createManagedMessageInterpolator(config, appClassLoader);
            this.createManagedTraversableResolver(config, appClassLoader);
            this.createManagedParameterNameProvider(config, appClassLoader);
            this.createManagedClockProvider(config, appClassLoader);
            this.addValueExtractorBeans(config, appClassLoader);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Current module is not CDI enabled, skipping creating CDI enhanced objects.", (Object[])new Object[0]);
        }
        return config.buildValidatorFactory();
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.cdiService.activate(cc);
        this.managedObjectServiceRef.activate(cc);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.cdiService.deactivate(cc);
        this.managedObjectServiceRef.deactivate(cc);
    }

    @Reference(name="cdiService", service=CDIService.class)
    protected void setCdiService(ServiceReference<CDIService> ref) {
        this.cdiService.setReference(ref);
    }

    protected void unsetCdiService(ServiceReference<CDIService> ref) {
        this.cdiService.unsetReference(ref);
    }

    @Reference(name="managedObjectService", service=ManagedObjectService.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setManagedObjectService(ServiceReference<ManagedObjectService> ref) {
        this.managedObjectServiceRef.setReference(ref);
    }

    protected void unsetManagedObjectService(ServiceReference<ManagedObjectService> ref) {
        this.managedObjectServiceRef.unsetReference(ref);
    }

    private void createManagedMessageInterpolator(Configuration<?> config, ClassLoader appClassLoader) {
        BootstrapConfiguration bootstrapConfiguration = config.getBootstrapConfiguration();
        String messageInterpolatorClassName = bootstrapConfiguration.getMessageInterpolatorClassName();
        MessageInterpolator mi = null;
        if (messageInterpolatorClassName == null) {
            mi = config.getDefaultMessageInterpolator();
        } else {
            Class<?> messageInterpolatorClass = this.loadClass(messageInterpolatorClassName, appClassLoader);
            mi = (MessageInterpolator)this.createManagedObject(messageInterpolatorClass);
        }
        config.messageInterpolator(mi);
    }

    private void createManagedTraversableResolver(Configuration<?> config, ClassLoader appClassLoader) {
        BootstrapConfiguration bootstrapConfiguration = config.getBootstrapConfiguration();
        String traversableResolverClassName = bootstrapConfiguration.getTraversableResolverClassName();
        TraversableResolver tr = null;
        if (traversableResolverClassName == null) {
            tr = config.getDefaultTraversableResolver();
        } else {
            Class<?> traversableResolverClass = this.loadClass(traversableResolverClassName, appClassLoader);
            tr = (TraversableResolver)this.createManagedObject(traversableResolverClass);
        }
        config.traversableResolver(tr);
    }

    private void createManagedParameterNameProvider(Configuration<?> config, ClassLoader appClassLoader) {
        BootstrapConfiguration bootstrapConfiguration = config.getBootstrapConfiguration();
        String parameterNameProviderClassName = bootstrapConfiguration.getParameterNameProviderClassName();
        ParameterNameProvider pnp = null;
        if (parameterNameProviderClassName == null) {
            pnp = config.getDefaultParameterNameProvider();
        } else {
            Class<?> parameterNameProviderClass = this.loadClass(parameterNameProviderClassName, appClassLoader);
            pnp = (ParameterNameProvider)this.createManagedObject(parameterNameProviderClass);
        }
        config.parameterNameProvider(pnp);
    }

    private void createManagedClockProvider(Configuration<?> config, ClassLoader appClassLoader) {
        BootstrapConfiguration bootstrapConfiguration = config.getBootstrapConfiguration();
        String clockProviderClassName = bootstrapConfiguration.getClockProviderClassName();
        ClockProvider clockProvider = null;
        if (clockProviderClassName == null) {
            clockProvider = config.getDefaultClockProvider();
        } else {
            Class<?> clockProviderClass = this.loadClass(clockProviderClassName, appClassLoader);
            clockProvider = (ClockProvider)this.createManagedObject(clockProviderClass);
        }
        config.clockProvider(clockProvider);
    }

    private void createManagedConstraintValidatorFactory(Configuration<?> config, ClassLoader appClassLoader, Version runtimeVersion) {
        BootstrapConfiguration configSource = config.getBootstrapConfiguration();
        String constraintValidatorFactoryClassName = configSource.getConstraintValidatorFactoryClassName();
        ConstraintValidatorFactory cvf = null;
        if (constraintValidatorFactoryClassName == null) {
            cvf = this.isBeanValidationVersion31(runtimeVersion) ? (ConstraintValidatorFactory)this.createManagedObject(InjectingConstraintValidatorFactory.class) : (ConstraintValidatorFactory)this.createManagedObject(org.hibernate.validator.cdi.internal.InjectingConstraintValidatorFactory.class);
        } else {
            Class<?> constraintValidatorFactoryClass = this.loadClass(constraintValidatorFactoryClassName, appClassLoader);
            cvf = (ConstraintValidatorFactory)this.createManagedObject(constraintValidatorFactoryClass);
        }
        config.constraintValidatorFactory(cvf);
    }

    private void addValueExtractorBeans(Configuration<?> config, ClassLoader appClassLoader) {
        Map valueExtractorDescriptors = this.createValidationXmlValueExtractors(config, appClassLoader).stream().collect(Collectors.toMap(ValueExtractorDescriptor::getKey, Function.identity()));
        for (ValueExtractorDescriptor serviceLoaderValueExtractorDescriptor : this.createServiceLoaderValueExtractors()) {
            valueExtractorDescriptors.putIfAbsent(serviceLoaderValueExtractorDescriptor.getKey(), serviceLoaderValueExtractorDescriptor);
        }
        for (ValueExtractorDescriptor valueExtractorDescriptor : valueExtractorDescriptors.values()) {
            config.addValueExtractor(valueExtractorDescriptor.getValueExtractor());
        }
    }

    private Set<ValueExtractorDescriptor> createValidationXmlValueExtractors(Configuration<?> config, ClassLoader appClassLoader) {
        BootstrapConfiguration bootstrapConfiguration = config.getBootstrapConfiguration();
        Set valueExtractorClassNames = bootstrapConfiguration.getValueExtractorClassNames();
        Set<ValueExtractorDescriptor> valueExtractorDescriptors = valueExtractorClassNames.stream().map(fqcn -> (ValueExtractor)this.createManagedObject(this.loadClass((String)fqcn, appClassLoader))).map(valueExtractor -> new ValueExtractorDescriptor(valueExtractor)).collect(Collectors.toSet());
        return valueExtractorDescriptors;
    }

    private Set<ValueExtractorDescriptor> createServiceLoaderValueExtractors() {
        HashSet<ValueExtractorDescriptor> valueExtractorDescriptors = new HashSet<ValueExtractorDescriptor>();
        List valueExtractors = AccessController.doPrivileged(() -> new GetInstancesFromServiceLoader().run());
        for (ValueExtractor valueExtractor : valueExtractors) {
            valueExtractorDescriptors.add(new ValueExtractorDescriptor((ValueExtractor)this.createManagedObject(valueExtractor.getClass())));
        }
        return valueExtractorDescriptors;
    }

    /*
     * WARNING - void declaration
     */
    private <T> ManagedObjectFactory<T> getManagedBeanManagedObjectFactory(Class<T> clazz) {
        ModuleMetaData mmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData().getModuleMetaData();
        ManagedObjectService managedObjectService = (ManagedObjectService)this.managedObjectServiceRef.getServiceWithException();
        try {
            ManagedObjectFactory factory = managedObjectService.createManagedObjectFactory(mmd, clazz, true);
            return factory;
        }
        catch (ManagedObjectException factory) {
            void e;
            FFDCFilter.processException((Throwable)factory, (String)"com.ibm.ws.beanvalidation.v20.cdi.internal.BvalManagedObjectBuilderImpl", (String)"311", (Object)this, (Object[])new Object[]{clazz});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Failed to create a ManagedObjectFactory for " + clazz.getName()), (Object[])new Object[]{e});
            }
            throw new ValidationException(nls.getString("BVKEY_UNABLE_TO_CREATE_VALIDATION_FACTORY", "BVKEY_UNABLE_TO_CREATE_VALIDATION_FACTORY"), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private <T> T createManagedObject(Class<T> clazz) {
        ManagedObject mo;
        ManagedObjectFactory<T> mof = this.getManagedBeanManagedObjectFactory(clazz);
        try {
            mo = mof.createManagedObject();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.beanvalidation.v20.cdi.internal.BvalManagedObjectBuilderImpl", (String)"325", (Object)this, (Object[])new Object[]{clazz});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Failed to create a ManagedObject using a ManagedObjectFactory for class type " + mof.getManagedObjectClass()), (Object[])new Object[]{e});
            }
            throw new ValidationException(nls.getString("BVKEY_UNABLE_TO_CREATE_VALIDATION_FACTORY", "BVKEY_UNABLE_TO_CREATE_VALIDATION_FACTORY"), (Throwable)e);
        }
        return (T)mo.getObject();
    }

    /*
     * WARNING - void declaration
     */
    private Class<?> loadClass(String className, ClassLoader appClassLoader) {
        try {
            return Class.forName(className, true, appClassLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            void e;
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.beanvalidation.v20.cdi.internal.BvalManagedObjectBuilderImpl", (String)"336", (Object)this, (Object[])new Object[]{className, appClassLoader});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Class " + className + " not found during CDI enablement of the ValidatorFactory."), (Object[])new Object[]{e});
            }
            throw new ValidationException(nls.getString("BVKEY_UNABLE_TO_CREATE_VALIDATION_FACTORY", "BVKEY_UNABLE_TO_CREATE_VALIDATION_FACTORY"), (Throwable)e);
        }
    }

    private boolean isBeanValidationVersion31(Version runtimeVersion) {
        return runtimeVersion.compareTo(new Version(3, 1, 0)) == 0;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class GetInstancesFromServiceLoader
    implements PrivilegedAction<List<ValueExtractor>> {
        static final long serialVersionUID = -8877099817419028840L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private GetInstancesFromServiceLoader() {
        }

        public static <T> List<T> action(ClassLoader primaryClassLoader, Class<T> serviceClass) {
            List<T> instances = GetInstancesFromServiceLoader.loadInstances(primaryClassLoader, serviceClass);
            if (instances.isEmpty() && GetInstancesFromServiceLoader.class.getClassLoader() != primaryClassLoader) {
                instances = GetInstancesFromServiceLoader.loadInstances(GetInstancesFromServiceLoader.class.getClassLoader(), serviceClass);
            }
            return instances;
        }

        private static <T> List<T> loadInstances(ClassLoader classloader, Class<T> clazz) {
            ServiceLoader<T> loader = ServiceLoader.load(clazz, classloader);
            Iterator<T> iterator = loader.iterator();
            ArrayList<T> instances = new ArrayList<T>();
            while (iterator.hasNext()) {
                try {
                    instances.add(iterator.next());
                }
                catch (ServiceConfigurationError serviceConfigurationError) {
                    FFDCFilter.processException((Throwable)serviceConfigurationError, (String)"com.ibm.ws.beanvalidation.v20.cdi.internal.BvalManagedObjectBuilderImpl$GetInstancesFromServiceLoader", (String)"108", null, (Object[])new Object[]{classloader, clazz});
                    Tr.debug((TraceComponent)tc, (String)"unableToLoadInstanceOfService", (Object[])new Object[0]);
                }
            }
            return instances;
        }

        @Override
        public List<ValueExtractor> run() {
            return GetInstancesFromServiceLoader.action(Thread.currentThread().getContextClassLoader(), ValueExtractor.class);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.beanvalidation.v20.cdi.internal.BvalManagedObjectBuilderImpl$GetInstancesFromServiceLoader", GetInstancesFromServiceLoader.class, (String)"BeanValidation", (String)"com.ibm.ws.beanvalidation.v20.cdi.internal.BVNLSMessages");
        }
    }
}

